/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.request;

import java.util.Arrays;
import java.util.List;
import net.opengis.ows10.Ows10Factory;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wfs20.GetCapabilitiesType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.request.RequestObject;

public abstract class GetCapabilitiesRequest
extends RequestObject {
    private String[] acceptLanguages;

    public static GetCapabilitiesRequest adapt(Object request) {
        if (request instanceof net.opengis.wfs.GetCapabilitiesType) {
            return new WFS11((EObject)request);
        }
        if (request instanceof GetCapabilitiesType) {
            return new WFS20((EObject)request);
        }
        return null;
    }

    protected GetCapabilitiesRequest(EObject adaptee) {
        super(adaptee);
    }

    public List<String> getSections() {
        return this.eGet(this.adaptee, "sections.section", List.class);
    }

    public String getUpdateSequence() {
        return this.eGet(this.adaptee, "updateSequence", String.class);
    }

    public List<String> getAcceptVersions() {
        return this.eGet(this.adaptee, "acceptVersions.version", List.class);
    }

    public List<String> getAcceptFormats() {
        return this.eGet(this.adaptee, "acceptFormats.outputFormat", List.class);
    }

    public void setAcceptVersions(String ... versions) {
        Object acceptedVersions = this.createAcceptedVersions();
        this.eAdd(acceptedVersions, "version", Arrays.asList(versions));
        this.eSet(this.adaptee, "acceptVersions", acceptedVersions);
    }

    public String getNamespace() {
        return this.eGet(this.adaptee, "namespace", String.class);
    }

    public void setNamespace(String namespace) {
        this.eSet(this.adaptee, "namespace", namespace);
    }

    protected abstract Object createAcceptedVersions();

    public String[] getAcceptLanguages() {
        return this.acceptLanguages;
    }

    public void setAcceptLanguages(String[] acceptLanguages) {
        this.acceptLanguages = acceptLanguages;
    }

    public static class WFS20
    extends GetCapabilitiesRequest {
        public WFS20(EObject adaptee) {
            super(adaptee);
        }

        @Override
        protected Object createAcceptedVersions() {
            return Ows11Factory.eINSTANCE.createAcceptVersionsType();
        }
    }

    public static class WFS11
    extends GetCapabilitiesRequest {
        public WFS11(EObject adaptee) {
            super(adaptee);
        }

        @Override
        protected Object createAcceptedVersions() {
            return Ows10Factory.eINSTANCE.createAcceptVersionsType();
        }
    }
}

