/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import net.opengis.wfs20.DropStoredQueryType;
import net.opengis.wfs20.ExecutionStatusType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;

public class DropStoredQuery {
    WFSInfo wfs;
    StoredQueryProvider storedQueryProvider;

    public DropStoredQuery(WFSInfo wfs, StoredQueryProvider storedQueryProvider) {
        this.wfs = wfs;
        this.storedQueryProvider = storedQueryProvider;
    }

    public ExecutionStatusType run(DropStoredQueryType request) throws WFSException {
        if (this.wfs.isDisableStoredQueriesManagement()) {
            throw new WFSException("Stored queries management is disabled");
        }
        if (request.getId() == null) {
            throw new WFSException((EObject)request, "No stored query id specified");
        }
        StoredQuery query = this.storedQueryProvider.getStoredQuery(request.getId());
        if (query == null) {
            WFSException exception = new WFSException((EObject)request, String.format("Stored query %s does not exist.", request.getId()), "InvalidParameterValue");
            exception.setLocator("id");
            throw exception;
        }
        this.storedQueryProvider.removeStoredQuery(query);
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        ExecutionStatusType response = factory.createExecutionStatusType();
        response.setStatus("OK");
        return response;
    }
}

