/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.InternationalContentHelper;
import org.geoserver.ows.ClientStreamAbortedException;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.InternationalStringUtils;
import org.geoserver.wfs.DomainType;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.OperationMetadata;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSExtendedCapabilitiesProvider;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.GetCapabilitiesRequest;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.Schema;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.parameter.Parameter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FunctionFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.v3_2.GML;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.geotools.xs.XS;
import org.vfny.geoserver.global.FeatureTypeInfoTitleComparator;
import org.vfny.geoserver.util.ResponseUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class CapabilitiesTransformer
extends TransformerBase {
    protected static final Logger LOGGER = Logging.getLogger((String)CapabilitiesTransformer.class.getPackage().getName());
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    static final Set<Sections> ALL_SECTIONS = Collections.unmodifiableSet(new HashSet<Sections>(Arrays.asList(Sections.ServiceIdentification, Sections.ServiceProvider, Sections.OperationsMetadata, Sections.FeatureTypeList, Sections.Filter_Capabilities)));
    protected static final String HTTP_GET = "Get";
    protected static final String HTTP_POST = "Post";
    protected static final String WFS_URI = "http://www.opengis.net/wfs";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final String OGC_PREFIX = "ogc";
    protected static final String OGC_URI = "http://www.opengis.net/ogc";
    protected WFSInfo wfs;
    protected WFSInfo.Version version;
    protected Catalog catalog;
    protected InternationalContentHelper internationalContentHelper;
    protected boolean i18nRequested = false;

    public CapabilitiesTransformer(WFSInfo wfs, WFSInfo.Version version, Catalog catalog) {
        this.setNamespaceDeclarationEnabled(false);
        this.wfs = wfs;
        this.version = version;
        this.catalog = catalog;
    }

    public void verifyUpdateSequence(GetCapabilitiesRequest request) throws ServiceException {
        long geoUS;
        long reqUS = -1L;
        if (request.getUpdateSequence() != null) {
            try {
                reqUS = Long.parseLong(request.getUpdateSequence());
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException("GeoServer only accepts numbers in the updateSequence parameter");
            }
        }
        if (reqUS > (geoUS = this.wfs.getGeoServer().getGlobal().getUpdateSequence())) {
            throw new ServiceException("Client supplied an updateSequence that is greater than the current sever updateSequence", "InvalidUpdateSequence");
        }
        if (reqUS == geoUS) {
            throw new ServiceException("WFS capabilities document is current (updateSequence = " + geoUS + ")", "CurrentUpdateSequence");
        }
    }

    protected Set<FunctionName> getAvailableFunctionNames() {
        TreeSet<FunctionName> sortedFunctions = new TreeSet<FunctionName>((fn1, fn2) -> {
            String n1 = fn1.getName();
            String n2 = fn2.getName();
            return n1.toLowerCase().compareTo(n2.toLowerCase());
        });
        Set factories = CommonFactoryFinder.getFunctionFactories(null);
        for (FunctionFactory factory : factories) {
            sortedFunctions.addAll(factory.getFunctionNames());
        }
        return sortedFunctions;
    }

    protected String[] getAvailableOutputFormatNames(String first, Version wfsVersion) {
        ArrayList<String> oflist = new ArrayList<String>();
        List featureProducers = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class);
        for (Object featureProducer : featureProducers) {
            WFSGetFeatureOutputFormat format = (WFSGetFeatureOutputFormat)((Object)featureProducer);
            if (!format.canHandle(wfsVersion)) continue;
            for (String s : format.getOutputFormats()) {
                if (!this.isAllowed(s.toString())) continue;
                oflist.add(s.toString());
            }
        }
        Collections.sort(oflist);
        if (oflist.contains(first)) {
            oflist.remove(first);
            oflist.add(0, first);
        }
        return oflist.toArray(new String[oflist.size()]);
    }

    protected void updateSequence(AttributesImpl attributes) {
        attributes.addAttribute("", "updateSequence", "updateSequence", "", "" + this.wfs.getGeoServer().getGlobal().getUpdateSequence());
    }

    protected void registerNamespaces(AttributesImpl attributes) {
        List namespaces = this.catalog.getNamespaces();
        for (NamespaceInfo namespace : namespaces) {
            String prefix = namespace.getPrefix();
            String uri = namespace.getURI();
            if ("xml".equals(prefix)) continue;
            String prefixDef = "xmlns:" + prefix;
            attributes.addAttribute("", prefixDef, prefixDef, "", uri);
        }
    }

    protected AttributesImpl attributes(String ... nameValues) {
        AttributesImpl atts = new AttributesImpl();
        for (int i = 0; i < nameValues.length; i += 2) {
            String name = nameValues[i];
            String valu = nameValues[i + 1];
            atts.addAttribute(null, null, name, null, valu);
        }
        return atts;
    }

    protected Map.Entry parameter(final String name, final Object value) {
        return new Map.Entry(){

            public Object getKey() {
                return name;
            }

            public Object getValue() {
                return value;
            }

            public Object setValue(Object value2) {
                return null;
            }
        };
    }

    protected Set<Sections> getSections(GetCapabilitiesRequest request) {
        List<String> sectionNames = request.getSections();
        if (sectionNames == null || sectionNames.isEmpty()) {
            return ALL_SECTIONS;
        }
        HashSet<Sections> sections = new HashSet<Sections>();
        for (String sectionName : sectionNames) {
            try {
                Sections section = Sections.valueOf(sectionName);
                sections.add(section);
            }
            catch (IllegalArgumentException e) {
                WFSException exception = new WFSException((RequestObject)request, "Unknown section " + sectionName, "InvalidParameterValue");
                exception.setLocator("sections");
                throw exception;
            }
        }
        if (sections.contains((Object)Sections.All)) {
            return ALL_SECTIONS;
        }
        return sections;
    }

    protected void handleAcceptLanguagesParameter(WFS1_1.CapabilitiesTranslator1_1 delegate, WFSInfo serviceInfo, List<FeatureTypeInfo> featureTypeInfos) {
        Request request = (Request)Dispatcher.REQUEST.get();
        String[] acceptLanguages = RequestUtils.getLanguageValue((Request)request, (String)"ACCEPTLANGUAGES");
        boolean bl = this.i18nRequested = acceptLanguages != null && acceptLanguages.length > 0;
        if (this.i18nRequested) {
            this.internationalContentHelper = new InternationalContentHelper(acceptLanguages, (ServiceInfo)serviceInfo, new ArrayList<FeatureTypeInfo>(featureTypeInfos));
        }
        delegate.i18nRequested = this.i18nRequested;
        delegate.internationalContentHelper = this.internationalContentHelper;
    }

    protected List<FeatureTypeInfo> getFeatureTypeInfoList(String namespace) {
        FeatureTypeInfo ft;
        ArrayList<FeatureTypeInfo> featureTypes = new ArrayList<FeatureTypeInfo>(this.catalog.getFeatureTypes());
        Iterator it = featureTypes.iterator();
        while (it.hasNext()) {
            ft = (FeatureTypeInfo)it.next();
            if (ft.enabled()) continue;
            it.remove();
        }
        if (namespace != null) {
            it = featureTypes.iterator();
            while (it.hasNext()) {
                ft = (FeatureTypeInfo)it.next();
                if (namespace.equals(ft.getNamespace().getPrefix())) continue;
                it.remove();
            }
        }
        return featureTypes;
    }

    public boolean isAllowed(String outputFormat) {
        if (!this.wfs.isGetFeatureOutputTypeCheckingEnabled()) {
            return true;
        }
        boolean contains = this.wfs.getGetFeatureOutputTypes().contains(outputFormat);
        if (!contains) {
            LOGGER.fine("OutputFormat " + outputFormat + " is not allowed for this request.due to Global WFS Configuration");
        }
        return contains;
    }

    public static class WFS2_0
    extends CapabilitiesTransformer {
        public static final Version VERSION_20 = new Version("2.0.0");
        static String WFS20_URI = "http://www.opengis.net/wfs/2.0";
        protected static final String GML32_FORMAT = "application/gml+xml; version=3.2";
        protected static final String FES_PREFIX = "fes";
        protected static final String FES_URI = "http://www.opengis.net/fes/2.0";
        protected final Collection<WFSExtendedCapabilitiesProvider> extCapsProviders;
        protected final String baseUrl;

        public WFS2_0(WFSInfo wfs, String baseUrl, Catalog catalog, Collection<WFSExtendedCapabilitiesProvider> extCapsProviders) {
            super(wfs, WFSInfo.Version.V_20, catalog);
            this.extCapsProviders = extCapsProviders;
            this.baseUrl = baseUrl;
        }

        public Translator createTranslator(ContentHandler handler) {
            return new CapabilitiesTranslator2_0(handler, this.baseUrl, this.wfs, this.extCapsProviders);
        }

        protected Name lookupTypeName(List<Schema> profiles, Parameter arg) {
            if ("geometry".equals(arg.getName())) {
                return new NameImpl(GML.AbstractGeometryType);
            }
            Class clazz = arg.getType();
            if (clazz == null || clazz == Object.class) {
                return new NameImpl(XS.STRING);
            }
            for (Schema profile : profiles) {
                for (Map.Entry e : profile.entrySet()) {
                    AttributeType at = (AttributeType)e.getValue();
                    if (at.getBinding() == null || !at.getBinding().equals(clazz)) continue;
                    return at.getName();
                }
                for (AttributeType at : profile.values()) {
                    if (!clazz.isAssignableFrom(at.getBinding())) continue;
                    return at.getName();
                }
            }
            return new NameImpl(XS.STRING);
        }

        protected class CapabilitiesTranslator2_0
        extends TransformerBase.TranslatorSupport {
            protected GetCapabilitiesRequest request;
            protected WFS1_1.CapabilitiesTranslator1_1 delegate;

            public CapabilitiesTranslator2_0(ContentHandler handler, String baseUrl, WFSInfo wfs, Collection<WFSExtendedCapabilitiesProvider> extCapsProviders) {
                super(handler, null, null);
                this.getNamespaceSupport().declarePrefix("xs", "http://www.w3.org/2001/XMLSchema");
                this.getNamespaceSupport().declarePrefix("gml", "http://www.opengis.net/gml/3.2");
                for (WFSExtendedCapabilitiesProvider cp : extCapsProviders) {
                    cp.registerNamespaces(this.getNamespaceSupport());
                }
                WFS1_1 wfs1_1 = new WFS1_1(wfs, WFS2_0.this.version, baseUrl, WFS2_0.this.catalog, extCapsProviders){

                    @Override
                    public Translator createTranslator(ContentHandler handler) {
                        return new CapabilitiesTranslator1_1_v2MetadataLinks(handler, this.baseUrl, this.wfs, (Collection<WFSExtendedCapabilitiesProvider>)this.extCapsProviders);
                    }

                    class CapabilitiesTranslator1_1_v2MetadataLinks
                    extends WFS1_1.CapabilitiesTranslator1_1 {
                        public CapabilitiesTranslator1_1_v2MetadataLinks(ContentHandler handler, String baseUrl, WFSInfo wfs, Collection<WFSExtendedCapabilitiesProvider> extCapsProviders) {
                            super(handler, baseUrl, wfs, extCapsProviders);
                        }

                        @Override
                        protected void metadataLink(MetadataLinkInfo link) {
                            if (link.getContent() == null || link.getContent().isEmpty()) {
                                return;
                            }
                            AttributesImpl mtAtts = this.attributes("xlink:href", ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)link, (String)this.request.getBaseUrl()));
                            this.start("MetadataURL", mtAtts);
                            this.end("MetadataURL");
                        }
                    }
                };
                this.delegate = (WFS1_1.CapabilitiesTranslator1_1)wfs1_1.createTranslator(handler);
            }

            public void encode(Object o) throws IllegalArgumentException {
                this.request = GetCapabilitiesRequest.adapt(o);
                WFS2_0.this.handleAcceptLanguagesParameter(this.delegate, WFS2_0.this.wfs, WFS2_0.this.getFeatureTypeInfoList(this.request.getNamespace()));
                this.delegate.request = this.request;
                StringBuilder schemaLocation = new StringBuilder();
                schemaLocation.append(WFS20_URI);
                schemaLocation.append(" ");
                if (WFS2_0.this.wfs.isCanonicalSchemaLocation()) {
                    schemaLocation.append("http://schemas.opengis.net/wfs/2.0/wfs.xsd");
                } else {
                    schemaLocation.append(org.geoserver.ows.util.ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wfs/2.0/wfs.xsd"));
                }
                this.delegate.addExtensionSchemaLocation(schemaLocation);
                AttributesImpl attributes = WFS2_0.this.attributes("version", "2.0.0", "xmlns:xsi", CapabilitiesTransformer.XSI_URI, "xmlns", WFS20_URI, "xmlns:wfs", WFS20_URI, "xmlns:ows", "http://www.opengis.net/ows/1.1", "xmlns:gml", "http://www.opengis.net/gml/3.2", "xmlns:fes", WFS2_0.FES_URI, "xmlns:xlink", "http://www.w3.org/1999/xlink", "xmlns:xs", "http://www.w3.org/2001/XMLSchema", "xsi:schemaLocation", schemaLocation.toString());
                Enumeration<String> prefixes = this.getNamespaceSupport().getPrefixes();
                while (prefixes.hasMoreElements()) {
                    String prefix = prefixes.nextElement();
                    attributes.addAttribute(null, null, "xmlns:" + prefix, null, this.getNamespaceSupport().getURI(prefix));
                }
                WFS2_0.this.registerNamespaces(attributes);
                WFS2_0.this.updateSequence(attributes);
                this.start("wfs:WFS_Capabilities", attributes);
                Set<Sections> sections = WFS2_0.this.getSections(this.request);
                if (sections.isEmpty() || sections.contains((Object)Sections.ServiceIdentification)) {
                    this.delegate.serviceIdentification("2.0.0");
                }
                if (sections.isEmpty() || sections.contains((Object)Sections.ServiceProvider)) {
                    this.delegate.encodeServiceProvider(WFS2_0.this.wfs.getGeoServer());
                }
                if (sections.isEmpty() || sections.contains((Object)Sections.OperationsMetadata)) {
                    this.operationsMetadata();
                }
                if (sections.isEmpty() || sections.contains((Object)Sections.FeatureTypeList)) {
                    this.featureTypeList();
                }
                if (sections.isEmpty() || sections.contains((Object)Sections.Filter_Capabilities)) {
                    this.filterCapabilities();
                }
                this.end("wfs:WFS_Capabilities");
            }

            protected void operationsMetadata() {
                this.start("ows:OperationsMetadata");
                ArrayList<OperationMetadata> operations = new ArrayList<OperationMetadata>();
                operations.add(this.getCapabilities());
                operations.add(this.describeFeatureType());
                operations.add(this.getFeature());
                operations.add(this.getPropertyValue());
                operations.add(this.listStoredQueries());
                operations.add(this.describeStoredQueries());
                if (!WFS2_0.this.wfs.isDisableStoredQueriesManagement()) {
                    operations.add(this.createStoredQuery());
                    operations.add(this.dropStoredQuery());
                }
                if (WFS2_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.COMPLETE)) {
                    operations.add(this.lockFeature());
                    operations.add(this.getFeatureWithLock());
                }
                if (WFS2_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
                    operations.add(this.transaction());
                }
                for (WFSExtendedCapabilitiesProvider provider : WFS2_0.this.extCapsProviders) {
                    provider.updateOperationMetadata(VERSION_20, operations);
                }
                operations.forEach(o -> this.operation((OperationMetadata)o));
                this.constraints();
                this.delegate.extendedCapabilities();
                this.end("ows:OperationsMetadata");
            }

            protected OperationMetadata getCapabilities() {
                OperationMetadata operation = new OperationMetadata("GetCapabilities", true, true);
                operation.getParameters().add(new DomainType("AcceptVersions", new String[]{"1.0.0", "1.1.0", "2.0.0"}));
                operation.getParameters().add(new DomainType("AcceptFormats", new String[]{"text/xml"}));
                operation.getParameters().add(new DomainType("Sections", new String[]{"ServiceIdentification", "ServiceProvider", "OperationsMetadata", "FeatureTypeList", "Filter_Capabilities"}));
                return operation;
            }

            protected OperationMetadata describeFeatureType() {
                OperationMetadata operation = new OperationMetadata("DescribeFeatureType", true, true);
                operation.getParameters().add(new DomainType("outputFormat", new String[]{WFS2_0.GML32_FORMAT}));
                return operation;
            }

            protected OperationMetadata getFeature() {
                String[] formats = WFS2_0.this.getAvailableOutputFormatNames(WFS2_0.GML32_FORMAT, VERSION_20);
                OperationMetadata operation = new OperationMetadata("GetFeature", true, true);
                operation.getParameters().add(new DomainType("resultType", new String[]{"results", "hits"}));
                operation.getParameters().add(new DomainType("outputFormat", formats));
                operation.getConstraints().add(new DomainType("PagingIsTransactionSafe", CapabilitiesTransformer.FALSE));
                operation.getConstraints().add(new DomainType("CountDefault", String.valueOf(WFS2_0.this.wfs.getMaxFeatures())));
                operation.getParameters().add(new DomainType("resolve", new String[]{"none", "local"}));
                return operation;
            }

            protected OperationMetadata getFeatureWithLock() {
                String[] formats = WFS2_0.this.getAvailableOutputFormatNames(WFS2_0.GML32_FORMAT, VERSION_20);
                OperationMetadata operation = new OperationMetadata("GetFeatureWithLock", true, true);
                operation.getParameters().add(new DomainType("resultType", new String[]{"results", "hits"}));
                operation.getParameters().add(new DomainType("outputFormat", formats));
                operation.getParameters().add(new DomainType("resolve", new String[]{"none", "local"}));
                return operation;
            }

            protected OperationMetadata getPropertyValue() {
                OperationMetadata operation = new OperationMetadata("GetPropertyValue", true, true);
                operation.getParameters().add(new DomainType("resolve", new String[]{"none", "local"}));
                operation.getParameters().add(new DomainType("outputFormat", new String[]{WFS2_0.GML32_FORMAT}));
                return operation;
            }

            protected OperationMetadata lockFeature() {
                OperationMetadata operation = new OperationMetadata("LockFeature", true, true);
                operation.getParameters().add(new DomainType("releaseAction", new String[]{"ALL", "SOME"}));
                return operation;
            }

            protected OperationMetadata transaction() {
                OperationMetadata operation = new OperationMetadata("Transaction", true, true);
                operation.getParameters().add(new DomainType("inputFormat", new String[]{WFS2_0.GML32_FORMAT}));
                operation.getParameters().add(new DomainType("releaseAction", new String[]{"ALL", "SOME"}));
                return operation;
            }

            protected OperationMetadata listStoredQueries() {
                return new OperationMetadata("ListStoredQueries", true, true);
            }

            protected OperationMetadata describeStoredQueries() {
                return new OperationMetadata("DescribeStoredQueries", true, true);
            }

            protected OperationMetadata createStoredQuery() {
                OperationMetadata operation = new OperationMetadata("CreateStoredQuery", false, true);
                operation.getParameters().add(new DomainType("language", new String[]{"urn:ogc:def:queryLanguage:OGC-WFS::WFSQueryExpression"}));
                return operation;
            }

            protected OperationMetadata dropStoredQuery() {
                return new OperationMetadata("DropStoredQuery", true, true);
            }

            protected void constraints() {
                ArrayList<DomainType> constraints = new ArrayList<DomainType>();
                constraints.add(new DomainType("ImplementsBasicWFS", CapabilitiesTransformer.TRUE));
                WFSInfo.ServiceLevel serviceLevel = WFS2_0.this.wfs.getServiceLevel();
                constraints.add(new DomainType("ImplementsTransactionalWFS", serviceLevel.contains(WFSInfo.ServiceLevel.TRANSACTIONAL) ? CapabilitiesTransformer.TRUE : CapabilitiesTransformer.FALSE));
                constraints.add(new DomainType("ImplementsLockingWFS", serviceLevel.contains(WFSInfo.ServiceLevel.COMPLETE) ? CapabilitiesTransformer.TRUE : CapabilitiesTransformer.FALSE));
                constraints.add(new DomainType("KVPEncoding", CapabilitiesTransformer.TRUE));
                constraints.add(new DomainType("XMLEncoding", CapabilitiesTransformer.TRUE));
                constraints.add(new DomainType("SOAPEncoding", CapabilitiesTransformer.TRUE));
                constraints.add(new DomainType("ImplementsInheritance", CapabilitiesTransformer.FALSE));
                constraints.add(new DomainType("ImplementsRemoteResolve", CapabilitiesTransformer.FALSE));
                constraints.add(new DomainType("ImplementsResultPaging", CapabilitiesTransformer.TRUE));
                constraints.add(new DomainType("ImplementsStandardJoins", CapabilitiesTransformer.TRUE));
                constraints.add(new DomainType("ImplementsSpatialJoins", CapabilitiesTransformer.TRUE));
                constraints.add(new DomainType("ImplementsTemporalJoins", CapabilitiesTransformer.TRUE));
                constraints.add(new DomainType("ImplementsFeatureVersioning", CapabilitiesTransformer.FALSE));
                constraints.add(new DomainType("ManageStoredQueries", WFS2_0.this.wfs.isDisableStoredQueriesManagement() ? CapabilitiesTransformer.FALSE : CapabilitiesTransformer.TRUE));
                constraints.add(new DomainType("PagingIsTransactionSafe", CapabilitiesTransformer.FALSE));
                constraints.add(new DomainType("QueryExpressions", new String[]{"wfs:Query", "wfs:StoredQuery"}));
                Version serviceVersion = VERSION_20;
                for (WFSExtendedCapabilitiesProvider provider : WFS2_0.this.extCapsProviders) {
                    provider.updateRootOperationConstraints(serviceVersion, constraints);
                }
                for (DomainType constraint : constraints) {
                    this.constraint(constraint);
                }
            }

            protected void constraint(DomainType constraint) {
                this.domainType("ows:Constraint", constraint);
            }

            protected void featureTypeList() {
                if (WFS2_0.this.catalog.getFeatureTypes().isEmpty()) {
                    return;
                }
                this.start("FeatureTypeList");
                this.delegate.featureTypes(true, this.request.getNamespace());
                this.end("FeatureTypeList");
            }

            protected void filterCapabilities() {
                this.start("fes:Filter_Capabilities");
                this.start("fes:Conformance");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsQuery"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsAdHocQuery"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsFunctions"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsResourceId"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsMinStandardFilter"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsStandardFilter"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsMinSpatialFilter"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsSpatialFilter"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsMinTemporalFilter"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsTemporalFilter"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsVersionNav"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.FALSE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsSorting"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsExtendedOperators"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.FALSE);
                this.end("fes:Constraint");
                this.start("fes:Constraint", WFS2_0.this.attributes("name", "ImplementsMinimumXPath"));
                this.element("ows:NoValues", null);
                this.element("ows:DefaultValue", CapabilitiesTransformer.TRUE);
                this.end("fes:Constraint");
                this.end("fes:Conformance");
                this.start("fes:Id_Capabilities");
                this.element("fes:ResourceIdentifier", null, WFS2_0.this.attributes("name", "fes:ResourceId"));
                this.end("fes:Id_Capabilities");
                this.start("fes:Scalar_Capabilities");
                this.element("fes:LogicalOperators", null);
                this.start("fes:ComparisonOperators");
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes("name", "PropertyIsLessThan"));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes("name", "PropertyIsGreaterThan"));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes("name", "PropertyIsLessThanOrEqualTo"));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes("name", "PropertyIsGreaterThanOrEqualTo"));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes("name", "PropertyIsEqualTo"));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes("name", "PropertyIsNotEqualTo"));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes("name", "PropertyIsLike"));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes("name", "PropertyIsBetween"));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes("name", "PropertyIsNull"));
                this.element("fes:ComparisonOperator", null, WFS2_0.this.attributes("name", "PropertyIsNil"));
                this.end("fes:ComparisonOperators");
                this.end("fes:Scalar_Capabilities");
                this.start("fes:Spatial_Capabilities");
                this.start("fes:GeometryOperands");
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes("name", "gml:Envelope"));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes("name", "gml:Point"));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes("name", "gml:MultiPoint"));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes("name", "gml:LineString"));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes("name", "gml:MultiLineString"));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes("name", "gml:Polygon"));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes("name", "gml:MultiPolygon"));
                this.element("fes:GeometryOperand", null, WFS2_0.this.attributes("name", "gml:MultiGeometry"));
                this.end("fes:GeometryOperands");
                this.start("fes:SpatialOperators");
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "Disjoint"));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "Equals"));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "DWithin"));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "Beyond"));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "Intersects"));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "Touches"));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "Crosses"));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "Within"));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "Contains"));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "Overlaps"));
                this.element("fes:SpatialOperator", null, WFS2_0.this.attributes("name", "BBOX"));
                this.end("fes:SpatialOperators");
                this.end("fes:Spatial_Capabilities");
                this.start("fes:Temporal_Capabilities");
                this.start("fes:TemporalOperands");
                this.element("fes:TemporalOperand", null, WFS2_0.this.attributes("name", "gml:TimeInstant"));
                this.element("fes:TemporalOperand", null, WFS2_0.this.attributes("name", "gml:TimePeriod"));
                this.end("fes:TemporalOperands");
                this.start("fes:TemporalOperators");
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "After"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "Before"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "Begins"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "BegunBy"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "TContains"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "During"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "TEquals"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "TOverlaps"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "Meets"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "OverlappedBy"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "MetBy"));
                this.element("fes:TemporalOperator", null, WFS2_0.this.attributes("name", "EndedBy"));
                this.end("fes:TemporalOperators");
                this.end("fes:Temporal_Capabilities");
                List typeMappingProfiles = GML.getInstance().getAllTypeMappingProfiles();
                this.start("fes:Functions");
                for (FunctionName fn : WFS2_0.this.getAvailableFunctionNames()) {
                    this.start("fes:Function", WFS2_0.this.attributes("name", fn.getName()));
                    Name returnType = WFS2_0.this.lookupTypeName(typeMappingProfiles, fn.getReturn());
                    String prefix = this.getNamespaceSupport().getPrefix(returnType.getNamespaceURI());
                    if (prefix != null) {
                        this.element("fes:Returns", prefix + ":" + returnType.getLocalPart());
                    } else {
                        LOGGER.warning(String.format("Unable to map function return type to QName for function %s. No namespace mapping for %s.", fn.getName(), returnType.getNamespaceURI()));
                    }
                    if (!fn.getArgumentNames().isEmpty()) {
                        this.start("fes:Arguments");
                        for (Parameter arg : fn.getArguments()) {
                            this.start("fes:Argument", WFS2_0.this.attributes("name", arg.getName()));
                            Name argType = WFS2_0.this.lookupTypeName(typeMappingProfiles, arg);
                            prefix = this.getNamespaceSupport().getPrefix(argType.getNamespaceURI());
                            if (prefix != null) {
                                this.element("fes:Type", prefix + ":" + argType.getLocalPart());
                            } else {
                                LOGGER.warning(String.format("Unable to map function argument type to QName for function %s. No namespace mapping for %s.", arg.getName(), argType.getNamespaceURI()));
                            }
                            this.end("fes:Argument");
                        }
                        this.end("fes:Arguments");
                    }
                    this.end("fes:Function");
                }
                this.end("fes:Functions");
                this.end("fes:Filter_Capabilities");
            }

            protected void operation(OperationMetadata operation) {
                this.start("ows:Operation", WFS2_0.this.attributes("name", operation.getName()));
                String serviceURL = org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                this.delegate.dcp(serviceURL, operation.isGet(), operation.isPost());
                for (DomainType parameter : operation.getParameters()) {
                    this.domainType("ows:Parameter", parameter);
                }
                for (DomainType constraint : operation.getConstraints()) {
                    this.domainType("ows:Constraint", constraint);
                }
                this.end("ows:Operation");
            }

            protected void domainType(String elementName, DomainType domainType) {
                this.start(elementName, WFS2_0.this.attributes("name", domainType.getName()));
                if (domainType.isNoValues()) {
                    this.element("ows:NoValues", null);
                }
                if (domainType.getDefaultValue() != null) {
                    this.element("ows:DefaultValue", domainType.getDefaultValue());
                }
                if (!domainType.getAllowedValues().isEmpty()) {
                    this.start("ows:AllowedValues");
                    for (String v : domainType.getAllowedValues()) {
                        this.element("ows:Value", v);
                    }
                    this.end("ows:AllowedValues");
                }
                this.end(elementName);
            }
        }
    }

    public static class WFS1_1
    extends CapabilitiesTransformer {
        public static final Version VERSION_11 = new Version("1.1.0");
        static final Set<String> VALID_LINKS_METADATATYPES = new HashSet<String>(Arrays.asList("TC211", "FGDC", "19115", "13139"));
        static final Set<String> VALID_LINKS_FORMATS = new HashSet<String>(Arrays.asList("text/xml", "text/html", "text/sgml", "text/plain"));
        protected final boolean skipMisconfigured;
        protected final Collection<WFSExtendedCapabilitiesProvider> extCapsProviders;
        protected final String baseUrl;

        public WFS1_1(WFSInfo wfs, String baseUrl, Catalog catalog, Collection<WFSExtendedCapabilitiesProvider> extCapsProviders) {
            this(wfs, WFSInfo.Version.V_11, baseUrl, catalog, extCapsProviders);
        }

        public WFS1_1(WFSInfo wfs, WFSInfo.Version version, String baseUrl, Catalog catalog, Collection<WFSExtendedCapabilitiesProvider> extCapsProviders) {
            super(wfs, version, catalog);
            this.skipMisconfigured = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)wfs.getGeoServer().getGlobal().getResourceErrorHandling());
            this.extCapsProviders = extCapsProviders;
            this.baseUrl = baseUrl;
        }

        public Translator createTranslator(ContentHandler handler) {
            return new CapabilitiesTranslator1_1(handler, this.baseUrl, this.wfs, this.extCapsProviders);
        }

        protected class CapabilitiesTranslator1_1
        extends TransformerBase.TranslatorSupport {
            protected static final String GML_3_1_1_FORMAT = "text/xml; subtype=gml/3.1.1";
            GetCapabilitiesRequest request;
            protected Collection<WFSExtendedCapabilitiesProvider> extCapsProviders;
            protected final WFSInfo wfs;
            protected final String schemaBaseURL;
            boolean i18nRequested;
            InternationalContentHelper internationalContentHelper;

            public CapabilitiesTranslator1_1(ContentHandler handler, String baseUrl, WFSInfo wfs, Collection<WFSExtendedCapabilitiesProvider> extCapsProviders) {
                super(handler, null, null);
                this.i18nRequested = false;
                this.wfs = wfs;
                this.extCapsProviders = extCapsProviders;
                this.schemaBaseURL = baseUrl;
                for (WFSExtendedCapabilitiesProvider cp : extCapsProviders) {
                    cp.registerNamespaces(this.getNamespaceSupport());
                }
            }

            public void encode(Object object) throws IllegalArgumentException {
                this.request = GetCapabilitiesRequest.adapt(object);
                WFS1_1.this.verifyUpdateSequence(this.request);
                StringBuilder schemaLocation = new StringBuilder();
                schemaLocation.append(CapabilitiesTransformer.WFS_URI);
                schemaLocation.append(" ");
                if (this.wfs.isCanonicalSchemaLocation()) {
                    schemaLocation.append("http://schemas.opengis.net/wfs/1.1.0/wfs.xsd");
                } else {
                    schemaLocation.append(org.geoserver.ows.util.ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wfs/1.1.0/wfs.xsd"));
                }
                this.addExtensionSchemaLocation(schemaLocation);
                AttributesImpl attributes = WFS1_1.this.attributes("version", "1.1.0", "xmlns:xsi", CapabilitiesTransformer.XSI_URI, "xmlns", CapabilitiesTransformer.WFS_URI, "xmlns:wfs", CapabilitiesTransformer.WFS_URI, "xmlns:ows", "http://www.opengis.net/ows", "xmlns:gml", "http://www.opengis.net/gml", "xmlns:ogc", CapabilitiesTransformer.OGC_URI, "xmlns:xlink", "http://www.w3.org/1999/xlink", "xsi:schemaLocation", schemaLocation.toString());
                Enumeration<String> prefixes = this.getNamespaceSupport().getPrefixes();
                while (prefixes.hasMoreElements()) {
                    String prefix = prefixes.nextElement();
                    if ("xml".equals(prefix)) continue;
                    attributes.addAttribute(null, null, "xmlns:" + prefix, null, this.getNamespaceSupport().getURI(prefix));
                }
                WFS1_1.this.registerNamespaces(attributes);
                WFS1_1.this.updateSequence(attributes);
                this.start("wfs:WFS_Capabilities", attributes);
                Set<Sections> sections = WFS1_1.this.getSections(this.request);
                if (sections.contains((Object)Sections.ServiceIdentification)) {
                    this.serviceIdentification();
                }
                if (sections.contains((Object)Sections.ServiceProvider)) {
                    this.encodeServiceProvider(this.wfs.getGeoServer());
                }
                if (sections.contains((Object)Sections.OperationsMetadata)) {
                    this.operationsMetadata();
                }
                if (sections.contains((Object)Sections.FeatureTypeList)) {
                    this.featureTypeList();
                }
                if (sections.contains((Object)Sections.Filter_Capabilities)) {
                    this.filterCapabilities();
                }
                this.end("wfs:WFS_Capabilities");
            }

            protected String addExtensionSchemaLocation(StringBuilder schemaLocation) {
                for (WFSExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                    String[] locations = cp.getSchemaLocations(this.schemaBaseURL);
                    try {
                        for (int i = 0; i < locations.length - 1; i += 2) {
                            schemaLocation.append(" ");
                            schemaLocation.append(this.schemaLocation(locations[i], locations[i + 1]));
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new ServiceException("Extended capabilities provider returned improper set of namespace,location pairs from getSchemaLocations()", (Throwable)e);
                    }
                }
                return schemaLocation.toString();
            }

            protected String schemaLocation(String namespace, String uri) {
                String location = null;
                try {
                    new URL(uri);
                    location = uri;
                }
                catch (MalformedURLException e) {
                    location = org.geoserver.ows.util.ResponseUtils.buildSchemaURL((String)this.schemaBaseURL, (String)uri);
                }
                return namespace + " " + location;
            }

            protected void serviceIdentification() {
                this.serviceIdentification("1.1.0");
            }

            protected void serviceIdentification(String version) {
                this.start("ows:ServiceIdentification");
                this.handleServiceTitleAndAbstract();
                this.keywords(this.wfs.getKeywords());
                this.element("ows:ServiceType", "WFS");
                this.element("ows:ServiceTypeVersion", version);
                Version gtVersion = new Version(version);
                if (gtVersion.compareTo(new Version("2")) >= 0) {
                    LinkedHashSet<String> profiles = new LinkedHashSet<String>();
                    for (WFSExtendedCapabilitiesProvider provider : this.extCapsProviders) {
                        List<String> providerProfiles = provider.getProfiles(gtVersion);
                        profiles.addAll(providerProfiles);
                    }
                    for (String profile : profiles) {
                        this.element("ows:Profile", profile);
                    }
                }
                this.element("ows:Fees", this.wfs.getFees());
                this.element("ows:AccessConstraints", this.wfs.getAccessConstraints());
                this.end("ows:ServiceIdentification");
            }

            private void handleServiceTitleAndAbstract() {
                if (!this.i18nRequested) {
                    this.element("ows:Title", this.wfs.getTitle());
                    this.element("ows:Abstract", this.wfs.getAbstract());
                } else {
                    this.element("ows:Title", this.internationalContentHelper.getTitle((ServiceInfo)this.wfs));
                    this.element("ows:Abstract", this.internationalContentHelper.getAbstract((ServiceInfo)this.wfs));
                }
            }

            protected void encodeServiceProvider(GeoServer gs) {
                ContactInfo contact = gs.getSettings().getContact();
                this.start("ows:ServiceProvider");
                if (!this.i18nRequested) {
                    this.serviceProvider(contact);
                } else {
                    this.internationalServiceProvider(contact);
                }
                this.end("ows:ServiceProvider");
            }

            protected void serviceProvider(ContactInfo contact) {
                this.element("ows:ProviderName", contact.getContactOrganization());
                this.start("ows:ServiceContact");
                this.element("ows:IndividualName", contact.getContactPerson());
                this.element("ows:PositionName", contact.getContactPosition());
                this.start("ows:ContactInfo");
                this.start("ows:Phone");
                this.element("ows:Voice", contact.getContactVoice());
                this.element("ows:Facsimile", contact.getContactFacsimile());
                this.end("ows:Phone");
                this.start("ows:Address");
                this.element("ows:DeliveryPoint", contact.getAddressDeliveryPoint());
                this.element("ows:City", contact.getAddressCity());
                this.element("ows:AdministrativeArea", contact.getAddressState());
                this.element("ows:PostalCode", contact.getAddressPostalCode());
                this.element("ows:Country", contact.getAddressCountry());
                this.element("ows:ElectronicMailAddress", contact.getContactEmail());
                this.end("ows:Address");
                this.end("ows:ContactInfo");
                this.end("ows:ServiceContact");
            }

            protected void internationalServiceProvider(ContactInfo contact) {
                this.element("ows:ProviderName", this.internationalContentHelper.getNullableString(contact.getInternationalContactOrganization()));
                this.start("ows:ServiceContact");
                this.element("ows:IndividualName", this.internationalContentHelper.getNullableString(contact.getInternationalContactPerson()));
                this.element("ows:PositionName", this.internationalContentHelper.getNullableString(contact.getInternationalContactPosition()));
                this.start("ows:ContactInfo");
                this.start("ows:Phone");
                this.element("ows:Voice", this.internationalContentHelper.getNullableString(contact.getInternationalContactVoice()));
                this.element("ows:Facsimile", this.internationalContentHelper.getNullableString(contact.getInternationalContactFacsimile()));
                this.end("ows:Phone");
                this.start("ows:Address");
                this.element("ows:DeliveryPoint", this.internationalContentHelper.getNullableString(contact.getInternationalAddressDeliveryPoint()));
                this.element("ows:City", this.internationalContentHelper.getNullableString(contact.getInternationalAddressCity()));
                this.element("ows:AdministrativeArea", this.internationalContentHelper.getNullableString(contact.getInternationalAddressState()));
                this.element("ows:PostalCode", this.internationalContentHelper.getNullableString(contact.getInternationalAddressPostalCode()));
                this.element("ows:Country", this.internationalContentHelper.getNullableString(contact.getInternationalAddressCountry()));
                this.element("ows:ElectronicMailAddress", this.internationalContentHelper.getNullableString(contact.getInternationalContactEmail()));
                this.end("ows:Address");
                this.end("ows:ContactInfo");
                this.end("ows:ServiceContact");
            }

            protected void operationsMetadata() {
                this.start("ows:OperationsMetadata");
                ArrayList<OperationMetadata> operations = new ArrayList<OperationMetadata>();
                operations.add(this.getCapabilities());
                operations.add(this.describeFeatureType());
                operations.add(this.getFeature());
                operations.add(this.getGmlObject());
                if (this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.COMPLETE)) {
                    operations.add(this.lockFeature());
                    operations.add(this.getFeatureWithLock());
                }
                if (this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
                    operations.add(this.transaction());
                }
                for (WFSExtendedCapabilitiesProvider provider : this.extCapsProviders) {
                    provider.updateOperationMetadata(VERSION_11, operations);
                }
                operations.forEach(o -> this.operation((OperationMetadata)o));
                this.extendedCapabilities();
                this.end("ows:OperationsMetadata");
            }

            protected OperationMetadata getCapabilities() {
                OperationMetadata operation = new OperationMetadata("GetCapabilities", true, true);
                operation.getParameters().add(new DomainType("AcceptVersions", new String[]{"1.0.0", "1.1.0"}));
                operation.getParameters().add(new DomainType("AcceptFormats", new String[]{"text/xml"}));
                operation.getParameters().add(new DomainType("Sections", new String[]{"ServiceIdentification", "ServiceProvider", "OperationsMetadata", "FeatureTypeList", "Filter_Capabilities"}));
                return operation;
            }

            protected OperationMetadata describeFeatureType() {
                OperationMetadata operation = new OperationMetadata("DescribeFeatureType", true, true);
                operation.getParameters().add(new DomainType("outputFormat", new String[]{GML_3_1_1_FORMAT}));
                return operation;
            }

            protected OperationMetadata getFeature() {
                String[] formats = this.getoutputFormatNames();
                OperationMetadata operation = new OperationMetadata("GetFeature", true, true);
                operation.getParameters().add(new DomainType("resultType", new String[]{"results", "hits"}));
                operation.getParameters().add(new DomainType("outputFormat", formats));
                operation.getConstraints().add(new DomainType("LocalTraverseXLinkScope", new String[]{"2"}));
                return operation;
            }

            protected String[] getoutputFormatNames() {
                return WFS1_1.this.getAvailableOutputFormatNames(GML_3_1_1_FORMAT, VERSION_11);
            }

            protected OperationMetadata getFeatureWithLock() {
                String[] formats = this.getoutputFormatNames();
                OperationMetadata operation = new OperationMetadata("GetFeatureWithLock", true, true);
                operation.getParameters().add(new DomainType("resultType", new String[]{"results", "hits"}));
                operation.getParameters().add(new DomainType("outputFormat", formats));
                return operation;
            }

            protected OperationMetadata lockFeature() {
                OperationMetadata operation = new OperationMetadata("LockFeature", true, true);
                operation.getParameters().add(new DomainType("releaseAction", new String[]{"ALL", "SOME"}));
                return operation;
            }

            protected OperationMetadata transaction() {
                OperationMetadata operation = new OperationMetadata("Transaction", true, true);
                operation.getParameters().add(new DomainType("inputFormat", new String[]{GML_3_1_1_FORMAT}));
                operation.getParameters().add(new DomainType("idgen", new String[]{"GenerateNew", "UseExisting", "ReplaceDuplicate"}));
                operation.getParameters().add(new DomainType("releaseAction", new String[]{"ALL", "SOME"}));
                return operation;
            }

            protected OperationMetadata getGmlObject() {
                return new OperationMetadata("GetGmlObject", true, true);
            }

            protected void extendedCapabilities() {
                for (WFSExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                    try {
                        cp.encode(new ExtendedCapabilitiesProvider.Translator(){

                            public void start(String element) {
                                CapabilitiesTranslator1_1.this.start(element);
                            }

                            public void start(String element, Attributes attributes) {
                                CapabilitiesTranslator1_1.this.start(element, attributes);
                            }

                            public void chars(String text) {
                                CapabilitiesTranslator1_1.this.chars(text);
                            }

                            public void end(String element) {
                                CapabilitiesTranslator1_1.this.end(element);
                            }
                        }, this.wfs, this.request);
                    }
                    catch (Exception e) {
                        throw new ServiceException("Extended capabilities provider threw error", (Throwable)e);
                    }
                }
            }

            protected void featureTypeList() {
                this.start("FeatureTypeList");
                this.start("Operations");
                if (this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.BASIC)) {
                    this.element("Operation", "Query");
                }
                if (this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_INSERT)) {
                    this.element("Operation", "Insert");
                }
                if (this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_UPDATE)) {
                    this.element("Operation", "Update");
                }
                if (this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_DELETE)) {
                    this.element("Operation", "Delete");
                }
                if (this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.LOCKFEATURE)) {
                    this.element("Operation", "Lock");
                }
                this.end("Operations");
                this.featureTypes();
                this.end("FeatureTypeList");
            }

            protected void featureTypes() {
                this.featureTypes(false, this.request.getNamespace());
            }

            protected void featureTypes(boolean crs, String namespace) {
                List<FeatureTypeInfo> featureTypes = WFS1_1.this.getFeatureTypeInfoList(namespace);
                Collections.sort(featureTypes, new FeatureTypeInfoTitleComparator());
                for (FeatureTypeInfo featureType : featureTypes) {
                    if (!featureType.enabled()) continue;
                    try {
                        this.mark();
                        this.featureType(featureType, crs);
                        this.commit();
                    }
                    catch (RuntimeException ex) {
                        ClientStreamAbortedException.rethrowUncheked((Exception)ex);
                        if (WFS1_1.this.skipMisconfigured) {
                            this.reset();
                            LOGGER.log(Level.WARNING, "Couldn't encode WFS capabilities entry for featuretype: " + featureType.prefixedName(), ex);
                            continue;
                        }
                        throw ex;
                    }
                }
            }

            protected void featureType(FeatureTypeInfo featureType, boolean crs) {
                GMLInfo gml = this.wfs.getGML().get((Object)WFS1_1.this.version);
                String prefix = featureType.getNamespace().getPrefix();
                String uri = featureType.getNamespace().getURI();
                this.start("FeatureType", WFS1_1.this.attributes("xmlns:" + prefix, uri));
                this.element("Name", featureType.prefixedName());
                this.handleTitleAndAbstract(featureType);
                this.keywords(featureType.getKeywords());
                String srs = featureType.getSRS();
                srs = this.applySRSNameStyle(gml, srs);
                if (crs) {
                    this.element("DefaultCRS", srs);
                } else {
                    this.element("DefaultSRS", srs);
                }
                List<String> otherSRSes = this.getOtherSRS(featureType);
                for (String otherSRS : otherSRSes) {
                    if (otherSRS == null || (otherSRS = this.applySRSNameStyle(gml, otherSRS)).equals(srs)) continue;
                    if (crs) {
                        this.element("OtherCRS", otherSRS);
                        continue;
                    }
                    this.element("OtherSRS", otherSRS);
                }
                ReferencedEnvelope bbox = featureType.getLatLonBoundingBox();
                this.start("ows:WGS84BoundingBox");
                this.element("ows:LowerCorner", bbox.getMinX() + " " + bbox.getMinY());
                this.element("ows:UpperCorner", bbox.getMaxX() + " " + bbox.getMaxY());
                this.end("ows:WGS84BoundingBox");
                List mlinks = featureType.getMetadataLinks();
                if (mlinks != null && !mlinks.isEmpty()) {
                    for (MetadataLinkInfo link : mlinks) {
                        this.metadataLink(link);
                    }
                }
                this.end("FeatureType");
            }

            private void handleTitleAndAbstract(FeatureTypeInfo featureTypeInfo) {
                if (!this.i18nRequested) {
                    this.element("Title", featureTypeInfo.getTitle());
                    this.element("Abstract", featureTypeInfo.getAbstract());
                } else {
                    String title = this.internationalContentHelper.getTitle((ResourceInfo)featureTypeInfo);
                    String abstrct = this.internationalContentHelper.getAbstract((ResourceInfo)featureTypeInfo);
                    this.element("Title", title);
                    this.element("Abstract", abstrct);
                }
            }

            private String applySRSNameStyle(GMLInfo gml, String srs) {
                if (srs != null) {
                    return gml.getSrsNameStyle().toSrsSyntax().getSRS(srs);
                }
                return null;
            }

            protected List<String> getOtherSRS(FeatureTypeInfo featureType) {
                List<String> extraSRS = featureType.isOverridingServiceSRS() ? featureType.getResponseSRS() : this.wfs.getSRS();
                return extraSRS;
            }

            protected void metadataLink(MetadataLinkInfo link) {
                String format = link.getType();
                String metadataType = link.getMetadataType();
                if ("ISO19115:2003".equals(metadataType)) {
                    metadataType = "19115";
                }
                if (!VALID_LINKS_FORMATS.contains(format)) {
                    LOGGER.log(Level.FINE, "Skipping metadata link " + link.getContent() + ", format " + format + " is not valid in WFS 1.1, supported types are: " + VALID_LINKS_FORMATS);
                    return;
                }
                if (!VALID_LINKS_METADATATYPES.contains(metadataType)) {
                    LOGGER.log(Level.FINE, "Skipping metadata link " + link.getContent() + ", metadata type " + metadataType + " is not valid in WFS 1.1, supported types are: " + VALID_LINKS_METADATATYPES);
                    return;
                }
                if (link.getContent() == null || link.getContent().isEmpty()) {
                    return;
                }
                AttributesImpl mtAtts = WFS1_1.this.attributes("type", metadataType, "format", format);
                this.element("MetadataURL", ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)link, (String)this.request.getBaseUrl()), mtAtts);
            }

            protected void supportsGMLObjectTypeList() {
                this.element("SupportsGMLObjectTypeList", null);
            }

            protected void filterCapabilities() {
                this.start("ogc:Filter_Capabilities");
                this.start("ogc:Spatial_Capabilities");
                this.start("ogc:GeometryOperands");
                this.element("ogc:GeometryOperand", "gml:Envelope");
                this.element("ogc:GeometryOperand", "gml:Point");
                this.element("ogc:GeometryOperand", "gml:LineString");
                this.element("ogc:GeometryOperand", "gml:Polygon");
                this.end("ogc:GeometryOperands");
                this.start("ogc:SpatialOperators");
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "Disjoint"));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "Equals"));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "DWithin"));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "Beyond"));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "Intersects"));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "Touches"));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "Crosses"));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "Within"));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "Contains"));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "Overlaps"));
                this.element("ogc:SpatialOperator", null, WFS1_1.this.attributes("name", "BBOX"));
                this.end("ogc:SpatialOperators");
                this.end("ogc:Spatial_Capabilities");
                this.start("ogc:Scalar_Capabilities");
                this.element("ogc:LogicalOperators", null);
                this.start("ogc:ComparisonOperators");
                this.element("ogc:ComparisonOperator", "LessThan");
                this.element("ogc:ComparisonOperator", "GreaterThan");
                this.element("ogc:ComparisonOperator", "LessThanEqualTo");
                this.element("ogc:ComparisonOperator", "GreaterThanEqualTo");
                this.element("ogc:ComparisonOperator", "EqualTo");
                this.element("ogc:ComparisonOperator", "NotEqualTo");
                this.element("ogc:ComparisonOperator", "Like");
                this.element("ogc:ComparisonOperator", "Between");
                this.element("ogc:ComparisonOperator", "NullCheck");
                this.end("ogc:ComparisonOperators");
                this.start("ogc:ArithmeticOperators");
                this.element("ogc:SimpleArithmetic", null);
                this.functions();
                this.end("ogc:ArithmeticOperators");
                this.end("ogc:Scalar_Capabilities");
                this.start("ogc:Id_Capabilities");
                this.element("ogc:FID", null);
                this.element("ogc:EID", null);
                this.end("ogc:Id_Capabilities");
                this.end("ogc:Filter_Capabilities");
            }

            protected void functions() {
                this.start("ogc:Functions");
                Set<FunctionName> functions = WFS1_1.this.getAvailableFunctionNames();
                if (!functions.isEmpty()) {
                    this.start("ogc:FunctionNames");
                    for (FunctionName fe : functions) {
                        this.element("ogc:FunctionName", fe.getName(), WFS1_1.this.attributes("nArgs", "" + fe.getArgumentCount()));
                    }
                    this.end("ogc:FunctionNames");
                }
                this.end("ogc:Functions");
            }

            protected void keywords(KeywordInfo[] keywords) {
                if (keywords == null || keywords.length == 0) {
                    return;
                }
                this.start("ows:Keywords");
                for (KeywordInfo keyword : keywords) {
                    this.element("ows:Keyword", keyword.getValue());
                }
                this.end("ows:Keywords");
            }

            protected void keywords(List<KeywordInfo> keywords) {
                if (keywords != null) {
                    if (this.i18nRequested) {
                        keywords = this.internationalContentHelper.filterKeywords(keywords);
                    }
                    this.keywords(keywords.toArray(new KeywordInfo[keywords.size()]));
                }
            }

            protected void operation(String name, Map.Entry[] parameters, boolean get, boolean post) {
                this.operation(name, parameters, null, get, post);
            }

            protected void operation(String name, Map.Entry[] parameters, Map.Entry[] constraints, boolean get, boolean post) {
                this.start("ows:Operation", WFS1_1.this.attributes("name", name));
                String serviceURL = org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                this.dcp(serviceURL, get, post);
                for (Map.Entry parameter : parameters) {
                    String pname = (String)parameter.getKey();
                    String[] pvalues = (String[])parameter.getValue();
                    this.start("ows:Parameter", WFS1_1.this.attributes("name", pname));
                    for (String pvalue : pvalues) {
                        this.element("ows:Value", pvalue);
                    }
                    this.end("ows:Parameter");
                }
                for (int i = 0; constraints != null && i < constraints.length; ++i) {
                    String cname = (String)constraints[i].getKey();
                    String[] cvalues = (String[])constraints[i].getValue();
                    this.start("ows:Constraint", WFS1_1.this.attributes("name", cname));
                    for (String cvalue : cvalues) {
                        this.element("ows:Value", cvalue);
                    }
                    this.end("ows:Constraint");
                }
                this.end("ows:Operation");
            }

            protected void dcp(String serviceURL, boolean get, boolean post) {
                this.start("ows:DCP");
                this.start("ows:HTTP");
                if (get) {
                    this.element("ows:Get", null, WFS1_1.this.attributes("xlink:href", serviceURL));
                }
                if (post) {
                    this.element("ows:Post", null, WFS1_1.this.attributes("xlink:href", serviceURL));
                }
                this.end("ows:HTTP");
                this.end("ows:DCP");
            }

            protected void operation(OperationMetadata operation) {
                this.start("ows:Operation", WFS1_1.this.attributes("name", operation.getName()));
                String serviceURL = org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                this.dcp(serviceURL, operation.isGet(), operation.isPost());
                for (DomainType parameter : operation.getParameters()) {
                    this.domainType("ows:Parameter", parameter);
                }
                for (DomainType constraint : operation.getConstraints()) {
                    this.domainType("ows:Constraint", constraint);
                }
                this.end("ows:Operation");
            }

            protected void domainType(String elementName, DomainType domainType) {
                this.start(elementName, WFS1_1.this.attributes("name", domainType.getName()));
                if (domainType.getDefaultValue() != null) {
                    this.element("ows:Value", domainType.getDefaultValue());
                }
                if (!domainType.getAllowedValues().isEmpty()) {
                    for (String v : domainType.getAllowedValues()) {
                        this.element("ows:Value", v);
                    }
                }
                this.end(elementName);
            }
        }
    }

    public static class WFS1_0
    extends CapabilitiesTransformer {
        protected final boolean skipMisconfigured;

        public WFS1_0(WFSInfo wfs, Catalog catalog) {
            super(wfs, WFSInfo.Version.V_10, catalog);
            this.skipMisconfigured = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)wfs.getGeoServer().getGlobal().getResourceErrorHandling());
        }

        public Translator createTranslator(ContentHandler handler) {
            return new CapabilitiesTranslator1_0(handler);
        }

        protected class CapabilitiesTranslator1_0
        extends TransformerBase.TranslatorSupport {
            protected GetCapabilitiesRequest request;

            public CapabilitiesTranslator1_0(ContentHandler handler) {
                super(handler, null, null);
            }

            public void encode(Object object) throws IllegalArgumentException {
                this.request = GetCapabilitiesRequest.adapt(object);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "version", "version", "", "1.0.0");
                attributes.addAttribute("", "xmlns", "xmlns", "", CapabilitiesTransformer.WFS_URI);
                List namespaces = WFS1_0.this.catalog.getNamespaces();
                for (NamespaceInfo namespace : namespaces) {
                    String prefix = namespace.getPrefix();
                    String uri = namespace.getURI();
                    if ("xml".equals(prefix)) continue;
                    String prefixDef = "xmlns:" + prefix;
                    attributes.addAttribute("", prefixDef, prefixDef, "", uri);
                }
                attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", CapabilitiesTransformer.OGC_URI);
                attributes.addAttribute("", "xmlns:xsi", "xmlns:xsi", "", CapabilitiesTransformer.XSI_URI);
                String locationAtt = "xsi:schemaLocation";
                String locationDef = "http://www.opengis.net/wfs " + (WFS1_0.this.wfs.isCanonicalSchemaLocation() ? "http://schemas.opengis.net/wfs/1.0.0/WFS-capabilities.xsd" : org.geoserver.ows.util.ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wfs/1.0.0/WFS-capabilities.xsd"));
                attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
                this.start("WFS_Capabilities", attributes);
                this.handleService();
                this.handleCapability();
                this.handleFeatureTypes();
                this.handleFilterCapabilities();
                this.end("WFS_Capabilities");
            }

            protected void handleService() {
                this.start("Service");
                this.element("Name", WFS1_0.this.wfs.getName());
                this.element("Title", WFS1_0.this.wfs.getTitle());
                this.element("Abstract", WFS1_0.this.wfs.getAbstract());
                this.handleKeywords(WFS1_0.this.wfs.getKeywords());
                GeoServer geoServer = WFS1_0.this.wfs.getGeoServer();
                ContactInfo contact = geoServer.getSettings().getContact();
                String onlineResource = InternationalStringUtils.firstNonBlank((String[])new String[]{WFS1_0.this.wfs.getOnlineResource(), contact.getOnlineResource(), WFS1_0.this.wfs.getGeoServer().getSettings().getOnlineResource(), org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), null, null, (URLMangler.URLType)URLMangler.URLType.SERVICE)});
                if (onlineResource != null) {
                    try {
                        new URL(onlineResource);
                    }
                    catch (MalformedURLException e) {
                        LOGGER.log(Level.WARNING, "WFS online resource seems to be an invalid URL: '" + onlineResource + "'");
                    }
                }
                this.element("OnlineResource", onlineResource);
                this.element("Fees", WFS1_0.this.wfs.getFees());
                this.element("AccessConstraints", WFS1_0.this.wfs.getAccessConstraints());
                this.end("Service");
            }

            protected void handleKeywords(List<KeywordInfo> kwlist) {
                StringBuffer kwds = new StringBuffer();
                for (int i = 0; kwlist != null && i < kwlist.size(); ++i) {
                    kwds.append(kwlist.get(i));
                    if (i == kwlist.size() - 1) continue;
                    kwds.append(", ");
                }
                this.element("Keywords", kwds.toString());
            }

            protected void handleCapability() {
                this.start("Capability");
                this.start("Request");
                this.handleGetCapabilities();
                this.handleDescribeFT();
                this.handleGetFeature();
                if (WFS1_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.TRANSACTIONAL)) {
                    this.handleTransaction();
                }
                if (WFS1_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.COMPLETE)) {
                    this.handleLock();
                    this.handleFeatureWithLock();
                }
                this.end("Request");
                this.end("Capability");
            }

            protected void handleGetCapabilities() {
                String capName = "GetCapabilities";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            protected void handleDescribeFT() {
                String capName = "DescribeFeatureType";
                this.start(capName);
                this.start("SchemaDescriptionLanguage");
                this.element("XMLSCHEMA", null);
                this.end("SchemaDescriptionLanguage");
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            protected void handleGetFeature() {
                String capName = "GetFeature";
                this.start(capName);
                String resultFormat = "ResultFormat";
                this.start(resultFormat);
                if (WFS1_0.this.wfs.isCiteCompliant() && WFS1_0.this.isAllowed("GML2")) {
                    this.element("GML2", null);
                } else {
                    List featureProducers = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class);
                    HashSet<String> dupes = new HashSet<String>();
                    for (Object featureProducer : featureProducers) {
                        WFSGetFeatureOutputFormat format = (WFSGetFeatureOutputFormat)((Object)featureProducer);
                        for (String name : format.getCapabilitiesElementNames()) {
                            if (dupes.contains(name) || !WFS1_0.this.isAllowed(name)) continue;
                            this.element(name, null);
                            dupes.add(name);
                        }
                    }
                }
                this.end(resultFormat);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            protected void handleTransaction() {
                String capName = "Transaction";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            protected void handleLock() {
                String capName = "LockFeature";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            protected void handleFeatureWithLock() {
                String capName = "GetFeatureWithLock";
                this.start(capName);
                this.start("ResultFormat");
                this.element("GML2", null);
                this.end("ResultFormat");
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            protected void handleDcpType(String capabilityName, String httpMethod) {
                String onlineResource;
                if (CapabilitiesTransformer.HTTP_GET.equals(httpMethod)) {
                    onlineResource = org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", (Map)org.geoserver.ows.util.ResponseUtils.params((String[])new String[]{"request", capabilityName}), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                } else {
                    onlineResource = org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                    org.geoserver.ows.util.ResponseUtils.appendQueryString((String)onlineResource, (String)"");
                }
                this.start("DCPType");
                this.start("HTTP");
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "onlineResource", "onlineResource", "", onlineResource);
                this.element(httpMethod, null, atts);
                this.end("HTTP");
                this.end("DCPType");
            }

            protected void handleFeatureTypes() {
                this.start("FeatureTypeList");
                this.start("Operations");
                if (WFS1_0.this.wfs.getServiceLevel().contains(WFSInfo.ServiceLevel.BASIC)) {
                    this.element("Query", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_INSERT)) {
                    this.element("Insert", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_UPDATE)) {
                    this.element("Update", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_DELETE)) {
                    this.element("Delete", null);
                }
                if (WFS1_0.this.wfs.getServiceLevel().getOps().contains((Object)WFSInfo.Operation.LOCKFEATURE)) {
                    this.element("Lock", null);
                }
                this.end("Operations");
                ArrayList featureTypes = new ArrayList(WFS1_0.this.catalog.getFeatureTypes());
                Iterator it = featureTypes.iterator();
                while (it.hasNext()) {
                    FeatureTypeInfo ft = (FeatureTypeInfo)it.next();
                    if (ft.enabled()) continue;
                    it.remove();
                }
                if (this.request.getNamespace() != null) {
                    String namespace = this.request.getNamespace();
                    Iterator it2 = featureTypes.iterator();
                    while (it2.hasNext()) {
                        FeatureTypeInfo ft = (FeatureTypeInfo)it2.next();
                        if (namespace.equals(ft.getNamespace().getPrefix())) continue;
                        it2.remove();
                    }
                }
                Collections.sort(featureTypes, new FeatureTypeInfoTitleComparator());
                for (FeatureTypeInfo ftype : featureTypes) {
                    try {
                        this.mark();
                        this.handleFeatureType(ftype);
                        this.commit();
                    }
                    catch (RuntimeException e) {
                        ClientStreamAbortedException.rethrowUncheked((Exception)e);
                        if (WFS1_0.this.skipMisconfigured) {
                            this.reset();
                            LOGGER.log(Level.WARNING, "Couldn't encode WFS Capabilities entry for FeatureType: " + ftype.prefixedName(), e);
                            continue;
                        }
                        throw e;
                    }
                }
                this.end("FeatureTypeList");
            }

            protected void handleFeatureType(FeatureTypeInfo info) {
                ReferencedEnvelope bbox = info.getLatLonBoundingBox();
                this.start("FeatureType");
                this.element("Name", info.prefixedName());
                this.element("Title", info.getTitle());
                this.element("Abstract", info.getAbstract());
                this.handleKeywords(info.getKeywords());
                this.element("SRS", info.getSRS());
                String minx = String.valueOf(bbox.getMinX());
                String miny = String.valueOf(bbox.getMinY());
                String maxx = String.valueOf(bbox.getMaxX());
                String maxy = String.valueOf(bbox.getMaxY());
                AttributesImpl bboxAtts = new AttributesImpl();
                bboxAtts.addAttribute("", "minx", "minx", "", minx);
                bboxAtts.addAttribute("", "miny", "miny", "", miny);
                bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
                bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
                this.element("LatLongBoundingBox", null, bboxAtts);
                this.end("FeatureType");
            }

            protected void handleFilterCapabilities() {
                this.nsSupport.declarePrefix(CapabilitiesTransformer.OGC_PREFIX, CapabilitiesTransformer.OGC_URI);
                String ogc = "ogc:";
                this.start(ogc + "Filter_Capabilities");
                this.start(ogc + "Spatial_Capabilities");
                this.start(ogc + "Spatial_Operators");
                this.element(ogc + "Disjoint", null);
                this.element(ogc + "Equals", null);
                this.element(ogc + "DWithin", null);
                this.element(ogc + "Beyond", null);
                this.element(ogc + "Intersect", null);
                this.element(ogc + "Touches", null);
                this.element(ogc + "Crosses", null);
                this.element(ogc + "Within", null);
                this.element(ogc + "Contains", null);
                this.element(ogc + "Overlaps", null);
                this.element(ogc + "BBOX", null);
                this.end(ogc + "Spatial_Operators");
                this.end(ogc + "Spatial_Capabilities");
                this.start(ogc + "Scalar_Capabilities");
                this.element(ogc + "Logical_Operators", null);
                this.start(ogc + "Comparison_Operators");
                this.element(ogc + "Simple_Comparisons", null);
                this.element(ogc + "Between", null);
                this.element(ogc + "Like", null);
                this.element(ogc + "NullCheck", null);
                this.end(ogc + "Comparison_Operators");
                this.start(ogc + "Arithmetic_Operators");
                this.element(ogc + "Simple_Arithmetic", null);
                this.handleFunctions(ogc);
                this.end(ogc + "Arithmetic_Operators");
                this.end(ogc + "Scalar_Capabilities");
                this.end(ogc + "Filter_Capabilities");
            }

            protected void handleFunctions(String prefix) {
                this.start(prefix + "Functions");
                this.start(prefix + "Function_Names");
                Set<FunctionName> functions = WFS1_0.this.getAvailableFunctionNames();
                for (FunctionName fname : functions) {
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "nArgs", "nArgs", "", "" + fname.getArgumentCount());
                    this.element(prefix + "Function_Name", fname.getName(), atts);
                }
                this.end(prefix + "Function_Names");
                this.end(prefix + "Functions");
            }
        }
    }

    static enum Sections {
        ServiceIdentification,
        ServiceProvider,
        OperationsMetadata,
        FeatureTypeList,
        Filter_Capabilities,
        All;

    }
}

