/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetFeatureWithLockTest
extends WFS20TestSupport {
    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        this.getServiceDescriptor20().getOperations().add("ReleaseLock");
    }

    @Test
    public void testPOST() throws Exception {
        String xml = "<wfs:GetFeatureWithLock service='WFS' version='2.0.0' handle='GetFeatureWithLock-tc1' expiry='50' resultType='results' xmlns:sf='http://cite.opengeospatial.org/gmlsf' xmlns:wfs='http://www.opengis.net/wfs/2.0'><wfs:Query handle='qry-1' typeNames='sf:PrimitiveGeoFeature' /></wfs:GetFeatureWithLock>";
        Document dom = this.postAsDOM("wfs", xml);
        this.assertGML32(dom);
        Assert.assertNotNull((Object)dom.getDocumentElement().getAttribute("lockId"));
    }

    @Test
    public void testResultTypeHits() throws Exception {
        String xml = "<wfs:GetFeatureWithLock service='WFS' version='2.0.0' handle='GetFeatureWithLock-tc1' expiry='50' resultType='hits' xmlns:sf='http://cite.opengeospatial.org/gmlsf' xmlns:wfs='http://www.opengis.net/wfs/2.0'><wfs:Query handle='qry-1' typeNames='sf:PrimitiveGeoFeature' /></wfs:GetFeatureWithLock>";
        Document dom = this.postAsDOM("wfs", xml, 400);
        this.checkOws11Exception(dom, "2.0.0", "InvalidParameterValue", "resultType");
    }

    @Test
    public void testUpdateLockedFeatureWithLockId() throws Exception {
        Object xml = "<wfs:GetFeature service='WFS' version='2.0.0' expiry='100' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0'><wfs:Query typeNames='cdf:Locks'/></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", (String)xml);
        this.assertGML32(dom);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("cdf:Locks").getLength());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("gml:id");
        xml = "<wfs:GetFeatureWithLock service='WFS' version='2.0.0' expiry='100' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0'><wfs:Query typeNames='cdf:Locks'><fes:Filter><fes:ResourceId rid='" + fid + "'/></fes:Filter></wfs:Query></wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("wfs", (String)xml);
        this.assertGML32(dom);
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:Transaction   service=\"WFS\"   version=\"2.0.0\"   xmlns:cdf=\"http://www.opengis.net/cite/data\"   xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0' >   <wfs:LockId>" + lockId + "</wfs:LockId>  <wfs:Update typeName=\"cdf:Locks\" handle='foo'>     <wfs:Property>       <wfs:ValueReference>cdf:id</wfs:ValueReference>       <wfs:Value>gfwlbt0001</wfs:Value>     </wfs:Property>     <fes:Filter>       <fes:ResourceId rid=\"" + fid + "\"/>     </fes:Filter>   </wfs:Update> </wfs:Transaction> ";
        dom = this.postAsDOM("wfs", (String)xml);
        this.get("wfs?request=ReleaseLock&version=2.0.0&lockId=" + lockId);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated/text()", (Document)dom);
        XMLAssert.assertXpathExists((String)("//wfs:UpdateResults//fes:ResourceId[@rid = '" + fid + "']"), (Document)dom);
    }

    @Test
    public void testUpdateLockedFeatureWithoutLockId() throws Exception {
        Object xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" expiry=\"100\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0'><wfs:Query typeNames=\"cdf:Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("cdf:Locks").getLength());
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("gml:id");
        xml = "<wfs:GetFeatureWithLock service=\"WFS\" version=\"2.0.0\" expiry=\"100\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0'><wfs:Query typeNames=\"cdf:Locks\"><fes:Filter><fes:ResourceId rid=\"" + fid + "\"/></fes:Filter></wfs:Query></wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:Transaction   service=\"WFS\"   version=\"2.0.0\"   xmlns:cdf=\"http://www.opengis.net/cite/data\"   xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0' >   <wfs:Update typeName=\"cdf:Locks\">     <wfs:Property>       <wfs:ValueReference>cdf:id</wfs:ValueReference>       <wfs:Value>gfwlbt0001</wfs:Value>     </wfs:Property>     <fes:Filter>       <fes:ResourceId rid=\"" + fid + "\"/>     </fes:Filter>   </wfs:Update> </wfs:Transaction> ";
        dom = this.postAsDOM("wfs", (String)xml);
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"//ows:Exception[@exceptionCode = 'MissingParameterValue']", (Document)dom);
    }

    @Test
    public void testGetFeatureWithLockReleaseActionSomeOnTransaction() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"2.0.0\"  expiry=\"100\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"cdf:Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", (String)xml);
        NodeList locks = dom.getElementsByTagName("cdf:Locks");
        String fid1 = ((Element)locks.item(0)).getAttribute("gml:id");
        String fid2 = ((Element)locks.item(1)).getAttribute("gml:id");
        xml = "<wfs:GetFeatureWithLock  service=\"WFS\"  version=\"2.0.0\"  expiry=\"100\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"cdf:Locks\">    <fes:Filter>      <fes:ResourceId rid=\"" + fid1 + "\"/>      <fes:ResourceId rid=\"" + fid2 + "\"/>    </fes:Filter>  </wfs:Query></wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"2.0.0\"  releaseAction=\"SOME\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:LockId>" + lockId + "</wfs:LockId>  <wfs:Update typeName=\"cdf:Locks\">    <wfs:Property>      <wfs:ValueReference>cdf:id</wfs:ValueReference>      <wfs:Value>gfwlrs0003</wfs:Value>    </wfs:Property>    <fes:Filter>      <fes:ResourceId rid=\"" + fid1 + "\"/>    </fes:Filter>  </wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated/text()", (Document)dom);
        XMLAssert.assertXpathExists((String)("//wfs:UpdateResults//fes:ResourceId[@rid = '" + fid1 + "']"), (Document)dom);
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"2.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:LockId>" + lockId + "</wfs:LockId>  <wfs:Update typeName=\"cdf:Locks\">    <wfs:Property>      <wfs:ValueReference>cdf:id</wfs:ValueReference>      <wfs:Value>gfwlrs0004</wfs:Value>    </wfs:Property>    <fes:Filter>      <fes:ResourceId rid=\"" + fid2 + "\"/>    </fes:Filter>  </wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", (String)xml);
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated/text()", (Document)dom);
        XMLAssert.assertXpathExists((String)("//wfs:UpdateResults//fes:ResourceId[@rid = '" + fid2 + "']"), (Document)dom);
    }

    @Test
    public void testGetFeatureWithLockActionSome() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"2.0.0\"  expiry=\"100\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"cdf:Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", (String)xml);
        NodeList locks = dom.getElementsByTagName("cdf:Locks");
        int featureCount = locks.getLength();
        String fid1 = ((Element)locks.item(0)).getAttribute("gml:id");
        String fid2 = ((Element)locks.item(1)).getAttribute("gml:id");
        xml = "<wfs:GetFeatureWithLock  service=\"WFS\"  version=\"2.0.0\"  expiry=\"100\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"cdf:Locks\">    <fes:Filter>      <fes:ResourceId rid=\"" + fid1 + "\"/>      <fes:ResourceId rid=\"" + fid2 + "\"/>    </fes:Filter>  </wfs:Query></wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)("//cdf:Locks[@gml:id='" + fid1 + "']"), (Document)dom);
        XMLAssert.assertXpathExists((String)("//cdf:Locks[@gml:id='" + fid2 + "']"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//cdf:Locks)", (Document)dom);
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:GetFeatureWithLock  service=\"WFS\"  version=\"2.0.0\"  expiry=\"100\"  lockAction=\"SOME\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"cdf:Locks\"/></wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathNotExists((String)("//cdf:Locks[@gml:id='" + fid1 + "']"), (Document)dom);
        XMLAssert.assertXpathNotExists((String)("//cdf:Locks[@gml:id='" + fid2 + "']"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(featureCount - 2), (String)"count(//cdf:Locks)", (Document)dom);
        String secondLockId = dom.getDocumentElement().getAttribute("lockId");
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + secondLockId);
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"2.0.0\"  expiry=\"100\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("cdf/wfs", (String)xml);
        NodeList locks = dom.getElementsByTagName("cdf:Locks");
        String fid1 = ((Element)locks.item(0)).getAttribute("gml:id");
        String fid2 = ((Element)locks.item(1)).getAttribute("gml:id");
        xml = "<wfs:GetFeatureWithLock  service=\"WFS\"  version=\"2.0.0\"  expiry=\"100\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"Locks\">    <fes:Filter>      <fes:ResourceId rid=\"" + fid1 + "\"/>      <fes:ResourceId rid=\"" + fid2 + "\"/>    </fes:Filter>  </wfs:Query></wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("cdf/wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"2.0.0\"  releaseAction=\"SOME\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:LockId>" + lockId + "</wfs:LockId>  <wfs:Update typeName=\"Locks\">    <wfs:Property>      <wfs:ValueReference>cdf:id</wfs:ValueReference>      <wfs:Value>gfwlrs0003</wfs:Value>    </wfs:Property>    <fes:Filter>      <fes:ResourceId rid=\"" + fid1 + "\"/>    </fes:Filter>  </wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("cdf/wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated/text()", (Document)dom);
        XMLAssert.assertXpathExists((String)("//wfs:UpdateResults//fes:ResourceId[@rid = '" + fid1 + "']"), (Document)dom);
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"2.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:LockId>" + lockId + "</wfs:LockId>  <wfs:Update typeName=\"Locks\">    <wfs:Property>      <wfs:ValueReference>cdf:id</wfs:ValueReference>      <wfs:Value>gfwlrs0004</wfs:Value>    </wfs:Property>    <fes:Filter>      <fes:ResourceId rid=\"" + fid2 + "\"/>    </fes:Filter>  </wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("cdf/wfs", (String)xml);
        this.get("cdf/wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated/text()", (Document)dom);
        XMLAssert.assertXpathExists((String)("//wfs:UpdateResults//fes:ResourceId[@rid = '" + fid2 + "']"), (Document)dom);
    }

    @Test
    public void testLayerQualified() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"2.0.0\"  expiry=\"100\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        NodeList locks = dom.getElementsByTagName("cdf:Locks");
        String fid1 = ((Element)locks.item(0)).getAttribute("gml:id");
        String fid2 = ((Element)locks.item(1)).getAttribute("gml:id");
        xml = "<wfs:GetFeatureWithLock  service=\"WFS\"  version=\"2.0.0\"  expiry=\"100\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"Locks\">    <fes:Filter>      <fes:ResourceId rid=\"" + fid1 + "\"/>      <fes:ResourceId rid=\"" + fid2 + "\"/>    </fes:Filter>  </wfs:Query></wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("cdf/Fifteen/wfs", (String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"2.0.0\"  releaseAction=\"SOME\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:LockId>" + lockId + "</wfs:LockId>  <wfs:Update typeName=\"Locks\">    <wfs:Property>      <wfs:ValueReference>cdf:id</wfs:ValueReference>      <wfs:Value>gfwlrs0003</wfs:Value>    </wfs:Property>    <fes:Filter>      <fes:ResourceId rid=\"" + fid1 + "\"/>    </fes:Filter>  </wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated/text()", (Document)dom);
        XMLAssert.assertXpathExists((String)("//wfs:UpdateResults//fes:ResourceId[@rid = '" + fid1 + "']"), (Document)dom);
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"2.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:LockId>" + lockId + "</wfs:LockId>  <wfs:Update typeName=\"Locks\">    <wfs:Property>      <wfs:ValueReference>cdf:id</wfs:ValueReference>      <wfs:Value>gfwlrs0004</wfs:Value>    </wfs:Property>    <fes:Filter>      <fes:ResourceId rid=\"" + fid2 + "\"/>    </fes:Filter>  </wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        this.get("cdf/Locks/wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated/text()", (Document)dom);
        XMLAssert.assertXpathExists((String)("//wfs:UpdateResults//fes:ResourceId[@rid = '" + fid2 + "']"), (Document)dom);
    }

    @Test
    public void testLockTwice() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"2.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        NodeList locks = dom.getElementsByTagName("cdf:Locks");
        String fid1 = ((Element)locks.item(0)).getAttribute("gml:id");
        String fid2 = ((Element)locks.item(1)).getAttribute("gml:id");
        xml = "<wfs:GetFeatureWithLock  service=\"WFS\"  version=\"2.0.0\"  expiry=\"1000\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"Locks\">    <fes:Filter>      <fes:ResourceId rid=\"" + fid1 + "\"/>      <fes:ResourceId rid=\"" + fid2 + "\"/>    </fes:Filter>  </wfs:Query></wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        this.get("cdf/Locks/wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
    }

    @Test
    public void testLockExpirySeconds() throws Exception {
        Object xml = "<wfs:GetFeature  service=\"WFS\"  version=\"2.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        NodeList locks = dom.getElementsByTagName("cdf:Locks");
        String fid1 = ((Element)locks.item(0)).getAttribute("gml:id");
        String fid2 = ((Element)locks.item(1)).getAttribute("gml:id");
        xml = "<wfs:GetFeatureWithLock  service=\"WFS\"  version=\"2.0.0\"  expiry=\"1\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames=\"Locks\">    <fes:Filter>      <fes:ResourceId rid=\"" + fid1 + "\"/>      <fes:ResourceId rid=\"" + fid2 + "\"/>    </fes:Filter>  </wfs:Query></wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        Thread.sleep(2000L);
        dom = this.postAsDOM("cdf/Locks/wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        this.get("cdf/Locks/wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
    }
}

