/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.awt.RenderingHints;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class WFSReprojectionUtilTest {
    private final FeatureType featureType = WFSReprojectionUtilTest.createFeatureType();
    private final FilterFactory filterFactory = WFSReprojectionUtilTest.createFilterFactory();

    @BeforeClass
    public static void before() {
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)false);
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)true);
    }

    @AfterClass
    public static void after() {
        Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING);
    }

    private static FeatureType createFeatureType() {
        try {
            return DataUtilities.createType((String)"testType", (String)"geom:Point:srid=4326,line:LineString,name:String,id:int");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static FilterFactory createFilterFactory() {
        try {
            return CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Test
    public void testNullCheck() {
        CoordinateReferenceSystem crs = WFSReprojectionUtil.getDeclaredCrs((FeatureType)null, (String)"1.1.0");
        Assert.assertNull((Object)crs);
    }

    @Test
    public void testReprojectFilterWithTargetCrs() throws FactoryException {
        BBOX bbox = this.filterFactory.bbox((Expression)this.filterFactory.property("geom"), 10.0, 15.0, 20.0, 25.0, "EPSG:4326");
        CoordinateReferenceSystem webMercator = CRS.decode((String)"EPSG:3857");
        Filter clone = WFSReprojectionUtil.reprojectFilter((Filter)bbox, (FeatureType)this.featureType, (CoordinateReferenceSystem)webMercator);
        Assert.assertNotSame((Object)bbox, (Object)clone);
        BBOX clonedBbox = (BBOX)clone;
        Assert.assertEquals((Object)bbox.getExpression1(), (Object)clonedBbox.getExpression1());
        ReferencedEnvelope expected = new ReferencedEnvelope(1669792.36, 2782987.269831839, 1118889.97, 2273030.92, webMercator);
        Assert.assertTrue((boolean)JTS.equals((BoundingBox)expected, (BoundingBox)clonedBbox.getBounds(), (double)0.1));
    }

    @Test
    public void testAxisOrderWKT() throws Exception {
        String wkt = "GEOGCS[\"GCS_WGS_1984\",DATUM[\"WGS_1984\",SPHEROID[\"WGS_1984\",6378137,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.017453292519943295]]";
        CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt);
        Assert.assertEquals((Object)CRS.AxisOrder.EAST_NORTH, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)crs));
        CoordinateReferenceSystem declared = WFSReprojectionUtil.getDeclaredCrs((CoordinateReferenceSystem)crs, (String)"1.1.0");
        Assert.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)declared));
    }
}

