/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NumDecimalsTest
extends WFSTestSupport {
    @Before
    public void resetNumDecimals() {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo ft1 = cat.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        FeatureTypeInfo ft2 = cat.getFeatureTypeByName("sf", "AggregateGeoFeature");
        ft1.setNumDecimals(0);
        ft2.setNumDecimals(0);
        cat.save((ResourceInfo)ft1);
        cat.save((ResourceInfo)ft2);
    }

    @Test
    public void testDefaults() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&featureid=PrimitiveGeoFeature.f008&version=1.0.0");
        this.runAssertions(dom, 3);
    }

    @Test
    public void testGlobal() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo ft = cat.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        ft.setNumDecimals(-1);
        cat.save((ResourceInfo)ft);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setNumDecimals(1);
        this.getGeoServer().save(global);
        Document dom = this.getAsDOM("wfs?request=getfeature&featureid=PrimitiveGeoFeature.f008&version=1.0.0");
        this.runAssertions(dom, 1);
    }

    @Test
    public void testPerFeatureType() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo ft = cat.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        ft.setNumDecimals(1);
        cat.save((ResourceInfo)ft);
        Document dom = this.getAsDOM("wfs?request=getfeature&featureid=PrimitiveGeoFeature.f008&version=1.0.0");
        this.runAssertions(dom, 1);
    }

    @Test
    public void testMultipleFeatureTypes() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo ft1 = cat.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        FeatureTypeInfo ft2 = cat.getFeatureTypeByName("sf", "AggregateGeoFeature");
        ft1.setNumDecimals(3);
        cat.save((ResourceInfo)ft1);
        ft2.setNumDecimals(1);
        cat.save((ResourceInfo)ft2);
        Document dom = this.getAsDOM("wfs?request=getfeature&featureid=PrimitiveGeoFeature.f008,AggregateGeoFeature.f009&version=1.0.0");
        this.runAssertions(dom, 3);
    }

    void runAssertions(Document dom, int numdecimals) throws Exception {
        NodeList nl = dom.getElementsByTagName("gml:coordinates");
        for (int x = 0; x < nl.getLength(); ++x) {
            String[] tuples;
            Element e = (Element)nl.item(x);
            for (String tuple : tuples = e.getFirstChild().getNodeValue().split(" ")) {
                String[] coord;
                for (String s : coord = tuple.split(",")) {
                    int dot = s.indexOf(46);
                    Assert.assertEquals((long)numdecimals, (long)s.substring(dot + 1).length());
                }
            }
        }
    }
}

