/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetFeatureHitsIgnoreMaxFeaturesTest
extends WFSTestSupport {
    @Test
    public void testHitsIgnoreMaxFeaturesEnabled() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setMaxFeatures(1);
        wfs.setHitsIgnoreMaxFeatures(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs&resultType=hits");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"15", (Object)xpath.getMatchingNodes("//wfs:FeatureCollection/@numberOfFeatures", doc).item(0).getNodeValue());
    }

    @Test
    public void testGetFeatureRespectsMaxFeatures() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setMaxFeatures(1);
        wfs.setHitsIgnoreMaxFeatures(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("cdf:Fifteen");
        Assert.assertEquals((long)1L, (long)featureMembers.getLength());
    }

    @Test
    public void testHitsIgnoreMaxFeaturesDisabled() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setMaxFeatures(1);
        wfs.setHitsIgnoreMaxFeatures(false);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs&resultType=hits");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xpath.getMatchingNodes("//wfs:FeatureCollection/@numberOfFeatures", doc).item(0).getNodeValue());
    }
}

