/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wfs.WFSInfo;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class WfsXmlWriter {
    WFSInfo wfs;
    OutputStream output;
    String charSetEncoding;
    NamespaceSupport namespaceSupport;
    Map<String, String> schemaLocations;
    String version;
    BufferedWriter writer;

    public WfsXmlWriter(WFSInfo wfs, OutputStream output) {
        this.wfs = wfs;
        this.output = output;
        this.charSetEncoding = wfs.getGeoServer().getSettings().getCharset();
        this.schemaLocations = new HashMap<String, String>();
        this.namespaceSupport = new NamespaceSupport();
        this.namespaceSupport.declarePrefix("xs", "http://www.w3.org/2001/XMLSchema");
        this.namespaceSupport.declarePrefix("ogc", "http://www.opengis.net/ogc");
        this.namespaceSupport.declarePrefix("gml", "http://www.opengis.net/gml");
        this.namespaceSupport.declarePrefix("wfs", "http://www.opengis.net/wfs");
        this.namespaceSupport.declarePrefix("", "http://www.opengis.net/wfs");
    }

    public void setCharSetEncoding(String charSetEncoding) {
        this.charSetEncoding = charSetEncoding;
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.namespaceSupport;
    }

    private void init() throws IOException {
        Enumeration<String> e = this.namespaceSupport.getDeclaredPrefixes();
        while (e.hasMoreElements()) {
            String pre = e.nextElement();
            String uri = this.namespaceSupport.getURI(pre);
            if ("".equals(pre)) {
                this.attribute("xmlns" + pre, uri);
                continue;
            }
            this.attribute("xmlns:" + pre, uri);
        }
        if (!this.schemaLocations.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            Iterator<Map.Entry<String, String>> e2 = this.schemaLocations.entrySet().iterator();
            while (e2.hasNext()) {
                Map.Entry<String, String> entry = e2.next();
                String uri = entry.getKey();
                String location = entry.getValue();
                buffer.append(uri + " " + location);
                if (!e2.hasNext()) continue;
                buffer.append(" ");
            }
            this.attribute("xs:schemaLocation", buffer.toString());
        }
    }

    private void attribute(String name, String value) throws IOException {
        this.writer.write(" " + name + "=\"" + value + "\"");
    }

    public void openTag(String prefix, String name) throws IOException {
        this.openTag(prefix, name, null);
    }

    public void openTag(String prefix, String name, String[] attributes) throws IOException {
        boolean root;
        boolean bl = root = this.writer == null;
        if (root) {
            this.writer = new BufferedWriter(new OutputStreamWriter(this.output, this.wfs.getGeoServer().getSettings().getCharset()));
            this.writer.write("<?xml version=\"1.0\" encoding=\"" + this.charSetEncoding + "\"?>");
        }
        if (prefix != null) {
            this.writer.write("<" + prefix + ":" + name);
        } else {
            this.writer.write("<" + name);
        }
        if (root) {
            this.init();
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.length; i += 2) {
                this.attribute(attributes[i], attributes[i + 1]);
            }
        }
        this.writer.write(">");
    }

    public void text(String text) throws IOException {
        this.writer.write(text);
    }

    public void closeTag(String prefix, String name) throws IOException {
        if (prefix != null) {
            this.writer.write("</" + prefix + ":" + name + ">");
        } else {
            this.writer.write("</" + name + ">");
        }
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
        this.writer = null;
    }

    public static class WFS1_1
    extends WfsXmlWriter {
        public WFS1_1(WFSInfo wfs, OutputStream output) {
            super(wfs, output);
            this.namespaceSupport.declarePrefix("ows", "http://www.opengis.net/ows");
            this.schemaLocations.put("http://www.opengis.net/wfs", ResponseUtils.appendPath((String[])new String[]{wfs.getSchemaBaseURL(), "wfs/1.1.0/wfs.xsd"}));
            this.version = "1.1.0";
        }
    }

    public static class WFS1_0
    extends WfsXmlWriter {
        public WFS1_0(WFSInfo wfs, OutputStream output) {
            super(wfs, output);
            this.schemaLocations.put("http://www.opengis.net/wfs", ResponseUtils.appendPath((String[])new String[]{wfs.getSchemaBaseURL(), "wfs/1.0.0/WFS-transaction.xsd"}));
            this.version = "1.0.0";
        }
    }
}

