/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.EntityResolverProvider;
import org.geotools.api.filter.Filter;
import org.geotools.filter.FilterHandler;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.xml.filter.FilterFilter;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.vfny.geoserver.util.requests.FilterHandlerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public abstract class FilterKvpParser
extends KvpParser {
    private EntityResolverProvider entityResolverProvider;

    public FilterKvpParser(GeoServer geoServer) {
        super("filter", List.class);
        this.entityResolverProvider = new EntityResolverProvider(geoServer);
    }

    protected abstract Configuration getParserConfiguration();

    public Object parse(String value) throws Exception {
        Configuration configuration = this.getParserConfiguration();
        Parser parser = new Parser(configuration);
        parser.setEntityResolver(this.entityResolverProvider.getEntityResolver());
        List unparsed = KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
        ArrayList<Object> filters = new ArrayList<Object>();
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            String string = (String)i.next();
            if ("".equals(string.trim())) {
                filters.add(Filter.INCLUDE);
                continue;
            }
            try {
                Filter filter = (Filter)parser.parse((Reader)new StringReader(string));
                if (filter == null) {
                    throw new NullPointerException();
                }
                filters.add(filter);
            }
            catch (Exception e) {
                String msg = "Unable to parse filter: " + string;
                LOGGER.log(Level.WARNING, msg, e);
                Filter filter = this.parseXMLFilterWithOldParser(new StringReader(string));
                if (filter == null) continue;
                filters.add(filter);
            }
        }
        return filters;
    }

    protected Filter parseXMLFilterWithOldParser(Reader rawRequest) throws ServiceException {
        InputSource requestSource = new InputSource(rawRequest);
        FilterHandlerImpl contentHandler = new FilterHandlerImpl();
        contentHandler.setEntityResolver(this.entityResolverProvider.getEntityResolver());
        FilterFilter filterParser = new FilterFilter((FilterHandler)contentHandler, null);
        GMLFilterGeometry geometryFilter = new GMLFilterGeometry((GMLHandlerJTS)filterParser);
        GMLFilterDocument documentFilter = new GMLFilterDocument((GMLHandlerGeometry)geometryFilter);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserAdapter adapter = new ParserAdapter(parser.getParser());
            adapter.setEntityResolver(this.entityResolverProvider.getEntityResolver());
            adapter.setContentHandler((ContentHandler)documentFilter);
            adapter.parse(requestSource);
            LOGGER.fine("just parsed: " + requestSource);
        }
        catch (SAXException e) {
            throw new ServiceException((Throwable)e, "XML getFeature request SAX parsing error", XmlRequestReader.class.getName());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e, "XML get feature request input error", XmlRequestReader.class.getName());
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException((Throwable)e, "Some sort of issue creating parser", XmlRequestReader.class.getName());
        }
        LOGGER.fine("passing filter: " + contentHandler.getFilter());
        return contentHandler.getFilter();
    }
}

