/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.geoserver.wfs.json.ComplexGeoJsonWriterOptions;
import org.geoserver.wfs.json.DefaultComplexGeoJsonWriterOptions;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.feature.type.PropertyType;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.xml.sax.Attributes;

class ComplexGeoJsonWriter {
    static final Logger LOGGER = Logging.getLogger(ComplexGeoJsonWriter.class);
    private static final String DATATYPE = "@dataType";
    private static final String INSIDE_ARRAY_ATTRIBUTE = "${inside-array}";
    private final GeoJSONBuilder jsonWriter;
    private boolean geometryFound = false;
    private CoordinateReferenceSystem crs;
    private long featuresCount = 0L;
    private final ComplexGeoJsonWriterOptions settings;

    public ComplexGeoJsonWriter(GeoJSONBuilder jsonWriter, ComplexGeoJsonWriterOptions settings) {
        this.jsonWriter = jsonWriter;
        this.settings = settings;
    }

    public ComplexGeoJsonWriter(GeoJSONBuilder jsonWriter) {
        this(jsonWriter, new DefaultComplexGeoJsonWriterOptions());
    }

    public void write(List<FeatureCollection> collections) {
        for (FeatureCollection collection : collections) {
            FeatureIterator iterator = collection.features();
            try {
                this.encodeFeatureCollection(iterator);
            }
            finally {
                if (iterator == null) continue;
                iterator.close();
            }
        }
    }

    private void encodeFeatureCollection(FeatureIterator iterator) {
        while (iterator.hasNext()) {
            this.encodeFeature(iterator.next(), true);
            ++this.featuresCount;
        }
    }

    protected void encodeFeature(Feature feature, boolean topLevelFeature) {
        this.jsonWriter.object();
        this.jsonWriter.key("type").value((Object)"Feature");
        FeatureId identifier = feature.getIdentifier();
        if (identifier != null) {
            this.jsonWriter.key("id").value(identifier.getID());
        }
        Property geometryAttribute = this.encodeGeometry(feature);
        this.jsonWriter.key("properties");
        this.jsonWriter.object();
        this.jsonWriter.key("@featureType").value((Object)this.getSimplifiedTypeName(feature.getType().getName()));
        this.encodeProperties(geometryAttribute, (PropertyType)feature.getType(), feature.getProperties());
        this.jsonWriter.endObject();
        this.writeExtraFeatureProperties(feature, topLevelFeature);
        this.jsonWriter.endObject();
    }

    protected void writeExtraFeatureProperties(Feature feature, boolean topLevelfeature) {
    }

    private String getSimplifiedTypeName(Name name) {
        String localName = name.getLocalPart();
        if (localName.endsWith("_Type")) {
            return localName.substring(0, localName.length() - "_Type".length());
        }
        if (localName.endsWith("Type")) {
            return localName.substring(0, localName.length() - "Type".length());
        }
        return localName;
    }

    private Property encodeGeometry(Feature feature) {
        GeometryDescriptor geometryType = feature.getType().getGeometryDescriptor();
        Property geometryAttribute = null;
        Geometry geometry = null;
        if (geometryType != null) {
            CoordinateReferenceSystem crs = geometryType.getCoordinateReferenceSystem();
            this.jsonWriter.setAxisOrder(CRS.getAxisOrder((CoordinateReferenceSystem)crs));
            if (crs != null) {
                this.crs = crs;
            }
            geometry = (geometryAttribute = feature.getProperty(geometryType.getName())) != null ? (Geometry)geometryAttribute.getValue() : null;
        } else {
            this.jsonWriter.setAxisOrder(CRS.AxisOrder.EAST_NORTH);
        }
        this.jsonWriter.key("geometry");
        if (geometry != null) {
            this.jsonWriter.writeGeom(geometry);
            this.geometryFound = true;
        } else {
            this.jsonWriter.value(null);
        }
        return geometryAttribute;
    }

    private void encodeProperties(Property geometryAttribute, PropertyType parentType, Collection<Property> properties) {
        Map<PropertyDescriptor, List<Property>> index = this.indexPropertiesByDescriptor(geometryAttribute, properties);
        for (Map.Entry<PropertyDescriptor, List<Property>> entry : index.entrySet()) {
            this.encodePropertiesByType(parentType, entry.getKey(), entry.getValue());
        }
    }

    private Map<PropertyDescriptor, List<Property>> indexPropertiesByDescriptor(Property geometryAttribute, Collection<Property> properties) {
        LinkedHashMap<PropertyDescriptor, List<Property>> index = new LinkedHashMap<PropertyDescriptor, List<Property>>();
        for (Property property : properties) {
            if (geometryAttribute != null && geometryAttribute.equals(property)) continue;
            ArrayList<Property> propertiesWithSameDescriptor = (ArrayList<Property>)index.get(property.getDescriptor());
            if (propertiesWithSameDescriptor == null) {
                propertiesWithSameDescriptor = new ArrayList<Property>();
                index.put(property.getDescriptor(), propertiesWithSameDescriptor);
            }
            propertiesWithSameDescriptor.add(property);
        }
        return index;
    }

    private void encodePropertiesByType(PropertyType parentType, PropertyDescriptor descriptor, List<Property> properties) {
        List<Feature> chainedFeatures = this.getChainedFeatures(properties);
        if (chainedFeatures == null || chainedFeatures.isEmpty() || descriptor.getMaxOccurs() == 1) {
            List<Map<NameImpl, String>> linkedFeatures = this.getLinkedFeatures(properties);
            if (!linkedFeatures.isEmpty()) {
                this.encodeLinkedFeatures(descriptor, linkedFeatures);
            } else {
                this.encodeProperties(descriptor, properties);
            }
        } else {
            this.encodeChainedFeatures(descriptor.getName().getLocalPart(), chainedFeatures);
        }
    }

    private void encodeProperties(PropertyDescriptor descriptor, List<Property> properties) {
        String attributeName = descriptor.getName().getLocalPart();
        if (properties.size() > 1 && this.areAllPropertiesAttributeNameEquals(properties, attributeName)) {
            this.encodeArray(properties, attributeName);
        } else {
            properties.forEach(this::encodeProperty);
        }
    }

    private void encodeArray(List<Property> properties, String attributeName) {
        this.jsonWriter.key(attributeName).array();
        properties.forEach(prop -> this.encodeProperty(INSIDE_ARRAY_ATTRIBUTE, (Property)prop, this.getAttributes((Property)prop)));
        this.jsonWriter.endArray();
    }

    private boolean areAllPropertiesAttributeNameEquals(List<Property> properties, String attributeName) {
        return properties.stream().allMatch(prop -> Objects.equals(attributeName, prop.getName().getLocalPart()));
    }

    private void encodeLinkedFeatures(PropertyDescriptor descriptor, List<Map<NameImpl, String>> linkedFeatures) {
        this.jsonWriter.key(descriptor.getName().getLocalPart());
        if (descriptor.getMaxOccurs() > 1) {
            this.jsonWriter.array();
        }
        for (Map<NameImpl, String> feature : linkedFeatures) {
            this.encodeAttributesAsObject(feature);
        }
        if (descriptor.getMaxOccurs() > 1) {
            this.jsonWriter.endArray();
        }
    }

    private void encodeChainedFeatures(String attributeName, List<Feature> chainedFeatures) {
        this.key(attributeName);
        if (!this.isInsideArrayAttributeName(attributeName)) {
            this.jsonWriter.array();
        }
        for (Feature feature : chainedFeatures) {
            if (feature.getType().getGeometryDescriptor() != null) {
                this.encodeFeature(feature, false);
                continue;
            }
            this.jsonWriter.object();
            this.encodeProperties(null, (PropertyType)feature.getType(), feature.getProperties());
            this.jsonWriter.endObject();
        }
        if (!this.isInsideArrayAttributeName(attributeName)) {
            this.jsonWriter.endArray();
        }
    }

    private boolean isInsideArrayAttributeName(String attributeName) {
        return INSIDE_ARRAY_ATTRIBUTE.equals(attributeName);
    }

    private List<Feature> getChainedFeatures(List<Property> properties) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Property property : properties) {
            if (!(property instanceof ComplexAttribute)) {
                return null;
            }
            ComplexAttribute complexProperty = (ComplexAttribute)property;
            Collection subProperties = complexProperty.getProperties();
            if (subProperties.size() > 1) {
                return null;
            }
            Property subProperty = (Property)this.getElementAt(subProperties, 0);
            if (!(subProperty instanceof Feature)) {
                return null;
            }
            features.add((Feature)subProperty);
        }
        return features;
    }

    private List<Map<NameImpl, String>> getLinkedFeatures(List<Property> properties) {
        ArrayList<Map<NameImpl, String>> linkedFeatures = new ArrayList<Map<NameImpl, String>>();
        for (Property property : properties) {
            Map attributes;
            if (!ComplexGeoJsonWriter.checkIfFeatureIsLinked(property, attributes = (Map)property.getUserData().get(Attributes.class))) continue;
            linkedFeatures.add(attributes);
        }
        return linkedFeatures;
    }

    static boolean checkIfFeatureIsLinked(Property property, Map<NameImpl, String> attributes) {
        if (!(property instanceof ComplexAttribute)) {
            return false;
        }
        ComplexAttribute complexProperty = (ComplexAttribute)property;
        if (complexProperty.getProperties() != null && !complexProperty.getProperties().isEmpty()) {
            return false;
        }
        if (attributes != null) {
            for (NameImpl key : attributes.keySet()) {
                if (key == null || !"href".equalsIgnoreCase(key.getLocalPart())) continue;
                return true;
            }
        }
        return false;
    }

    private <T> T getElementAt(Collection<T> collection, int index) {
        Iterator<T> iterator = collection.iterator();
        T element = null;
        for (int i = 0; i <= index && iterator.hasNext(); ++i) {
            element = iterator.next();
        }
        return element;
    }

    private void encodeProperty(Property property) {
        Map<NameImpl, Object> attributes = this.getAttributes(property);
        String attributeName = property.getName().getLocalPart();
        this.encodeProperty(attributeName, property, attributes);
    }

    private Map<NameImpl, Object> getAttributes(Property property) {
        Map<NameImpl, Object> attributes = (Map<NameImpl, Object>)property.getUserData().get(Attributes.class);
        return attributes != null ? attributes : Collections.emptyMap();
    }

    private void encodeProperty(String attributeName, Property property, Map<NameImpl, Object> attributes) {
        if (property instanceof ComplexAttribute) {
            ComplexAttribute complexAttribute = (ComplexAttribute)property;
            if (this.isSimpleContent((AttributeType)complexAttribute.getType())) {
                Object value = this.getSimpleContentValue(complexAttribute);
                if (value != null || attributes != null && !attributes.isEmpty()) {
                    this.encodeSimpleAttribute(attributeName, value, attributes);
                }
            } else if (this.isGMLPropertyType(complexAttribute)) {
                Collection value = complexAttribute.getValue();
                Property nested = (Property)value.iterator().next();
                Map nestedAttributes = (Map)nested.getUserData().get(Attributes.class);
                Map<NameImpl, Object> mergedAttributes = this.mergeMaps(attributes, nestedAttributes);
                this.encodeProperty(attributeName, nested, mergedAttributes);
            } else {
                this.encodeComplexAttribute(attributeName, complexAttribute, attributes);
            }
        } else if (property instanceof Attribute) {
            List<Feature> features = this.getFeatures((Attribute)property);
            if (features != null) {
                this.encodeChainedFeatures(attributeName, features);
            } else {
                this.encodeSimpleAttribute(attributeName, property.getValue(), attributes);
            }
        } else {
            throw new RuntimeException(String.format("Invalid property '%s' of type '%s', only 'Attribute' and 'ComplexAttribute' properties types are supported.", property.getName(), property.getClass().getCanonicalName()));
        }
    }

    private <K, V> Map<K, V> mergeMaps(Map<K, V> mapA, Map<K, V> mapB) {
        if (mapA == null) {
            return mapB;
        }
        if (mapB == null) {
            return mapA;
        }
        HashMap<K, V> merged = new HashMap<K, V>(mapA);
        merged.putAll(mapB);
        return merged;
    }

    private boolean isGMLPropertyType(ComplexAttribute complexAttribute) {
        String attributeName = complexAttribute.getType().getName().getLocalPart();
        if (!attributeName.endsWith("PropertyType")) {
            return false;
        }
        Collection value = complexAttribute.getValue();
        if (value.size() != 1) {
            return false;
        }
        Property containedProperty = (Property)value.iterator().next();
        String containedPropertyTypeName = containedProperty.getType().getName().getLocalPart();
        String containedPropertyName = containedProperty.getName().getLocalPart();
        String propertyTypePrefix = attributeName.endsWith("_PropertyType") ? attributeName.substring(0, attributeName.length() - "_PropertyType".length()) : attributeName.substring(0, attributeName.length() - "PropertyType".length());
        return containedPropertyTypeName.equals(propertyTypePrefix + "Type") || containedPropertyName.equals(propertyTypePrefix);
    }

    private List<Feature> getFeatures(Attribute attribute) {
        Object value = attribute.getValue();
        if (value instanceof Feature) {
            return Collections.singletonList((Feature)value);
        }
        if (!(value instanceof Collection)) {
            return null;
        }
        Collection collection = (Collection)value;
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        if (!(this.getElementAt(collection, 0) instanceof Feature)) {
            return null;
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Object object : collection) {
            if (!(object instanceof Feature)) {
                throw new RuntimeException(String.format("Unable to handle attribute '%s'.", attribute));
            }
            features.add((Feature)object);
        }
        return features;
    }

    private boolean isSimpleContent(AttributeType type) {
        if ("http://www.w3.org/2001/XMLSchema".equals(type.getName().getNamespaceURI()) && type.getName().getLocalPart().equals("anySimpleType")) {
            return true;
        }
        AttributeType superType = type.getSuper();
        if (superType == null) {
            return false;
        }
        return this.isSimpleContent(superType);
    }

    private Object getSimpleContentValue(ComplexAttribute property) {
        Collection properties = property.getProperties();
        if (properties.isEmpty() || properties.size() > 1) {
            return null;
        }
        Property simpleContent = (Property)this.getElementAt(properties, 0);
        if (simpleContent == null) {
            return null;
        }
        Name name = simpleContent.getName();
        if (name == null || !name.getLocalPart().equals("simpleContent")) {
            return null;
        }
        return simpleContent.getValue();
    }

    private void encodeComplexAttribute(String name, ComplexAttribute attribute, Map<NameImpl, Object> attributes) {
        if (this.isFullFeature(attribute)) {
            this.key(name);
            this.encodeFeature((Feature)attribute, false);
        } else {
            this.key(name);
            this.jsonWriter.object();
            if (this.settings.encodeComplexAttributeType()) {
                this.jsonWriter.key(DATATYPE);
                this.jsonWriter.value(this.getSimplifiedTypeName(attribute.getType().getName()));
            }
            if (attribute.getProperties() != null && !attribute.getProperties().isEmpty()) {
                this.encodeProperties(null, (PropertyType)attribute.getType(), attribute.getProperties());
            }
            if (attributes != null && !attributes.isEmpty()) {
                this.encodeAttributes(attributes);
            }
            this.jsonWriter.endObject();
        }
    }

    private boolean isFullFeature(ComplexAttribute attribute) {
        return attribute instanceof Feature && !this.settings.encodeNestedFeatureAsProperty(attribute.getType());
    }

    private void encodeSimpleAttribute(String name, Object value, Map<NameImpl, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            this.key(name);
            this.jsonWriter.value(value);
            return;
        }
        this.key(name);
        this.jsonWriter.object();
        if (value != null) {
            this.jsonWriter.key("value").value(value);
        }
        this.encodeAttributes(attributes);
        this.jsonWriter.endObject();
    }

    private void key(String name) {
        if (!this.isInsideArrayAttributeName(name)) {
            this.jsonWriter.key(name);
        }
    }

    private void encodeAttributes(Map<NameImpl, Object> attributes) {
        attributes.forEach((name, value) -> {
            if (value != null) {
                this.jsonWriter.key("@" + name.getLocalPart()).value(value);
            }
        });
    }

    private void encodeAttributesAsObject(Map<NameImpl, String> attributes) {
        this.jsonWriter.object();
        attributes.forEach((name, value) -> {
            if (value != null) {
                this.jsonWriter.key("@" + name.getLocalPart()).value(value);
            }
        });
        this.jsonWriter.endObject();
    }

    public boolean geometryFound() {
        return this.geometryFound;
    }

    public CoordinateReferenceSystem foundCrs() {
        return this.crs;
    }

    public long getFeaturesCount() {
        return this.featuresCount;
    }
}

