/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.config.SettingsInfo;
import org.geoserver.wfs.WFSTransactionException;

class WFSTransactionExceptionFactory {
    private final SettingsInfo settings;

    public WFSTransactionExceptionFactory(SettingsInfo settings) {
        this.settings = settings;
    }

    public WFSTransactionException newWFSTransactionException(String errorMessage, Throwable cause) {
        return new WFSTransactionException(this.getFinalMessage(errorMessage, cause), cause);
    }

    public WFSTransactionException newWFSTransactionException(String errorMessage, Throwable cause, String code) {
        return new WFSTransactionException(this.getFinalMessage(errorMessage, cause), cause, code);
    }

    public WFSTransactionException newWFSTransactionException(String errorMessage, Throwable cause, String code, String locator, String handle) {
        return new WFSTransactionException(this.getFinalMessage(errorMessage, cause), cause, code, locator, handle);
    }

    private String getFinalMessage(String errorMessage, Throwable cause) {
        String finalMessage = this.settings.isVerboseExceptions() ? this.decorateMessageWithUnderlyingCause(errorMessage, cause) : errorMessage;
        return finalMessage;
    }

    private String decorateMessageWithUnderlyingCause(String errorMessage, Throwable cause) {
        if (errorMessage == null || cause == null) {
            return errorMessage;
        }
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append(errorMessage);
        Throwable underlyingCause = cause.getCause();
        if (underlyingCause != null) {
            msgBuilder.append(" (");
            while (underlyingCause != null) {
                msgBuilder.append(underlyingCause.getMessage());
                if ((underlyingCause = underlyingCause.getCause()) == null) continue;
                msgBuilder.append(", ");
            }
            msgBuilder.append(")");
        }
        return msgBuilder.toString();
    }
}

