/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import javax.xml.namespace.QName;
import net.opengis.wfs20.ListStoredQueriesResponseType;
import net.opengis.wfs20.ListStoredQueriesType;
import net.opengis.wfs20.StoredQueryListItemType;
import net.opengis.wfs20.TitleType;
import net.opengis.wfs20.Wfs20Factory;
import org.geoserver.catalog.Catalog;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSException;

public class ListStoredQueries {
    private Catalog catalog;
    StoredQueryProvider storedQueryProvider;

    public ListStoredQueries(Catalog catalog, StoredQueryProvider storedQueryProvider) {
        this.storedQueryProvider = storedQueryProvider;
        this.catalog = catalog;
    }

    public ListStoredQueriesResponseType run(ListStoredQueriesType request) throws WFSException {
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        ListStoredQueriesResponseType response = factory.createListStoredQueriesResponseType();
        for (StoredQuery sq : this.storedQueryProvider.listStoredQueries()) {
            StoredQueryListItemType item = factory.createStoredQueryListItemType();
            item.setId(sq.getName());
            TitleType title = factory.createTitleType();
            title.setValue(sq.getTitle());
            item.getTitle().add((Object)title);
            if (!sq.getFeatureTypes().isEmpty()) {
                item.getReturnFeatureType().addAll(sq.getFeatureTypes());
            } else {
                this.catalog.getFeatureTypes().stream().map(ft -> new QName(ft.getNamespace().getURI(), ft.getName(), ft.getNamespace().getPrefix())).forEach(qn -> item.getReturnFeatureType().add(qn));
            }
            response.getStoredQuery().add((Object)item);
        }
        return response;
    }
}

