/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import net.opengis.wfs20.FeatureCollectionType;
import net.opengis.wfs20.GetFeatureType;
import net.opengis.wfs20.GetPropertyValueType;
import net.opengis.wfs20.QueryType;
import net.opengis.wfs20.ValueCollectionType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.wfs.GetFeature;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.feature.FeatureCollection;
import org.geotools.wfs.PropertyValueCollection;
import org.xml.sax.helpers.NamespaceSupport;

public class GetPropertyValue {
    Pattern FEATURE_ID_PATTERN = Pattern.compile("@(\\w+:)?id");
    GetFeature delegate;
    Catalog catalog;
    FilterFactory filterFactory;

    public GetPropertyValue(WFSInfo info, Catalog catalog, FilterFactory filterFactory) {
        this.delegate = new GetFeature(info, catalog);
        this.delegate.setFilterFactory(filterFactory);
        this.catalog = catalog;
        this.filterFactory = filterFactory;
    }

    public NamespaceSupport getNamespaceSupport() {
        NamespaceSupport ns = new NamespaceSupport();
        for (NamespaceInfo ni : this.catalog.getNamespaces()) {
            ns.declarePrefix(ni.getPrefix(), ni.getURI());
        }
        return ns;
    }

    public ValueCollectionType run(GetPropertyValueType request) throws WFSException {
        if (request.getValueReference() == null) {
            throw new WFSException((EObject)request, "No valueReference specified", "MissingParameterValue").locator("valueReference");
        }
        if ("".equals(request.getValueReference().trim())) {
            throw new WFSException((EObject)request, "ValueReference cannot be empty", "InvalidParameterValue").locator("valueReference");
        }
        GetFeatureType getFeature = Wfs20Factory.eINSTANCE.createGetFeatureType();
        getFeature.setBaseUrl(request.getBaseUrl());
        getFeature.getAbstractQueryExpression().add((Object)request.getAbstractQueryExpression());
        getFeature.setResolve(request.getResolve());
        getFeature.setResolveDepth((Object)request.getResolveDepth());
        getFeature.setResolveTimeout(request.getResolveTimeout());
        getFeature.setCount(request.getCount());
        FeatureCollectionType fc = (FeatureCollectionType)this.delegate.run(GetFeatureRequest.adapt(getFeature)).getAdaptee();
        QueryType query = (QueryType)request.getAbstractQueryExpression();
        QName typeName = (QName)query.getTypeNames().iterator().next();
        FeatureTypeInfo featureType = this.catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        try {
            PropertyName propertyName = this.filterFactory.property(request.getValueReference(), this.getNamespaceSupport());
            PropertyName propertyNameNoIndexes = this.filterFactory.property(request.getValueReference().replaceAll("\\[.*\\]", ""), this.getNamespaceSupport());
            AttributeDescriptor descriptor = (AttributeDescriptor)propertyNameNoIndexes.evaluate((Object)featureType.getFeatureType());
            boolean featureIdRequest = this.FEATURE_ID_PATTERN.matcher(request.getValueReference()).matches();
            if (descriptor == null && !featureIdRequest) {
                throw new WFSException((EObject)request, "No such attribute: " + request.getValueReference());
            }
            ValueCollectionType vc = Wfs20Factory.eINSTANCE.createValueCollectionType();
            vc.setTimeStamp(fc.getTimeStamp());
            vc.setNumberMatched(fc.getNumberMatched());
            vc.setNumberReturned(fc.getNumberReturned());
            vc.getMember().add((Object)new PropertyValueCollection((FeatureCollection)fc.getMember().iterator().next(), descriptor, propertyName));
            return vc;
        }
        catch (IOException e) {
            throw new WFSException((EObject)request, (Throwable)e);
        }
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }
}

