/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionTest
extends WFS20TestSupport {
    public static final QName WITH_GML = new QName(SystemTestData.SF_URI, "WithGMLProperties", SystemTestData.SF_PREFIX);

    @Before
    public void revert() throws Exception {
        this.revertLayer(CiteTestData.ROAD_SEGMENTS);
        ((SystemTestData)this.getTestData()).addVectorLayer(WITH_GML, Collections.emptyMap(), org.geoserver.wfs.v1_1.TransactionTest.class, this.getCatalog());
        ((SystemTestData)this.getTestData()).addVectorLayer(new QName(SystemTestData.SF_URI, "PrimitiveGeoFeatureId", SystemTestData.SF_PREFIX), Collections.emptyMap(), TestData.class, this.getCatalog());
    }

    @Test
    public void testInsert1() throws Exception {
        String xml = "<wfs:Transaction service='WFS' version='2.0.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'  xmlns:sf='http://cite.opengeospatial.org/gmlsf'><wfs:Insert handle='insert-1'> <sf:PrimitiveGeoFeature gml:id='cite.gmlsf0-f01'>  <gml:description>Fusce tellus ante, tempus nonummy, ornare sed, accumsan nec, leo.Vivamus pulvinar molestie nisl.</gml:description><gml:name>Aliquam condimentum felis sit amet est.</gml:name><sf:curveProperty>  <gml:LineString gml:id='cite.gmlsf0-g01' srsName='urn:x-fes:def:crs:EPSG:6.11.2:4326'>   <gml:posList>47.608284 19.034142 51.286873 16.7836 49.849854 15.764992</gml:posList> </gml:LineString></sf:curveProperty><sf:intProperty>1025</sf:intProperty><sf:measurand>7.405E2</sf:measurand><sf:dateTimeProperty>2006-06-23T12:43:12+01:00</sf:dateTimeProperty><sf:decimalProperty>90.62</sf:decimalProperty></sf:PrimitiveGeoFeature></wfs:Insert><wfs:Insert handle='insert-2'><sf:AggregateGeoFeature gml:id='cite.gmlsf0-f02'> <gml:description>Duis nulla nisi, molestie vel, rhoncus a, ullamcorper eu, justo. Sed bibendum. Ut sem. Mauris nec nunc a eros aliquet pharetra. Mauris nonummy, pede et tincidunt ultrices, mauris lectus fermentum massa, in ullamcorper lectusfelis vitae metus. Sed imperdiet sollicitudin dolor. </gml:description> <gml:name codeSpace='http://cite.opengeospatial.org/gmlsf'>cite.gmlsf0-f02</gml:name> <gml:name>Quisqu\u00e9 viverra</gml:name> <gml:boundedBy>   <gml:Envelope srsName='urn:x-fes:def:crs:EPSG:6.11.2:4326'>     <gml:lowerCorner>36.1 8.0</gml:lowerCorner>    <gml:upperCorner>52.0 21.1</gml:upperCorner>   </gml:Envelope>  </gml:boundedBy>   <sf:multiPointProperty><gml:MultiPoint srsName='urn:x-fes:def:crs:EPSG:6.11.2:4326'><gml:pointMember> <gml:Point><gml:pos>49.325176 21.036873</gml:pos></gml:Point></gml:pointMember><gml:pointMember>  <gml:Point><gml:pos>36.142586 13.56189</gml:pos></gml:Point></gml:pointMember><gml:pointMember>  <gml:Point><gml:pos>51.920937 8.014193</gml:pos></gml:Point></gml:pointMember></gml:MultiPoint></sf:multiPointProperty><sf:doubleProperty>2012.78</sf:doubleProperty>  <sf:intRangeProperty>43</sf:intRangeProperty> <sf:strProperty>Donec ligul\u00e4 pede, sodales i\u0144, vehicula eu, sodales et, l\u00eao.</sf:strProperty><sf:featureCode>AK121</sf:featureCode></sf:AggregateGeoFeature></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertTrue((dom.getElementsByTagName("fes:ResourceId").getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInsertWithNoSRS() throws Exception {
        String getFeature = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0'><wfs:Query typeNames=\"cgf:Points\"> <wfs:ValueReference>cite:id</wfs:ValueReference> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        int n = dom.getElementsByTagName("cgf:Points").getLength();
        String insert = "<wfs:Transaction service='WFS' version='2.0.0' xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Insert > <cgf:Points><cgf:pointProperty><gml:Point><gml:pos>20 40</gml:pos></gml:Point></cgf:pointProperty><cgf:id>t0002</cgf:id></cgf:Points></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        NodeList numberInserteds = dom.getElementsByTagName("wfs:totalInserted");
        Element numberInserted = (Element)numberInserteds.item(0);
        Assert.assertNotNull((Object)numberInserted);
        Assert.assertEquals((Object)"1", (Object)numberInserted.getFirstChild().getNodeValue());
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)(n + 1), (long)dom.getElementsByTagName("cgf:Points").getLength());
        getFeature = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0'><wfs:Query typeNames=\"cgf:Points\"> <fes:Filter><fes:PropertyIsEqualTo><fes:ValueReference>cgf:id</fes:ValueReference><fes:Literal>t0002</fes:Literal></fes:PropertyIsEqualTo></fes:Filter></wfs:Query> </wfs:GetFeature>";
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((Object)"20 40", (Object)this.getFirstElementByTagName(dom, "gml:pos").getFirstChild().getNodeValue());
    }

    @Test
    public void testInsertWithSRS() throws Exception {
        String getFeature = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cgf='http://www.opengis.net/cite/geometry'   xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'>  <wfs:Query typeNames='cgf:Points'/> </wfs:GetFeature> ";
        Document dom = this.postAsDOM("wfs", getFeature);
        int n = dom.getElementsByTagName("cgf:Points").getLength();
        String insert = "<wfs:Transaction service='WFS' version='2.0.0' xmlns:cgf='http://www.opengis.net/cite/geometry'   xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'   xmlns:gml='http://www.opengis.net/gml/3.2'>  <wfs:Insert srsName='EPSG:32615'>   <cgf:Points>    <cgf:pointProperty>     <gml:Point>      <gml:pos>1 1</gml:pos>     </gml:Point>    </cgf:pointProperty>    <cgf:id>t0003</cgf:id>   </cgf:Points>  </wfs:Insert> </wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        NodeList numberInserteds = dom.getElementsByTagName("wfs:totalInserted");
        Element numberInserted = (Element)numberInserteds.item(0);
        Assert.assertNotNull((Object)numberInserted);
        Assert.assertEquals((Object)"1", (Object)numberInserted.getFirstChild().getNodeValue());
        getFeature = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\"   xmlns:fes='http://www.opengis.net/fes/2.0'   xmlns:wfs='http://www.opengis.net/wfs/2.0'   xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Query typeNames=\"cgf:Points\"> </wfs:Query> </wfs:GetFeature>";
        dom = this.postAsDOM("wfs", getFeature);
        NodeList pointsList = dom.getElementsByTagName("cgf:Points");
        Assert.assertEquals((long)(n + 1), (long)pointsList.getLength());
    }

    @Test
    public void testInsertWithGMLProperties() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:gml='http://www.opengis.net/gml/3.2'><wfs:Insert><sf:WithGMLProperties><gml:location><gml:Point><gml:coordinates>2,2</gml:coordinates></gml:Point></gml:location><gml:name>two</gml:name><sf:foo>2</sf:foo></sf:WithGMLProperties></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Element inserted = this.getFirstElementByTagName(dom, "wfs:totalInserted");
        Assert.assertEquals((Object)"1", (Object)inserted.getFirstChild().getNodeValue());
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:WithGMLProperties");
        NodeList features = dom.getElementsByTagName("sf:WithGMLProperties");
        Assert.assertEquals((long)2L, (long)features.getLength());
        Element feature = (Element)features.item(1);
        Assert.assertEquals((Object)"two", (Object)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"2", (Object)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
        Element location = this.getFirstElementByTagName(feature, "gml:location");
        Element pos = this.getFirstElementByTagName(location, "gml:pos");
        Assert.assertEquals((Object)"2 2", (Object)pos.getFirstChild().getNodeValue());
        xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:gml='http://www.opengis.net/gml/3.2'><wfs:Insert><sf:WithGMLProperties><sf:location><gml:Point><gml:coordinates>3,3</gml:coordinates></gml:Point></sf:location><sf:name>three</sf:name><sf:foo>3</sf:foo></sf:WithGMLProperties></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=2.0.0&typename=sf:WithGMLProperties");
        features = dom.getElementsByTagName("sf:WithGMLProperties");
        Assert.assertEquals((long)3L, (long)features.getLength());
        feature = (Element)features.item(2);
        Assert.assertEquals((Object)"three", (Object)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"3", (Object)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
        location = this.getFirstElementByTagName(feature, "gml:location");
        pos = this.getFirstElementByTagName(location, "gml:pos");
        Assert.assertEquals((Object)"3 3", (Object)pos.getFirstChild().getNodeValue());
    }

    @Test
    public void testUpdateWithGMLProperties() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Update typeName=\"sf:WithGMLProperties\">   <wfs:Property>     <wfs:ValueReference>gml:name</wfs:ValueReference>     <wfs:Value>two</wfs:Value>   </wfs:Property>   <wfs:Property>     <wfs:ValueReference>gml:location</wfs:ValueReference>     <wfs:Value>        <gml:Point>          <gml:coordinates>2,2</gml:coordinates>        </gml:Point>     </wfs:Value>   </wfs:Property>   <wfs:Property>     <wfs:ValueReference>sf:foo</wfs:ValueReference>     <wfs:Value>2</wfs:Value>   </wfs:Property>   <fes:Filter>     <fes:PropertyIsEqualTo>       <fes:ValueReference>foo</fes:ValueReference>       <fes:Literal>1</fes:Literal>     </fes:PropertyIsEqualTo>   </fes:Filter> </wfs:Update></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Element updated = this.getFirstElementByTagName(dom, "wfs:totalUpdated");
        Assert.assertEquals((Object)"1", (Object)updated.getFirstChild().getNodeValue());
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=2.0.0&typename=sf:WithGMLProperties");
        NodeList features = dom.getElementsByTagName("sf:WithGMLProperties");
        Assert.assertEquals((long)1L, (long)features.getLength());
        Element feature = (Element)features.item(0);
        Assert.assertEquals((Object)"two", (Object)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"2", (Object)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
        Element location = this.getFirstElementByTagName(feature, "gml:location");
        Element pos = this.getFirstElementByTagName(location, "gml:pos");
        Assert.assertEquals((Object)"2 2", (Object)pos.getFirstChild().getNodeValue());
        xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Update typeName=\"sf:WithGMLProperties\">   <wfs:Property>     <wfs:ValueReference>sf:name</wfs:ValueReference>     <wfs:Value>trhee</wfs:Value>   </wfs:Property>   <wfs:Property>     <wfs:ValueReference>sf:location</wfs:ValueReference>     <wfs:Value>        <gml:Point>          <gml:coordinates>3,3</gml:coordinates>        </gml:Point>     </wfs:Value>   </wfs:Property>   <wfs:Property>     <wfs:ValueReference>sf:foo</wfs:ValueReference>     <wfs:Value>3</wfs:Value>   </wfs:Property>   <fes:Filter>     <fes:PropertyIsEqualTo>       <fes:ValueReference>foo</fes:ValueReference>       <fes:Literal>2</fes:Literal>     </fes:PropertyIsEqualTo>   </fes:Filter> </wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        updated = this.getFirstElementByTagName(dom, "wfs:totalUpdated");
        Assert.assertEquals((Object)"1", (Object)updated.getFirstChild().getNodeValue());
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=2.0.0&typename=sf:WithGMLProperties");
        features = dom.getElementsByTagName("sf:WithGMLProperties");
        Assert.assertEquals((long)1L, (long)features.getLength());
        feature = (Element)features.item(0);
        Assert.assertEquals((Object)"trhee", (Object)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"3", (Object)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
        location = this.getFirstElementByTagName(feature, "gml:location");
        pos = this.getFirstElementByTagName(location, "gml:pos");
        Assert.assertEquals((Object)"3 3", (Object)pos.getFirstChild().getNodeValue());
    }

    @Test
    public void testInsertWithBoundedBy() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\"  xmlns:wfs='http://www.opengis.net/wfs/2.0'  xmlns:gml='http://www.opengis.net/gml/3.2'  xmlns:cite=\"http://www.opengis.net/cite\"><wfs:Insert> <cite:BasicPolygons> <gml:boundedBy>  <gml:Envelope><gml:lowerCorner>-1.0 2.0</gml:lowerCorner><gml:upperCorner>2.0 5.0</gml:upperCorner>  </gml:Envelope> </gml:boundedBy>  <cite:the_geom>    <gml:MultiPolygon>      <gml:polygonMember>         <gml:Polygon><gml:exterior><gml:LinearRing><gml:posList>-1.0 5.0 2.0 5.0 2.0 2.0 -1.0 2.0 -1.0 5.0</gml:posList></gml:LinearRing></gml:exterior>         </gml:Polygon>      </gml:polygonMember>    </gml:MultiPolygon>  </cite:the_geom>  <cite:ID>foo</cite:ID> </cite:BasicPolygons></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1", (Object)this.getFirstElementByTagName(dom, "wfs:totalInserted").getFirstChild().getNodeValue());
        Assert.assertTrue((dom.getElementsByTagName("fes:ResourceId").getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInsert2() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\"  xmlns:wfs='http://www.opengis.net/wfs/2.0'  xmlns:gml='http://www.opengis.net/gml/3.2'  xmlns:cite=\"http://www.opengis.net/cite\"><wfs:Insert> <cite:RoadSegments>  <cite:the_geom><gml:MultiCurve srsName=\"EPSG:4326\"> <gml:curveMember>   <gml:LineString>        <gml:posList>4.2582 52.0643 4.2584 52.0648</gml:posList>   </gml:LineString> </gml:curveMember></gml:MultiCurve>  </cite:the_geom>  <cite:FID>foo</cite:FID>  <cite:NAME>bar</cite:NAME> </cite:RoadSegments></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1", (Object)this.getFirstElementByTagName(dom, "wfs:totalInserted").getFirstChild().getNodeValue());
        dom = this.getAsDOM("wfs?version=2.0.0&request=getfeature&typename=cite:RoadSegments&srsName=EPSG:4326&cql_filter=FID%3D'foo'");
        this.print(dom);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("cite:RoadSegments").getLength());
        Element roadSegment = this.getFirstElementByTagName(dom, "cite:RoadSegments");
        Element posList = this.getFirstElementByTagName(roadSegment, "gml:posList");
        String[] pos = posList.getFirstChild().getTextContent().split(" ");
        Assert.assertEquals((long)4L, (long)pos.length);
        Assert.assertEquals((double)4.2582, (double)Double.parseDouble(pos[0]), (double)1.0E-4);
        Assert.assertEquals((double)52.0643, (double)Double.parseDouble(pos[1]), (double)1.0E-4);
        Assert.assertEquals((double)4.2584, (double)Double.parseDouble(pos[2]), (double)1.0E-4);
        Assert.assertEquals((double)52.0648, (double)Double.parseDouble(pos[3]), (double)1.0E-4);
    }

    @Test
    public void testInsert3() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\"  xmlns:wfs='http://www.opengis.net/wfs/2.0'  xmlns:gml='http://www.opengis.net/gml/3.2'  xmlns:cite=\"http://www.opengis.net/cite\"><wfs:Insert> <cite:Buildings>  <cite:the_geom><gml:MultiSurface>  <gml:surfaceMember>   <gml:Polygon>    <gml:exterior>     <gml:LinearRing>      <gml:posList>-123.9 40.0 -124.0 39.9 -124.1 40.0 -124.0 40.1 -123.9 40.0</gml:posList>    </gml:LinearRing>    </gml:exterior>   </gml:Polygon>  </gml:surfaceMember> </gml:MultiSurface>   </cite:the_geom>  <cite:FID>115</cite:FID>  <cite:ADDRESS>987 Foo St</cite:ADDRESS> </cite:Buildings></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1", (Object)this.getFirstElementByTagName(dom, "wfs:totalInserted").getFirstChild().getNodeValue());
        dom = this.getAsDOM("wfs?version=2.0.0&request=getfeature&typename=cite:Buildings&srsName=EPSG:4326&cql_filter=FID%3D'115'");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("cite:Buildings").getLength());
        XMLAssert.assertXpathExists((String)"//gml:Polygon", (Document)dom);
        Element posList = this.getFirstElementByTagName(dom.getDocumentElement(), "gml:posList");
        String[] pos = posList.getFirstChild().getTextContent().split(" ");
        Assert.assertEquals((long)10L, (long)pos.length);
        Assert.assertEquals((double)-123.9, (double)Double.parseDouble(pos[0]), (double)0.1);
        Assert.assertEquals((double)40.0, (double)Double.parseDouble(pos[1]), (double)0.1);
        Assert.assertEquals((double)-124.0, (double)Double.parseDouble(pos[2]), (double)0.1);
        Assert.assertEquals((double)39.9, (double)Double.parseDouble(pos[3]), (double)0.1);
        Assert.assertEquals((double)-124.1, (double)Double.parseDouble(pos[4]), (double)0.1);
        Assert.assertEquals((double)40.0, (double)Double.parseDouble(pos[5]), (double)0.1);
        Assert.assertEquals((double)-124.0, (double)Double.parseDouble(pos[6]), (double)0.1);
        Assert.assertEquals((double)40.1, (double)Double.parseDouble(pos[7]), (double)0.1);
        Assert.assertEquals((double)-123.9, (double)Double.parseDouble(pos[8]), (double)0.1);
        Assert.assertEquals((double)40.0, (double)Double.parseDouble(pos[9]), (double)0.1);
    }

    @Test
    public void testUpdateForcedSRS() throws Exception {
        this.testUpdate("srsName=\"EPSG:4326\"");
    }

    @Test
    public void testUpdateNoSRS() throws Exception {
        this.testUpdate("");
    }

    private void testUpdate(String srs) throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Update typeName=\"cite:RoadSegments\">   <wfs:Property>     <wfs:ValueReference>cite:the_geom</wfs:ValueReference>     <wfs:Value>      <gml:MultiCurve " + srs + ">       <gml:curveMember>         <gml:LineString>            <gml:posList>4.2582 52.0643 4.2584 52.0648</gml:posList>         </gml:LineString>       </gml:curveMember>      </gml:MultiCurve>     </wfs:Value>   </wfs:Property>   <fes:Filter>     <fes:PropertyIsEqualTo>       <fes:ValueReference>FID</fes:ValueReference>       <fes:Literal>102</fes:Literal>     </fes:PropertyIsEqualTo>   </fes:Filter> </wfs:Update></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1", (Object)this.getFirstElementByTagName(dom, "wfs:totalUpdated").getFirstChild().getNodeValue());
        String srsBlock = "".equals(srs) ? "" : "&" + srs.replaceAll("\"", "");
        dom = this.getAsDOM("wfs?version=2.0.0&request=getfeature&typename=cite:RoadSegments" + srsBlock + "&cql_filter=FID%3D'102'");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("cite:RoadSegments").getLength());
        Element roadSegment = this.getFirstElementByTagName(dom, "cite:RoadSegments");
        Element posList = this.getFirstElementByTagName(roadSegment, "gml:posList");
        String[] pos = posList.getFirstChild().getTextContent().split(" ");
        Assert.assertEquals((long)4L, (long)pos.length);
        Assert.assertEquals((double)4.2582, (double)Double.parseDouble(pos[0]), (double)1.0E-4);
        Assert.assertEquals((double)52.0643, (double)Double.parseDouble(pos[1]), (double)1.0E-4);
        Assert.assertEquals((double)4.2584, (double)Double.parseDouble(pos[2]), (double)1.0E-4);
        Assert.assertEquals((double)52.0648, (double)Double.parseDouble(pos[3]), (double)1.0E-4);
    }

    @Test
    public void testUpdateWithInvalidProperty() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:fes='http://www.opengis.net/fes/2.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'  xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Update typeName=\"cite:RoadSegments\">   <wfs:Property>     <wfs:ValueReference>INVALID</wfs:ValueReference>     <wfs:Value>INVALID</wfs:Value>   </wfs:Property>   <fes:Filter>     <fes:PropertyIsEqualTo>       <fes:ValueReference>FID</fes:ValueReference>       <fes:Literal>102</fes:Literal>     </fes:PropertyIsEqualTo>   </fes:Filter> </wfs:Update></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testInsertLayerQualified() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\"  xmlns:fes='http://www.opengis.net/fes/2.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'  xmlns:gml='http://www.opengis.net/gml/3.2'  xmlns:cite=\"http://www.opengis.net/cite\"><wfs:Insert> <cite:RoadSegments>  <cite:the_geom><gml:MultiCurve xmlns:gml=\"http://www.opengis.net/gml\"    srsName=\"EPSG:4326\"> <gml:curveMember>                  <gml:LineString>                   <gml:posList>4.2582 52.0643 4.2584 52.0648</gml:posList>                 </gml:LineString>               </gml:curveMember>             </gml:MultiCurve>  </cite:the_geom>  <cite:FID>foo</cite:FID>  <cite:NAME>bar</cite:NAME> </cite:RoadSegments></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("cite/Forests/wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        dom = this.postAsDOM("cite/RoadSegments/wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1", (Object)this.getFirstElementByTagName(dom, "wfs:totalInserted").getFirstChild().getNodeValue());
    }

    @Test
    public void testUpdateLayerQualified() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:fes='http://www.opengis.net/fes/2.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'  xmlns:gml='http://www.opengis.net/gml/3.2'  xmlns:cite=\"http://www.opengis.net/cite\"> <wfs:Update typeName=\"RoadSegments\">   <wfs:Property>     <wfs:ValueReference>cite:the_geom</wfs:ValueReference>     <wfs:Value>      <gml:MultiCurve>       <gml:curveMember>         <gml:LineString>            <gml:posList>4.2582 52.0643 4.2584 52.0648</gml:posList>         </gml:LineString>       </gml:curveMember>      </gml:MultiCurve>     </wfs:Value>   </wfs:Property>   <fes:Filter>     <fes:PropertyIsEqualTo>       <fes:ValueReference>FID</fes:ValueReference>       <fes:Literal>102</fes:Literal>     </fes:PropertyIsEqualTo>   </fes:Filter> </wfs:Update></wfs:Transaction>";
        Document dom = this.postAsDOM("cite/Forests/wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        dom = this.postAsDOM("cite/RoadSegments/wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1", (Object)this.getFirstElementByTagName(dom, "wfs:totalUpdated").getFirstChild().getNodeValue());
    }

    @Test
    public void testUpdateWithDifferentPrefix() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:fes='http://www.opengis.net/fes/2.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'  xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Update xmlns:foo=\"http://www.opengis.net/cite\" typeName=\"foo:RoadSegments\">   <wfs:Property>     <wfs:ValueReference>foo:the_geom</wfs:ValueReference>     <wfs:Value>     </wfs:Value>   </wfs:Property>   <fes:Filter>     <fes:PropertyIsEqualTo>       <fes:ValueReference>FID</fes:ValueReference>       <fes:Literal>102</fes:Literal>     </fes:PropertyIsEqualTo>   </fes:Filter> </wfs:Update></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Element updated = this.getFirstElementByTagName(dom, "wfs:totalUpdated");
        Assert.assertEquals((Object)"1", (Object)updated.getFirstChild().getNodeValue());
    }

    @Test
    public void testReplace() throws Exception {
        Document dom = this.getAsDOM("wfs?service=wfs&version=2.0.0&request=getfeature&typename=cite:RoadSegments&cql_filter=FID+EQ+'102'");
        XMLAssert.assertXpathExists((String)"//cite:RoadSegments/cite:FID[text() = '102']", (Document)dom);
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:fes='http://www.opengis.net/fes/2.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'  xmlns:gml='http://www.opengis.net/gml/3.2'  xmlns:cite='http://www.opengis.net/cite'> <wfs:Replace>  <cite:RoadSegments gml:id='RoadSegments.1107532045088'>       <cite:the_geom>          <gml:MultiCurve srsDimension='2' srsName='urn:x-ogc:def:crs:EPSG:4326'>           <gml:curveMember>             <gml:LineString>               <gml:posList>1 2 3 5 6 7</gml:posList>             </gml:LineString>           </gml:curveMember>         </gml:MultiCurve>       </cite:the_geom>       <cite:FID>1234</cite:FID>       <cite:NAME>Route 1234</cite:NAME>    </cite:RoadSegments>    <fes:Filter>     <fes:PropertyIsEqualTo>       <fes:ValueReference>FID</fes:ValueReference>       <fes:Literal>102</fes:Literal>     </fes:PropertyIsEqualTo>   </fes:Filter> </wfs:Replace></wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"//wfs:totalReplaced[text() = 1]", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:ReplaceResults/wfs:Feature/fes:ResourceId", (Document)dom);
        dom = this.getAsDOM("wfs?service=wfs&version=2.0.0&request=getfeature&typename=cite:RoadSegments&cql_filter=FID+EQ+'102'");
        XMLAssert.assertXpathNotExists((String)"//cite:RoadSegments/cite:FID[text() = '102']", (Document)dom);
        dom = this.getAsDOM("wfs?service=wfs&version=2.0.0&request=getfeature&typename=cite:RoadSegments&cql_filter=FID+EQ+'1234'");
        XMLAssert.assertXpathExists((String)"//cite:RoadSegments/cite:FID[text() = '1234']", (Document)dom);
    }

    @Test
    public void testReplaceOnTransactionalLevel() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setServiceLevel(WFSInfo.ServiceLevel.TRANSACTIONAL);
        gs.save((ServiceInfo)wfs);
        try {
            this.testReplace();
        }
        finally {
            wfs.setServiceLevel(WFSInfo.ServiceLevel.COMPLETE);
            gs.save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testSOAP() throws Exception {
        String xml = "<soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><wfs:Transaction service='WFS' version='2.0.0' xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Insert > <cgf:Points><cgf:pointProperty><gml:Point><gml:pos>20 40</gml:pos></gml:Point></cgf:pointProperty><cgf:id>t0002</cgf:id></cgf:Points></wfs:Insert></wfs:Transaction> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(resp.getContentAsString().getBytes()));
        Assert.assertEquals((Object)"soap:Envelope", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:TransactionResponse").getLength());
    }

    @Test
    public void elementHandlerOrder() throws Exception {
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName("foo");
        ds.setWorkspace(cat.getDefaultWorkspace());
        ds.setEnabled(true);
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        params.put("database", ((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath());
        cat.add((StoreInfo)ds);
        DataStore store = (DataStore)ds.getDataStore(null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("bar");
        tb.add("name", String.class);
        tb.add("geom", Point.class);
        store.createSchema((FeatureType)tb.buildFeatureType());
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        SimpleFeatureStore fs = (SimpleFeatureStore)store.getFeatureSource("bar");
        FeatureTypeInfo ft = cb.buildFeatureType((FeatureSource)fs);
        cat.add((ResourceInfo)ft);
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:fes='http://www.opengis.net/fes/2.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'  xmlns:gml='http://www.opengis.net/gml/3.2'  xmlns:cite='http://www.opengis.net/cite' xmlns:gs='" + SystemTestData.DEFAULT_URI + "'><wfs:Insert idgen='UseExisting'> <gs:bar gml:id='1'>    <gs:name>acme</gs:name> </gs:bar> <gs:bar gml:id='2'>    <gs:name>wiley</gs:name> </gs:bar> <gs:bar gml:id='3'>    <gs:name>bugs</gs:name> </gs:bar> <gs:bar gml:id='4'>    <gs:name>roadrunner</gs:name> </gs:bar> <gs:bar gml:id='5'>    <gs:name>daffy</gs:name> </gs:bar> <gs:bar gml:id='6'>    <gs:name>elmer</gs:name> </gs:bar> <gs:bar gml:id='7'>    <gs:name>tweety</gs:name> </gs:bar> <gs:bar gml:id='8'>    <gs:name>sylvester</gs:name> </gs:bar> <gs:bar gml:id='9'>    <gs:name>marvin</gs:name> </gs:bar> <gs:bar gml:id='10'>    <gs:name>yosemite</gs:name> </gs:bar> <gs:bar gml:id='11'>    <gs:name>porky</gs:name> </gs:bar> <gs:bar gml:id='12'>    <gs:name>speedy</gs:name> </gs:bar> <gs:bar gml:id='13'>    <gs:name>taz</gs:name> </gs:bar></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        dom = this.getAsDOM("wfs?request=GetFeature&service=wfs&version=2.0.0&typeNames=gs:bar");
        NodeList elementsByTagName = dom.getElementsByTagName("gs:bar");
        for (int i = 1; i <= elementsByTagName.getLength(); ++i) {
            String id = elementsByTagName.item(i - 1).getAttributes().item(0).getNodeValue();
            Assert.assertEquals((Object)("bar." + i), (Object)id);
        }
        dom = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&service=wfs&typeNames=gs:bar&featureId=bar.5");
        XMLAssert.assertXpathEvaluatesTo((String)"daffy", (String)"//gml:name/text()", (Document)dom);
    }

    @Test
    public void testInsertUnknownFeatureType() throws Exception {
        this.testInsertUnkonwnFeatureType("wfs");
    }

    @Test
    public void testInsertUnknownFeatureTypeWorkspaceSpecific() throws Exception {
        this.testInsertUnkonwnFeatureType("cgf/wfs");
    }

    protected void testInsertUnkonwnFeatureType(String path) throws Exception {
        String insert = "<wfs:Transaction service='WFS' version='2.0.0' xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Insert > <cgf:FooBar><cgf:pointProperty><gml:Point><gml:pos>20 40</gml:pos></gml:Point></cgf:pointProperty><cgf:id>t0002</cgf:id></cgf:FooBar></wfs:Insert></wfs:Transaction>";
        MockHttpServletResponse response = this.postAsServletResponse(path, insert);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        this.checkOws11Exception(dom, "2.0.0", "InvalidValue", "Transaction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateBoundedByWithKML() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setCiteCompliant(true);
        gs.save((ServiceInfo)wfs);
        try {
            String xml = "<wfs:Transaction xmlns:wfs=\"http://www.opengis.net/wfs/2.0\"\n                 xmlns:gml=\"http://www.opengis.net/gml/3.2\"\n                 service=\"WFS\"\n                 version=\"2.0.0\">\n  <wfs:Update xmlns:ns17=\"http://cite.opengeospatial.org/gmlsf\"\n               typeName=\"ns17:AggregateGeoFeature\">\n      <wfs:Property>\n         <wfs:ValueReference action=\"replace\">gml:boundedBy</wfs:ValueReference>\n         <wfs:Value>\n            <Point xmlns=\"http://www.opengis.net/kml/2.2\">\n               <coordinates>-123.1,49.25</coordinates>\n            </Point>\n         </wfs:Value>\n      </wfs:Property>\n  </wfs:Update>\n</wfs:Transaction>";
            MockHttpServletResponse response = this.postAsServletResponse("wfs", xml);
            Assert.assertEquals((long)400L, (long)response.getStatus());
            Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
            this.checkOws11Exception(dom, "2.0.0", "InvalidValue", "boundedBy");
        }
        finally {
            wfs.setCiteCompliant(false);
            gs.save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testUpdateOnSimpleXPath() throws Exception {
        String xml = "<wfs:Transaction xmlns:wfs=\"http://www.opengis.net/wfs/2.0\"\n                 xmlns:gml=\"http://www.opengis.net/gml/3.2\"\n                 xmlns:tns=\"http://cite.opengeospatial.org/gmlsf\"\n                 service=\"WFS\"\n                 version=\"2.0.0\">\n   <wfs:Update handle=\"Update\" typeName=\"tns:GenericEntity\">\n      <wfs:Property>\n         <wfs:ValueReference>tns:featureRef[1]</wfs:ValueReference>\n         <wfs:Value>TEST_VALUE</wfs:Value>\n      </wfs:Property>\n      <fes:Filter xmlns:fes=\"http://www.opengis.net/fes/2.0\">\n         <fes:ResourceId rid=\"GenericEntity.f004\"/>\n      </fes:Filter>\n   </wfs:Update>\n</wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"//wfs:totalUpdated[text() = 1]", (Document)dom);
        dom = this.getAsDOM("wfs?service=wfs&version=2.0.0&request=getfeature&typename=sf:GenericEntity&resourceId=GenericEntity.f004");
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//sf:GenericEntity)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"TEST_VALUE", (String)"//sf:featureRef", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertPreserveId() throws Exception {
        WFSInfo wfs = this.getWFS();
        GMLInfo gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_20);
        gml.setOverrideGMLAttributes(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wfs);
        this.getGeoServer().reset();
        try {
            String xml = "<wfs:Transaction service='WFS' version='2.0.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'  xmlns:sf='http://cite.opengeospatial.org/gmlsf'><wfs:Insert handle='insert-1'> <sf:PrimitiveGeoFeatureId gml:id='PrimitiveGeoFeatureId.gmlsf0-f01'>  <gml:description>Fusce tellus ante, tempus nonummy, ornare sed, accumsan nec, leo.Vivamus pulvinar molestie nisl.</gml:description><gml:name>Aliquam condimentum felis sit amet est.</gml:name><gml:identifier codeSpace=\"fooBar\">PrimitiveGeoFeatureId.gmlsf0-f01</gml:identifier><sf:curveProperty>  <gml:LineString gml:id='cite.gmlsf0-g01' srsName='urn:x-fes:def:crs:EPSG:6.11.2:4326'>   <gml:posList>47.608284 19.034142 51.286873 16.7836 49.849854 15.764992</gml:posList> </gml:LineString></sf:curveProperty><sf:intProperty>1025</sf:intProperty><sf:measurand>7.405E2</sf:measurand><sf:dateTimeProperty>2006-06-23T12:43:12+01:00</sf:dateTimeProperty><sf:decimalProperty>90.62</sf:decimalProperty></sf:PrimitiveGeoFeatureId></wfs:Insert></wfs:Transaction>";
            Document dom = this.postAsDOM("wfs", xml, 200);
            Assert.assertEquals((Object)"wfs:TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
            XMLAssert.assertXpathExists((String)"//wfs:totalInserted[text() = 1]", (Document)dom);
            dom = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&storedQueryId=" + StoredQuery.DEFAULT.getName() + "&ID=PrimitiveGeoFeatureId.gmlsf0-f01", 200);
        }
        finally {
            gml.setOverrideGMLAttributes(Boolean.valueOf(true));
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntityExpansionLimitOnTransaction() throws Exception {
        try {
            System.getProperties().setProperty("org.geoserver.wfs.xml.entityExpansionLimit", "1");
            Document dom = this.postAsDOM("wfs", this.xmlEntityExpansionLimitBody());
            NodeList serviceExceptionList = dom.getElementsByTagName("ows:ExceptionText");
            Assert.assertEquals((long)1L, (long)serviceExceptionList.getLength());
            Node serviceException = serviceExceptionList.item(0);
            String textContent = serviceException.getTextContent();
            MatcherAssert.assertThat((Object)textContent, (Matcher)CoreMatchers.containsString((String)"JAXP00010001"));
        }
        finally {
            System.getProperties().remove("org.geoserver.wfs.xml.entityExpansionLimit");
        }
    }

    private String xmlEntityExpansionLimitBody() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?><!DOCTYPE convert [ <!ENTITY lol \"lol\"><!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;\"> ]><wfs:Transaction service='WFS' version='2.0.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'  xmlns:sf='http://cite.opengeospatial.org/gmlsf'><wfs:Insert handle='insert-1'> <sf:PrimitiveGeoFeatureId gml:id='PrimitiveGeoFeatureId.gmlsf0-f01'>  <gml:description>Fusce tellus ante, tempus nonummy, ornare sed, accumsan nec, leo.Vivamus pulvinar molestie nisl.</gml:description><gml:name>Aliquam condimentum felis sit amet est.</gml:name><gml:identifier codeSpace=\"fooBar\">PrimitiveGeoFeatureId.gmlsf0-f01</gml:identifier><sf:curveProperty>  <gml:LineString gml:id='cite.gmlsf0-g01' srsName='urn:x-fes:def:crs:EPSG:6.11.2:4326'>   <gml:posList>&lol1;</gml:posList> </gml:LineString></sf:curveProperty><sf:intProperty>1025</sf:intProperty><sf:measurand>7.405E2</sf:measurand><sf:dateTimeProperty>2006-06-23T12:43:12+01:00</sf:dateTimeProperty><sf:decimalProperty>90.62</sf:decimalProperty></sf:PrimitiveGeoFeatureId></wfs:Insert></wfs:Transaction>";
    }
}

