/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import net.opengis.wfs.DescribeFeatureTypeType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.util.ReaderUtils;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.xml.v1_1_0.XmlSchemaEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DescribeFeatureResponseTest
extends WFSTestSupport {
    Operation request() {
        Service service = this.getServiceDescriptor10();
        DescribeFeatureTypeType type = WfsFactory.eINSTANCE.createDescribeFeatureTypeType();
        type.setBaseUrl("http://localhost:8080/geoserver");
        Operation request = new Operation("wfs", service, null, new Object[]{type});
        return request;
    }

    @Test
    public void testSingle() throws Exception {
        FeatureTypeInfo meta = this.getFeatureTypeInfo(CiteTestData.BASIC_POLYGONS);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XmlSchemaEncoder.V11 response = new XmlSchemaEncoder.V11(this.getGeoServer());
        response.write((Object)new FeatureTypeInfo[]{meta}, (OutputStream)output, this.request());
        Element schema = ReaderUtils.parse((Reader)new StringReader(new String(output.toByteArray())));
        Assert.assertEquals((Object)"xsd:schema", (Object)schema.getNodeName());
        NodeList types = schema.getElementsByTagName("xsd:complexType");
        Assert.assertEquals((long)1L, (long)types.getLength());
    }

    @Test
    public void testWithDifferntNamespaces() throws Exception {
        FeatureTypeInfo meta1 = this.getFeatureTypeInfo(CiteTestData.BASIC_POLYGONS);
        FeatureTypeInfo meta2 = this.getFeatureTypeInfo(CiteTestData.POLYGONS);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XmlSchemaEncoder.V11 response = new XmlSchemaEncoder.V11(this.getGeoServer());
        response.write((Object)new FeatureTypeInfo[]{meta1, meta2}, (OutputStream)output, this.request());
        Element schema = ReaderUtils.parse((Reader)new StringReader(new String(output.toByteArray())));
        Assert.assertEquals((Object)"xsd:schema", (Object)schema.getNodeName());
        NodeList imprts = schema.getElementsByTagName("xsd:import");
        Assert.assertEquals((long)2L, (long)imprts.getLength());
    }
}

