/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.WfsFactory;
import org.easymock.EasyMock;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.response.CSVOutputFormat;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeImpl;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.wfs.internal.WFSContentComplexFeatureCollection;
import org.geotools.feature.FakeTypes;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.DateUtil;
import org.geotools.feature.type.FeatureTypeImpl;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.springframework.mock.web.MockHttpServletResponse;

public class CSVOutputFormatTest
extends WFSTestSupport {
    private static final String CSV = "text/csv";

    @Test
    public void testWithAttributesRemoved() throws Exception {
        String layerId = this.getLayerId(CiteTestData.ROAD_SEGMENTS);
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(layerId);
        fti.getAttributes().addAll(fti.attributes());
        fti.getAttributes().remove(1);
        this.getCatalog().save((ResourceInfo)fti);
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setFeatureBounding(false);
        gs.save((ServiceInfo)wfs);
        MockHttpServletResponse response = this.getAsServletResponse("ows?service=WFS&version=1.0.0&request=GetFeature&typeName=cite:RoadSegments&maxFeatures=50&outputFormat=text%2Fcsv&propertyname=NAME");
        Assert.assertEquals((Object)"attachment; filename=RoadSegments.csv", (Object)response.getHeader("Content-Disposition"));
        Assert.assertEquals((Object)CSV, (Object)this.getBaseMimeType(response.getContentType()));
        BufferedReader content = new BufferedReader(new StringReader(new String(response.getContentAsByteArray())));
        Assert.assertEquals((Object)"FID,NAME", (Object)content.readLine().strip().replace(" ", ""));
    }

    @Test
    public void testFullRequest() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?version=1.1.0&request=GetFeature&typeName=sf:PrimitiveGeoFeature&outputFormat=csv", StandardCharsets.UTF_8.name());
        SimpleFeatureSource fs = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        Assert.assertEquals((Object)CSV, (Object)this.getBaseMimeType(resp.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)resp.getCharacterEncoding());
        Assert.assertEquals((Object)"attachment; filename=PrimitiveGeoFeature.csv", (Object)resp.getHeader("Content-Disposition"));
        List<String[]> lines = this.readLines(resp.getContentAsString(), Character.valueOf(','));
        Assert.assertEquals((long)(fs.getCount(Query.ALL) + 1), (long)lines.size());
        for (String[] line : lines) {
            Assert.assertEquals((long)(fs.getSchema().getDescriptors().size() + 1), (long)line.length);
        }
    }

    @Test
    public void testHTMLStuff() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?version=1.1.0&request=GetFeature&typeName=sf:PrimitiveGeoFeature&outputFormat=csv&format_options=filename:test", StandardCharsets.UTF_8.name());
        Assert.assertEquals((Object)CSV, (Object)this.getBaseMimeType(resp.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)resp.getCharacterEncoding());
        Assert.assertEquals((Object)"attachment; filename=test.csv", (Object)resp.getHeader("Content-Disposition"));
    }

    @Test
    public void testEscapes() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("geom", Point.class);
        builder.add("label", String.class);
        builder.add("dtg", Date.class);
        builder.add("n", Integer.class);
        builder.add("d", Double.class);
        builder.setName("funnyLabels");
        SimpleFeatureType type = builder.buildFeatureType();
        Date d = new SimpleDateFormat("yyyy-MM-dd").parse("2016-01-01");
        GeometryFactory gf = new GeometryFactory();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 8.0)), "A label with \"quotes\"", d, 10, 100.0}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 4.0)), "A long label\nwith newlines", d, 10, 200.0}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 4.0)), "A long label\r\nwith windows\r\nnewlines", d, 10, 300.0}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f1);
        data.addFeature(f2);
        data.addFeature(f3);
        ContentFeatureSource fs = data.getFeatureSource("funnyLabels");
        GetFeatureType gft = WfsFactory.eINSTANCE.createGetFeatureType();
        Operation op = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{gft});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(fs.getFeatures());
        CSVOutputFormat format = new CSVOutputFormat(this.getGeoServer());
        format.write(fct, (OutputStream)bos, op);
        List<String[]> lines = this.readLines(bos.toString(), Character.valueOf(','));
        Assert.assertEquals((long)(fs.getCount(Query.ALL) + 1), (long)lines.size());
        for (String[] line : lines) {
            Assert.assertEquals((long)(((SimpleFeatureType)fs.getSchema()).getAttributeCount() + 1), (long)line.length);
        }
        Assert.assertEquals((Object)f1.getAttribute("label"), (Object)lines.get(1)[2]);
        Assert.assertEquals((Object)f2.getAttribute("label"), (Object)lines.get(2)[2]);
        Assert.assertEquals((Object)((String)f3.getAttribute("label")).replace("\r\n", "\n"), (Object)lines.get(3)[2]);
        Assert.assertEquals((Object)DateUtil.serializeDateTime((Date)((Date)f1.getAttribute("dtg"))), (Object)lines.get(1)[3]);
        Assert.assertEquals((Object)f1.getAttribute("n"), (Object)Integer.parseInt(lines.get(1)[4]));
        Assert.assertEquals((Object)f2.getAttribute("d"), (Object)Double.parseDouble(lines.get(2)[5]));
    }

    private List<String[]> readLines(String csvContent, Character separator) throws IOException {
        String[] nextLine;
        CSVReader reader = new CSVReader((Reader)new StringReader(csvContent), separator.charValue());
        ArrayList<String[]> result = new ArrayList<String[]>();
        while ((nextLine = reader.readNext()) != null) {
            result.add(nextLine);
        }
        return result;
    }

    @Test
    public void testFullRequestWithDynamicCsvSeparator() throws Exception {
        Character separator = Character.valueOf('-');
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?version=1.1.0&request=GetFeature&typeName=sf:PrimitiveGeoFeature&outputFormat=csv&format_options=csvSeparator:" + separator, StandardCharsets.UTF_8.name());
        SimpleFeatureSource fs = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        Assert.assertEquals((Object)CSV, (Object)this.getBaseMimeType(resp.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)resp.getCharacterEncoding());
        Assert.assertEquals((Object)"attachment; filename=PrimitiveGeoFeature.csv", (Object)resp.getHeader("Content-Disposition"));
        List<String[]> lines = this.readLines(resp.getContentAsString(), separator);
        Assert.assertEquals((long)(fs.getCount(Query.ALL) + 1), (long)lines.size());
        for (String[] line : lines) {
            Assert.assertEquals((long)(fs.getSchema().getDescriptors().size() + 1), (long)line.length);
        }
    }

    @Test
    public void testDoubleQuotesAsCsvSeparator() throws Exception {
        GetFeatureType gft = WfsFactory.eINSTANCE.createGetFeatureType();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CSVSEPARATOR", "\"");
        gft.setFormatOptions(hashMap);
        Operation op = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{gft});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        SimpleFeatureSource fs = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        fct.getFeature().add(fs.getFeatures());
        CSVOutputFormat format = new CSVOutputFormat(this.getGeoServer());
        InvalidParameterException invalidParameterException = (InvalidParameterException)Assert.assertThrows(InvalidParameterException.class, () -> format.write(fct, (OutputStream)bos, op));
        Assert.assertEquals((Object)"A double quote is not allowed as a CSV separator", (Object)invalidParameterException.getMessage());
    }

    @Test
    public void testSemicolonAsCsvSeparator() throws Exception {
        String separator = "semicolon";
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?version=1.1.0&request=GetFeature&typeName=sf:PrimitiveGeoFeature&outputFormat=csv&format_options=csvSeparator:" + separator, StandardCharsets.UTF_8.name());
        SimpleFeatureSource fs = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        Assert.assertEquals((Object)CSV, (Object)this.getBaseMimeType(resp.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)resp.getCharacterEncoding());
        Assert.assertEquals((Object)"attachment; filename=PrimitiveGeoFeature.csv", (Object)resp.getHeader("Content-Disposition"));
        List<String[]> lines = this.readLines(resp.getContentAsString(), Character.valueOf(';'));
        Assert.assertEquals((long)(fs.getCount(Query.ALL) + 1), (long)lines.size());
        for (String[] line : lines) {
            Assert.assertEquals((long)(fs.getSchema().getDescriptors().size() + 1), (long)line.length);
        }
    }

    @Test
    public void testResolvePrefixedAttributeNames() {
        NamespaceInfoImpl nsInfo = new NamespaceInfoImpl();
        nsInfo.setPrefix("test-ns");
        nsInfo.setURI("http://test-ns/core");
        this.getGeoServer().getCatalog().add((NamespaceInfo)nsInfo);
        CSVOutputFormat csvFormat = new CSVOutputFormat(this.getGeoServer());
        Assert.assertEquals((Object)"test-ns:attributeName", (Object)csvFormat.resolveNamespacePrefixName("http://test-ns/core:attributeName"));
    }

    @Test
    public void testDontResolvePrefixedAttributeNames() {
        NamespaceInfoImpl nsInfo = new NamespaceInfoImpl();
        nsInfo.setPrefix("test-ns2");
        nsInfo.setURI("http://test-ns2/core");
        this.getGeoServer().getCatalog().add((NamespaceInfo)nsInfo);
        CSVOutputFormat csvFormat = new CSVOutputFormat(this.getGeoServer());
        Assert.assertEquals((Object)"test-ns2:attributeName", (Object)csvFormat.resolveNamespacePrefixName("test-ns2:attributeName"));
    }

    @Test
    public void testUnvalidResolvePrefixedAttributeNames() {
        CSVOutputFormat csvFormat = new CSVOutputFormat(this.getGeoServer());
        Assert.assertEquals((Object)"test:attributeName:", (Object)csvFormat.resolveNamespacePrefixName("test:attributeName:"));
    }

    @Test
    public void testComplexFeatureMultiValuedAttributes() throws IOException {
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        ComplexFeatureTypeImpl schema = (ComplexFeatureTypeImpl)EasyMock.createNiceMock(ComplexFeatureTypeImpl.class);
        EasyMock.expect((Object)schema.getName()).andReturn((Object)new NameImpl("testComplexFt"));
        ArrayList<AttributeDescriptorImpl> descriptors = new ArrayList<AttributeDescriptorImpl>();
        FeatureTypeImpl MINENAMETYPE_TYPE = new FeatureTypeImpl(FakeTypes.Mine.NAME_MineNameType, (Collection)FakeTypes.Mine.MINENAMETYPE_SCHEMA, null, false, Collections.emptyList(), FakeTypes.ANYTYPE_TYPE, null);
        NameImpl name = new NameImpl("items");
        AttributeDescriptorImpl propertyDescriptor = new AttributeDescriptorImpl((AttributeType)MINENAMETYPE_TYPE, (Name)name, 1, 1, false, null);
        descriptors.add(propertyDescriptor);
        EasyMock.expect((Object)schema.getDescriptors()).andReturn(descriptors).anyTimes();
        EasyMock.replay((Object[])new Object[]{schema});
        Feature feature = (Feature)EasyMock.createNiceMock(Feature.class);
        FeatureId featureId = (FeatureId)EasyMock.createNiceMock(FeatureId.class);
        EasyMock.expect((Object)featureId.getID()).andReturn((Object)"testId").anyTimes();
        EasyMock.replay((Object[])new Object[]{featureId});
        EasyMock.expect((Object)feature.getIdentifier()).andReturn((Object)featureId);
        ArrayList<Property> values = new ArrayList<Property>();
        Property property1 = (Property)EasyMock.createNiceMock(Property.class);
        EasyMock.expect((Object)property1.getValue()).andReturn((Object)"prop1").anyTimes();
        values.add(property1);
        Property property2 = (Property)EasyMock.createNiceMock(Property.class);
        EasyMock.expect((Object)property2.getValue()).andReturn((Object)"prop2").anyTimes();
        values.add(property2);
        EasyMock.replay((Object[])new Object[]{property1, property2});
        EasyMock.expect((Object)feature.getProperties((Name)name)).andReturn(values).anyTimes();
        EasyMock.replay((Object[])new Object[]{feature});
        FeatureCollection featureCollection = (FeatureCollection)EasyMock.createNiceMock(WFSContentComplexFeatureCollection.class);
        try (FeatureIterator i = (FeatureIterator)EasyMock.createNiceMock(FeatureIterator.class);){
            EasyMock.expect((Object)i.hasNext()).andReturn((Object)true).times(1);
            EasyMock.expect((Object)i.next()).andReturn((Object)feature).anyTimes();
            EasyMock.replay((Object[])new Object[]{i});
            EasyMock.expect((Object)featureCollection.getSchema()).andReturn((Object)schema).anyTimes();
            EasyMock.expect((Object)featureCollection.features()).andReturn((Object)i).anyTimes();
            EasyMock.replay((Object[])new Object[]{featureCollection});
        }
        fct.getFeature().add(featureCollection);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GetFeatureType gft = WfsFactory.eINSTANCE.createGetFeatureType();
        Operation op = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{gft});
        CSVOutputFormat format = new CSVOutputFormat(this.getGeoServer());
        format.write(fct, (OutputStream)bos, op);
        String csvResponse = bos.toString();
        List<String[]> lines = this.readLines(csvResponse, Character.valueOf(','));
        Assert.assertEquals((long)2L, (long)lines.get(0).length);
        Assert.assertEquals((long)2L, (long)lines.size());
        Assert.assertEquals((Object)"testId", (Object)lines.get(1)[0]);
        Assert.assertEquals((Object)"prop1,prop2", (Object)lines.get(1)[1]);
    }

    @Test
    public void testIAULayer() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?version=1.1.0&request=GetFeature&typeName=iau:MarsPoi&outputFormat=csv", StandardCharsets.UTF_8.name());
        SimpleFeatureSource fs = this.getFeatureSource(SystemTestData.MARS_POI);
        Assert.assertEquals((Object)CSV, (Object)this.getBaseMimeType(resp.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)resp.getCharacterEncoding());
        Assert.assertEquals((Object)"attachment; filename=MarsPoi.csv", (Object)resp.getHeader("Content-Disposition"));
        List<String[]> lines = this.readLines(resp.getContentAsString(), Character.valueOf(','));
        Assert.assertEquals((long)(fs.getCount(Query.ALL) + 1), (long)lines.size());
        for (String[] line : lines) {
            Assert.assertEquals((long)(fs.getSchema().getDescriptors().size() + 1), (long)line.length);
        }
    }

    @Test
    public void testDates() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("geom", Point.class);
        builder.add("label", String.class);
        builder.add("dtg", Date.class);
        builder.add("n", Integer.class);
        builder.add("d", Double.class);
        builder.setName("funnyLabels");
        SimpleFeatureType type = builder.buildFeatureType();
        Locale currentLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en", "US"));
        Date d = new Date(1483228800000L);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 8.0)), "A label with \"quotes\"", d, 10, 100.0}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f);
        ContentFeatureSource fs = data.getFeatureSource("funnyLabels");
        GetFeatureType gft = WfsFactory.eINSTANCE.createGetFeatureType();
        Operation op = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{gft});
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(fs.getFeatures());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CSVOutputFormat format = this.setCSVDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        format.write(fct, (OutputStream)bos, op);
        this.assertDates("2017-01-01T00:00:00.000Z", bos);
        ByteArrayOutputStream bos1 = new ByteArrayOutputStream();
        CSVOutputFormat format1 = this.setCSVDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        format1.write(fct, (OutputStream)bos1, op);
        this.assertDates("2017-01-01T00:00:00.000", bos1);
        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
        CSVOutputFormat format2 = this.setCSVDateFormat("EEE, MMM d, ''yy");
        format2.write(fct, (OutputStream)bos2, op);
        this.assertDates("Sun, Jan 1, '17", bos2);
        ByteArrayOutputStream bos3 = new ByteArrayOutputStream();
        CSVOutputFormat format3 = this.setCSVDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        format3.write(fct, (OutputStream)bos3, op);
        this.assertDates("Sun, 1 Jan 2017 00:00:00 +0000", bos3);
        Locale.setDefault(currentLocale);
    }

    private CSVOutputFormat setCSVDateFormat(String csvDateFormat) {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfsInfo = (WFSInfo)gs.getService(WFSInfo.class);
        wfsInfo.setCsvDateFormat(csvDateFormat);
        gs.save((ServiceInfo)wfsInfo);
        return new CSVOutputFormat(gs);
    }

    private void assertDates(String date, ByteArrayOutputStream bou) throws IOException {
        List<String[]> lines = this.readLines(bou.toString(), Character.valueOf(','));
        Assert.assertEquals((Object)date, (Object)lines.get(1)[3]);
    }
}

