/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.remote.v2_0;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.util.IOUtils;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.geotools.api.data.DataAccess;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.NullProgressListener;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.NameImpl;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.util.decorate.Wrapper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class WfsRemoteStoreTest
extends WFS20TestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoteWfsLayer() throws Exception {
        HashMap<String, String> environment = new HashMap<String, String>();
        URL tigerRoadsSchema = WfsRemoteStoreTest.class.getResource("tiger_roads_describe_feature_type.xml");
        MatcherAssert.assertThat((Object)tigerRoadsSchema, (Matcher)Matchers.notNullValue());
        environment.put("TIGER_ROADS_SCHEMA_LOCATION", tigerRoadsSchema.toString());
        MockHttpClient httpClient = new MockHttpClient();
        WfsRemoteStoreTest.registerHttpGetFromResource(httpClient, "/ows?REQUEST=DescribeFeatureType&VERSION=2.0.0&TYPENAMES=tiger%3Atiger_roads&NAMESPACES=xmlns%28tiger%2Chttp%3A%2F%2Fwww.census.gov%29&SERVICE=WFS", "tiger_roads_describe_feature_type.xml");
        WfsRemoteStoreTest.registerHttpGetFromResource(httpClient, "/ows?PROPERTYNAME=the_geom&TYPENAMES=tiger%3Atiger_roads&REQUEST=GetFeature&RESULTTYPE=RESULTS&OUTPUTFORMAT=application%2Fgml%2Bxml%3B+version%3D3.2&VERSION=2.0.0&SERVICE=WFS&COUNT=1000000", "tiger_roads_get_feature_resp_1.xml", environment);
        WfsRemoteStoreTest.registerHttpGetFromResource(httpClient, "/ows?PROPERTYNAME=the_geom%2CCFCC%2CNAME&TYPENAMES=tiger%3Atiger_roads&REQUEST=GetFeature&RESULTTYPE=RESULTS&OUTPUTFORMAT=application%2Fgml%2Bxml%3B+version%3D3.2&VERSION=2.0.0&SERVICE=WFS&COUNT=1000000", "tiger_roads_get_feature_resp_1.xml", environment);
        try {
            DataStoreInfo storeInfo = WfsRemoteStoreTest.createWfsDataStore(this.getCatalog(), "RemoteWfsStore", "remote_wfs_capabilities.xml");
            DataAccess dataStore = storeInfo.getDataStore((ProgressListener)new NullProgressListener());
            WFSDataStore wfsDatStore = WfsRemoteStoreTest.extractWfsDataStore(dataStore);
            wfsDatStore.getWfsClient().setHttpClient((HTTPClient)httpClient);
            WfsRemoteStoreTest.createWfsRemoteLayer(this.getCatalog(), storeInfo, "tiger_tiger_roads");
            MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetFeature&typenames=gs:tiger_tiger_roads&version=2.0.0&service=wfs");
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String content = response.getContentAsString();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)content.contains("numberMatched=\"1\" numberReturned=\"1\""), (Matcher)Matchers.is((Object)true));
        }
        finally {
            DataStoreInfo dataStoreInfo = (DataStoreInfo)this.getCatalog().getStoreByName("RemoteWfsStore", DataStoreInfo.class);
            if (dataStoreInfo != null) {
                CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(this.getCatalog());
                dataStoreInfo.accept((CatalogVisitor)visitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoteWfsLayerSpecialChars() throws Exception {
        HashMap<String, String> environment = new HashMap<String, String>();
        URL tigerRoadsSchema = WfsRemoteStoreTest.class.getResource("tiger_roads_describe_feature_type_special_chars.xml");
        MatcherAssert.assertThat((Object)tigerRoadsSchema, (Matcher)Matchers.notNullValue());
        environment.put("TIGER_ROADS_SCHEMA_LOCATION", tigerRoadsSchema.toString());
        MockHttpClient httpClient = new MockHttpClient();
        WfsRemoteStoreTest.registerHttpGetFromResource(httpClient, "/ows?REQUEST=DescribeFeatureType&VERSION=2.0.0&TYPENAMES=tiger%3Atiger_roads&NAMESPACES=xmlns%28tiger%2Chttp%3A%2F%2Fwww.census.gov%29&SERVICE=WFS", "tiger_roads_describe_feature_type_special_chars.xml");
        WfsRemoteStoreTest.registerHttpGetFromResource(httpClient, "/ows?PROPERTYNAME=the_geom&TYPENAMES=tiger%3Atiger_roads&REQUEST=GetFeature&RESULTTYPE=RESULTS&OUTPUTFORMAT=application%2Fgml%2Bxml%3B+version%3D3.2&VERSION=2.0.0&SERVICE=WFS&COUNT=1000000", "tiger_roads_get_feature_resp_special_chars.xml", environment);
        WfsRemoteStoreTest.registerHttpGetFromResource(httpClient, "/ows?PROPERTYNAME=the_geom%2C%C3%A6nd%2C%C3%B8st%2Cn%C3%B8j&TYPENAMES=tiger%3Atiger_roads&REQUEST=GetFeature&RESULTTYPE=RESULTS&OUTPUTFORMAT=application%2Fgml%2Bxml%3B+version%3D3.2&VERSION=2.0.0&SERVICE=WFS&COUNT=1000000", "tiger_roads_get_feature_resp_special_chars.xml", environment);
        try {
            DataStoreInfo storeInfo = WfsRemoteStoreTest.createWfsDataStore(this.getCatalog(), "RemoteWfsStore", "remote_wfs_capabilities.xml");
            DataAccess dataStore = storeInfo.getDataStore((ProgressListener)new NullProgressListener());
            WFSDataStore wfsDatStore = WfsRemoteStoreTest.extractWfsDataStore(dataStore);
            wfsDatStore.getWfsClient().setHttpClient((HTTPClient)httpClient);
            WfsRemoteStoreTest.createWfsRemoteLayer(this.getCatalog(), storeInfo, "tiger_tiger_roads");
            MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetFeature&typenames=gs:tiger_tiger_roads&version=2.0.0&service=wfs");
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String content = response.getContentAsString();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)content.contains("numberMatched=\"1\" numberReturned=\"1\""), (Matcher)Matchers.is((Object)true));
        }
        finally {
            DataStoreInfo dataStoreInfo = (DataStoreInfo)this.getCatalog().getStoreByName("RemoteWfsStore", DataStoreInfo.class);
            if (dataStoreInfo != null) {
                CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(this.getCatalog());
                dataStoreInfo.accept((CatalogVisitor)visitor);
            }
        }
    }

    private static LayerInfo createWfsRemoteLayer(Catalog catalog, DataStoreInfo storeInfo, String name) throws Exception {
        CatalogBuilder catalogBuilder = new CatalogBuilder(catalog);
        catalogBuilder.setStore((StoreInfo)storeInfo);
        FeatureTypeInfo featureTypeInfo = catalogBuilder.buildFeatureType((Name)new NameImpl("", name));
        catalog.add((ResourceInfo)featureTypeInfo);
        LayerInfo layerInfo = catalogBuilder.buildLayer(featureTypeInfo);
        catalog.add(layerInfo);
        layerInfo = catalog.getLayerByName(name);
        MatcherAssert.assertThat((Object)layerInfo, (Matcher)Matchers.notNullValue());
        return layerInfo;
    }

    private static DataStoreInfo createWfsDataStore(Catalog catalog, String name, String capabilitiesDocument) {
        URL url = WfsRemoteStoreTest.class.getResource(capabilitiesDocument);
        MatcherAssert.assertThat((Object)url, (Matcher)Matchers.notNullValue());
        CatalogBuilder catalogBuilder = new CatalogBuilder(catalog);
        DataStoreInfo storeInfo = catalogBuilder.buildDataStore(name);
        storeInfo.setType("Web Feature Server (NG)");
        storeInfo.getConnectionParameters().put(WFSDataStoreFactory.URL.key, url);
        storeInfo.getConnectionParameters().put(WFSDataStoreFactory.PROTOCOL.key, Boolean.FALSE);
        storeInfo.getConnectionParameters().put("TESTING", Boolean.TRUE);
        catalog.add((StoreInfo)storeInfo);
        storeInfo = (DataStoreInfo)catalog.getStoreByName(name, DataStoreInfo.class);
        MatcherAssert.assertThat((Object)storeInfo, (Matcher)Matchers.notNullValue());
        return storeInfo;
    }

    private static void registerHttpGetFromResource(MockHttpClient httpClient, String url, String resourceName, Map<String, String> environment) throws Exception {
        URL finalUrl = new URL("http://mock.test.geoserver.org" + url);
        try (InputStream input = WfsRemoteStoreTest.class.getResourceAsStream(resourceName);){
            MatcherAssert.assertThat((Object)input, (Matcher)Matchers.notNullValue());
            String content = IOUtils.toString((InputStream)input);
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                content = content.replaceAll("\\$\\{" + entry.getKey() + "}", entry.getValue());
            }
            httpClient.expectGet(finalUrl, (HTTPResponse)new MockHttpResponse(content, "text/xml", new String[0]));
        }
    }

    private static void registerHttpGetFromResource(MockHttpClient httpClient, String url, String resourceName) throws Exception {
        URL finalUrl = new URL("http://mock.test.geoserver.org" + url);
        URL resourceUrl = WfsRemoteStoreTest.class.getResource(resourceName);
        MatcherAssert.assertThat((Object)resourceUrl, (Matcher)Matchers.notNullValue());
        httpClient.expectGet(finalUrl, (HTTPResponse)new MockHttpResponse(resourceUrl, "text/xml", new String[0]));
    }

    private static WFSDataStore extractWfsDataStore(DataAccess dataStore) {
        MatcherAssert.assertThat((Object)dataStore, (Matcher)Matchers.notNullValue());
        if (dataStore instanceof Wrapper) {
            return (WFSDataStore)((Wrapper)dataStore).unwrap(WFSDataStore.class);
        }
        MatcherAssert.assertThat((Object)dataStore, (Matcher)Matchers.instanceOf(WFSDataStore.class));
        return (WFSDataStore)dataStore;
    }
}

