/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SrsNameTest
extends WFSTestSupport {
    @Override
    protected void setUpInternal(SystemTestData testData) throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    @Test
    public void testWfs10() throws Exception {
        String q = "wfs?request=getfeature&service=wfs&version=1.0.0&typename=cgf:Points";
        Document d = this.getAsDOM(q);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)d.getDocumentElement().getNodeName());
        this.print(d);
        NodeList boxes = d.getElementsByTagName("gml:Box");
        Assert.assertNotEquals((long)0L, (long)boxes.getLength());
        for (int i = 0; i < boxes.getLength(); ++i) {
            Element box = (Element)boxes.item(i);
            Assert.assertEquals((Object)"http://www.opengis.net/gml/srs/epsg.xml#32615", (Object)box.getAttribute("srsName"));
        }
        NodeList points = d.getElementsByTagName("gml:Point");
        Assert.assertNotEquals((long)0L, (long)points.getLength());
        for (int i = 0; i < points.getLength(); ++i) {
            Element point = (Element)points.item(i);
            Assert.assertEquals((Object)"http://www.opengis.net/gml/srs/epsg.xml#32615", (Object)point.getAttribute("srsName"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWfs11() throws Exception {
        WFSInfo wfs = this.getWFS();
        boolean oldFeatureBounding = wfs.isFeatureBounding();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            String q = "wfs?request=getfeature&service=wfs&version=1.1.0&typename=cgf:Points";
            Document d = this.getAsDOM(q);
            Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)d.getDocumentElement().getNodeName());
            NodeList boxes = d.getElementsByTagName("gml:Envelope");
            Assert.assertNotEquals((long)0L, (long)boxes.getLength());
            for (int i = 0; i < boxes.getLength(); ++i) {
                Element box = (Element)boxes.item(i);
                Assert.assertEquals((Object)"urn:x-ogc:def:crs:EPSG:32615", (Object)box.getAttribute("srsName"));
            }
            NodeList points = d.getElementsByTagName("gml:Point");
            Assert.assertNotEquals((long)0L, (long)points.getLength());
            for (int i = 0; i < points.getLength(); ++i) {
                Element point = (Element)points.item(i);
                Assert.assertEquals((Object)"urn:x-ogc:def:crs:EPSG:32615", (Object)point.getAttribute("srsName"));
            }
        }
        finally {
            wfs.setFeatureBounding(oldFeatureBounding);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testSrsNameSyntax11() throws Exception {
        this.doTestSrsNameSyntax11(GMLInfo.SrsNameStyle.URN, false);
        this.doTestSrsNameSyntax11(GMLInfo.SrsNameStyle.URN2, true);
        this.doTestSrsNameSyntax11(GMLInfo.SrsNameStyle.URL, true);
        this.doTestSrsNameSyntax11(GMLInfo.SrsNameStyle.NORMAL, true);
        this.doTestSrsNameSyntax11(GMLInfo.SrsNameStyle.XML, true);
    }

    void doTestSrsNameSyntax11(GMLInfo.SrsNameStyle srsNameStyle, boolean doSave) throws Exception {
        if (doSave) {
            WFSInfo wfs = this.getWFS();
            GMLInfo gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_11);
            gml.setSrsNameStyle(srsNameStyle);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
        String q = "wfs?request=getfeature&service=wfs&version=1.1.0&typename=cgf:Points";
        Document d = this.getAsDOM(q);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)d.getDocumentElement().getNodeName());
        String identifier = srsNameStyle.toSrsSyntax().getSRS("EPSG:32615");
        XMLAssert.assertXpathExists((String)("//gml:Envelope[@srsName = '" + identifier + "']"), (Document)d);
        XMLAssert.assertXpathExists((String)("//gml:Point[@srsName = '" + identifier + "']"), (Document)d);
    }
}

