/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MaxFeaturesTest
extends WFSTestSupport {
    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = this.getWFS();
        wfs.setMaxFeatures(5);
        gs.save((ServiceInfo)wfs);
    }

    @Before
    public void resetLocalMaxes() {
        FeatureTypeInfo info = this.getFeatureTypeInfo(SystemTestData.FIFTEEN);
        info.setMaxFeatures(0);
        this.getCatalog().save((ResourceInfo)info);
        info = this.getFeatureTypeInfo(SystemTestData.BASIC_POLYGONS);
        info.setMaxFeatures(0);
        this.getCatalog().save((ResourceInfo)info);
    }

    @Test
    public void testGlobalMax() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertEquals((long)5L, (long)featureMembers.getLength());
    }

    @Test
    public void testLocalMax() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(SystemTestData.FIFTEEN);
        info.setMaxFeatures(3);
        this.getCatalog().save((ResourceInfo)info);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertEquals((long)3L, (long)featureMembers.getLength());
    }

    @Test
    public void testLocalMaxBigger() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(SystemTestData.FIFTEEN);
        info.setMaxFeatures(10);
        this.getCatalog().save((ResourceInfo)info);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertEquals((long)5L, (long)featureMembers.getLength());
    }

    @Test
    public void testCombinedLocalMaxes() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(SystemTestData.FIFTEEN);
        info.setMaxFeatures(2);
        this.getCatalog().save((ResourceInfo)info);
        info = this.getFeatureTypeInfo(SystemTestData.BASIC_POLYGONS);
        info.setMaxFeatures(2);
        this.getCatalog().save((ResourceInfo)info);
        Document doc = this.getAsDOM("wfs?request=GetFeature&srsName=EPSG:4326&typename=cdf:Fifteen,cite:BasicPolygons&version=1.0.0&service=wfs");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)4L, (long)doc.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((long)2L, (long)doc.getElementsByTagName("cdf:Fifteen").getLength());
        Assert.assertEquals((long)2L, (long)doc.getElementsByTagName("cite:BasicPolygons").getLength());
    }

    @Test
    public void testCombinedLocalMaxesBigger() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(SystemTestData.FIFTEEN);
        info.setMaxFeatures(4);
        this.getCatalog().save((ResourceInfo)info);
        info = this.getFeatureTypeInfo(SystemTestData.BASIC_POLYGONS);
        info.setMaxFeatures(2);
        this.getCatalog().save((ResourceInfo)info);
        Document doc = this.getAsDOM("wfs?request=GetFeature&srsName=EPSG:4326&typename=cdf:Fifteen,cite:BasicPolygons&version=1.0.0&service=wfs");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)5L, (long)doc.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((long)4L, (long)doc.getElementsByTagName("cdf:Fifteen").getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("cite:BasicPolygons").getLength());
    }

    @Test
    public void testCombinedLocalMaxesBiggerRequestOverride() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(SystemTestData.FIFTEEN);
        info.setMaxFeatures(3);
        this.getCatalog().save((ResourceInfo)info);
        info = this.getFeatureTypeInfo(SystemTestData.BASIC_POLYGONS);
        this.getCatalog().save((ResourceInfo)info);
        info.setMaxFeatures(2);
        Document doc = this.getAsDOM("wfs?request=GetFeature&srsName=EPSG:4326&typename=cdf:Fifteen,cite:BasicPolygons&version=1.0.0&service=wfs&maxFeatures=4");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)4L, (long)doc.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((long)3L, (long)doc.getElementsByTagName("cdf:Fifteen").getLength());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("cite:BasicPolygons").getLength());
    }

    @Test
    public void testMaxFeaturesBreak() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(SystemTestData.FIFTEEN);
        info.setMaxFeatures(3);
        this.getCatalog().save((ResourceInfo)info);
        info = this.getFeatureTypeInfo(SystemTestData.BASIC_POLYGONS);
        info.setMaxFeatures(2);
        this.getCatalog().save((ResourceInfo)info);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen,cite:BasicPolygons&version=1.0.0&service=wfs&maxFeatures=3");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)3L, (long)doc.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((long)3L, (long)doc.getElementsByTagName("cdf:Fifteen").getLength());
        Assert.assertEquals((long)0L, (long)doc.getElementsByTagName("cite:BasicPolygons").getLength());
    }
}

