/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.gml3;

import org.geoserver.wfs.WFSException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.JTS;
import org.geotools.gml2.bindings.GML2ParsingUtils;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;
import org.picocontainer.MutablePicoContainer;

public class AbstractGeometryTypeBinding
extends org.geotools.gml3.bindings.AbstractGeometryTypeBinding {
    CoordinateReferenceSystem crs;

    public AbstractGeometryTypeBinding() {
        super(null, null);
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public void initializeChildContext(ElementInstance childInstance, Node node, MutablePicoContainer context) {
        if (node.hasAttribute("srsName")) {
            try {
                CoordinateReferenceSystem crs = GML2ParsingUtils.crs((Node)node);
                if (crs != null) {
                    context.registerComponentInstance(CoordinateReferenceSystem.class, (Object)crs);
                }
            }
            catch (Exception e) {
                throw new WFSException(e, "InvalidParameterValue");
            }
        }
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        try {
            if (node.hasAttribute("srsName")) {
                CRS.decode((String)node.getAttributeValue("srsName").toString());
            }
        }
        catch (NoSuchAuthorityCodeException e) {
            throw new WFSException("Invalid Authority Code: " + e.getAuthorityCode(), "InvalidParameterValue");
        }
        Geometry geometry = (Geometry)super.parse(instance, node, value);
        if (geometry != null) {
            CoordinateReferenceSystem crs;
            if (geometry.getUserData() == null && this.crs != null) {
                geometry.setUserData((Object)this.crs);
            }
            if ((crs = (CoordinateReferenceSystem)geometry.getUserData()) != null) {
                try {
                    JTS.checkCoordinatesRange((Geometry)geometry, (CoordinateReferenceSystem)crs);
                }
                catch (PointOutsideEnvelopeException e) {
                    throw new WFSException(e, "InvalidParameterValue");
                }
            }
        }
        return geometry;
    }
}

