/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wfs.PropertyType;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geoserver.wfs.xml.GML3Profile;
import org.geoserver.wfs.xml.TypeMappingProfile;
import org.geoserver.wfs.xml.XSProfile;
import org.geotools.api.feature.type.Name;
import org.geotools.xsd.PropertyExtractor;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;

public class PropertyTypePropertyExtractor
implements PropertyExtractor {
    SchemaIndex index;

    public PropertyTypePropertyExtractor(SchemaIndex index) {
        this.index = index;
    }

    public boolean canHandle(Object object) {
        return object instanceof PropertyType;
    }

    public List<Object[]> properties(Object object, XSDElementDeclaration element) {
        XSDTypeDefinition type;
        PropertyType property = (PropertyType)object;
        ArrayList<Object[]> properties = new ArrayList<Object[]>(2);
        properties.add(new Object[]{Schemas.getChildElementParticle((XSDTypeDefinition)element.getType(), (String)"Name", (boolean)false), property.getName()});
        QName newTypeName = this.guessValueType(property.getValue());
        XSDTypeDefinition xSDTypeDefinition = type = newTypeName != null ? this.index.getTypeDefinition(newTypeName) : null;
        if (type != null) {
            XSDElementDeclaration value = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            value.setName("Value");
            value.setTypeDefinition(type);
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setMinOccurs(1);
            particle.setMaxOccurs(1);
            particle.setContent((XSDParticleContent)value);
            properties.add(new Object[]{particle, property.getValue()});
        } else {
            Object[] p = new Object[]{Schemas.getChildElementParticle((XSDTypeDefinition)element.getType(), (String)"Value", (boolean)false), property.getValue()};
            properties.add(p);
        }
        return properties;
    }

    private QName guessValueType(Object value) {
        Class<?> clazz = value.getClass();
        List<Object> profiles = Arrays.asList(new XSProfile(), new GML3Profile());
        for (Object o : profiles) {
            TypeMappingProfile profile = (TypeMappingProfile)o;
            Name name = profile.name(clazz);
            if (name == null) continue;
            return new QName(name.getNamespaceURI(), name.getLocalPart());
        }
        return null;
    }
}

