/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response.v2_0;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import net.opengis.wfs20.GetFeatureType;
import net.opengis.wfs20.ResultTypeType;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;

public class HitsOutputFormat
extends org.geoserver.wfs.response.HitsOutputFormat {
    public HitsOutputFormat(GeoServer gs) {
        super(gs, (Configuration)new WFSConfiguration());
    }

    @Override
    public boolean canHandle(Operation operation) {
        GetFeatureType request = (GetFeatureType)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureType.class);
        return request != null && request.getResultType() == ResultTypeType.HITS;
    }

    @Override
    protected void encode(FeatureCollectionResponse hits, OutputStream output, WFSInfo wfs) throws IOException {
        hits.setNumberOfFeatures(BigInteger.valueOf(0L));
        Encoder e = new Encoder((Configuration)new WFSConfiguration());
        e.setEncoding(Charset.forName(wfs.getGeoServer().getSettings().getCharset()));
        e.setSchemaLocation("http://www.opengis.net/wfs/2.0", ResponseUtils.appendPath((String[])new String[]{wfs.getSchemaBaseURL(), "wfs/2.0/wfs.xsd"}));
        e.encode((Object)hits.getAdaptee(), WFS.FeatureCollection, output);
    }
}

