/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.opengis.wfs.LockFeatureType;
import net.opengis.wfs.LockType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.kvp.BaseFeatureKvpRequestReader;
import org.geoserver.wfs.request.Query;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.xsd.EMFUtils;
import org.locationtech.jts.geom.Envelope;

public class LockFeatureKvpRequestReader
extends BaseFeatureKvpRequestReader {
    public LockFeatureKvpRequestReader(GeoServer geoServer, FilterFactory filterFactory) {
        super(LockFeatureType.class, (EFactory)WfsFactory.eINSTANCE, geoServer, filterFactory);
    }

    @Override
    protected <T> void querySet(EObject request, String property, List<T> values) throws WFSException {
        if (values == null) {
            return;
        }
        if ("typeName".equalsIgnoreCase(property)) {
            values = this.typenameWorkaround(values);
        }
        LockFeatureType lockFeature = (LockFeatureType)request;
        EList lock = lockFeature.getLock();
        int m = values.size();
        int n = lock.size();
        if (m == 1 && n > 1) {
            EMFUtils.set((List)lock, (String)property, values.get(0));
            return;
        }
        if (m > n) {
            if (n == 0) {
                for (int i = 0; i < m; ++i) {
                    lock.add((Object)WfsFactory.eINSTANCE.createLockType());
                }
            } else {
                if (n == 1) {
                    EObject q = (EObject)lock.get(0);
                    for (int i = 1; i < m; ++i) {
                        lock.add((Object)((LockType)EMFUtils.clone((EObject)q, (EFactory)WfsFactory.eINSTANCE, (boolean)false)));
                    }
                    return;
                }
                String msg = "Specified " + m + " " + property + " for " + n + " locks.";
                throw new WFSException(request, msg);
            }
        }
        if (m < n) {
            ArrayList<T> newValues = new ArrayList<T>();
            newValues.addAll(values);
            for (int i = 0; i < n - m; ++i) {
                newValues.add(null);
            }
            values = newValues;
        }
        EMFUtils.set((List)lock, (String)property, values);
    }

    private <T> List<T> typenameWorkaround(List<T> values) {
        values = values.stream().map(o -> ((List)o).get(0)).collect(Collectors.toList());
        return values;
    }

    @Override
    protected void buildStoredQueries(EObject request, List<URI> storedQueryIds, Map<String, Object> kvp) {
        throw new UnsupportedOperationException("No stored queries in WFS 1.0 or 1.1");
    }

    @Override
    protected List<Query> getQueries(EObject eObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleBBOX(Map kvp, EObject eObject) throws Exception {
        Envelope bbox = (Envelope)kvp.get("bbox");
        EList queries = ((LockFeatureType)eObject).getLock();
        for (LockType lock : queries) {
            BBOX filter = this.bboxFilter(bbox);
            lock.setFilter((Filter)filter);
        }
    }
}

