/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs20.ParameterExpressionType;
import net.opengis.wfs20.ParameterType;
import net.opengis.wfs20.StoredQueryType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.NumericKvpParser;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.kvp.BaseFeatureKvpRequestReader;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.api.filter.FilterFactory;
import org.geotools.xsd.EMFUtils;

public class GetFeatureKvpRequestReader
extends BaseFeatureKvpRequestReader {
    public GetFeatureKvpRequestReader(Class<?> requestBean, GeoServer geoServer, FilterFactory filterFactory) {
        this(requestBean, (EFactory)WfsFactory.eINSTANCE, geoServer, filterFactory);
    }

    public GetFeatureKvpRequestReader(Class<?> requestBean, EFactory factory, GeoServer geoServer, FilterFactory filterFactory) {
        super(requestBean, factory, geoServer, filterFactory);
    }

    @Override
    protected WFSInfo getWFS() {
        return (WFSInfo)this.geoServer.getService(WFSInfo.class);
    }

    @Override
    public Object read(Object request, Map<String, Object> kvp, Map<String, Object> rawKvp) throws Exception {
        EObject eObject;
        if (rawKvp.containsKey("startIndex")) {
            kvp.put("startIndex", new NumericKvpParser(null, BigInteger.class).parse((String)rawKvp.get("startIndex")));
        }
        if (!EMFUtils.isSet((EObject)(eObject = (EObject)(request = super.read(request, kvp, rawKvp))), (String)"outputFormat")) {
            String version = (String)EMFUtils.get((EObject)eObject, (String)"version");
            switch (WFSInfo.Version.negotiate(version)) {
                case V_10: {
                    EMFUtils.set((EObject)eObject, (String)"outputFormat", (Object)"GML2");
                    break;
                }
                case V_11: {
                    EMFUtils.set((EObject)eObject, (String)"outputFormat", (Object)"text/xml; subtype=gml/3.1.1");
                    break;
                }
                default: {
                    EMFUtils.set((EObject)eObject, (String)"outputFormat", (Object)"application/gml+xml; version=3.2");
                }
            }
        }
        if (kvp.containsKey("aliases")) {
            List aliases = (List)kvp.get("aliases");
            this.querySet(eObject, "aliases", aliases);
        }
        if (kvp.containsKey("propertyName")) {
            List propertyNames = new ArrayList();
            if (kvp.get("propertyName") != null && kvp.get("propertyName") instanceof List) {
                List cast = (List)kvp.get("propertyName");
                propertyNames = cast;
            } else if (kvp.get("propertyName") != null && kvp.get("propertyName") instanceof String) {
                propertyNames.addAll(KvpUtils.readFlat((String)((String)kvp.get("propertyName"))));
            }
            this.querySet(eObject, "propertyName", propertyNames);
        }
        if (kvp.containsKey("sortBy")) {
            List sortBy = (List)kvp.get("sortBy");
            this.querySet(eObject, "sortBy", sortBy);
        }
        if (kvp.containsKey("srsName")) {
            this.querySet(eObject, "srsName", Collections.singletonList((URI)kvp.get("srsName")));
        }
        if (kvp.containsKey("featureVersion")) {
            this.querySet(eObject, "featureVersion", Collections.singletonList((String)kvp.get("featureVersion")));
        }
        GetFeatureRequest req = GetFeatureRequest.adapt(request);
        if (kvp.containsKey("format_options")) {
            Map fo = (Map)kvp.get("format_options");
            req.getFormatOptions().putAll(fo);
        }
        if (kvp.containsKey("viewParams")) {
            ArrayList<Map> viewParams;
            if (req.getViewParams() == null) {
                req.setViewParams(new ArrayList<Map<String, String>>());
            }
            if (!(viewParams = (ArrayList<Map>)kvp.get("viewParams")).isEmpty()) {
                int layerCount = req.getQueries().size();
                if (viewParams.size() == 1 && layerCount > 1) {
                    ArrayList<Map> replacement = new ArrayList<Map>();
                    for (int i = 0; i < layerCount; ++i) {
                        replacement.add((Map)viewParams.get(0));
                    }
                    viewParams = replacement;
                } else if (viewParams.size() != layerCount) {
                    String msg = layerCount + " feature types requested, but found " + viewParams.size() + " view params specified. ";
                    throw new WFSException(eObject, msg, ((Object)((Object)this)).getClass().getName());
                }
            }
            req.setViewParams((List<Map<String, String>>)viewParams);
        }
        return request;
    }

    @Override
    protected <T> void querySet(EObject request, String property, List<T> values) throws WFSException {
        if (values == null) {
            return;
        }
        GetFeatureRequest req = GetFeatureRequest.adapt(request);
        if (req instanceof GetFeatureRequest.WFS20) {
            if ("typeName".equals(property)) {
                property = "typeNames";
            }
            if ("propertyName".equals(property)) {
                property = "abstractProjectionClause";
            }
        }
        List<Object> query = req.getAdaptedQueries();
        int m = values.size();
        int n = query.size();
        if (m == 1 && n > 1) {
            EMFUtils.set(query, (String)property, values.get(0));
            return;
        }
        if (m > n) {
            if (n == 0) {
                for (int i = 0; i < m; ++i) {
                    query.add(req.createQuery().getAdaptee());
                }
            } else {
                if (n == 1) {
                    EObject q = (EObject)query.get(0);
                    for (int i = 1; i < m; ++i) {
                        query.add(EMFUtils.clone((EObject)q, (EFactory)req.getFactory(), (boolean)false));
                    }
                    return;
                }
                String msg = "Specified " + m + " " + property + " for " + n + " queries.";
                throw new WFSException(request, msg);
            }
        }
        if (m < n) {
            ArrayList<T> newValues = new ArrayList<T>();
            newValues.addAll(values);
            for (int i = 0; i < n - m; ++i) {
                newValues.add(null);
            }
            values = newValues;
        }
        EMFUtils.set(query, (String)property, values);
    }

    @Override
    protected void buildStoredQueries(EObject request, List<URI> storedQueryIds, Map<String, Object> kvp) {
        GetFeatureRequest req = GetFeatureRequest.adapt(request);
        if (!(req instanceof GetFeatureRequest.WFS20)) {
            throw new WFSException((RequestObject)req, "Stored queries only supported in WFS 2.0+");
        }
        StoredQueryProvider sqp = new StoredQueryProvider(this.catalog, this.getWFS(), this.geoServer.getGlobal().isAllowStoredQueriesPerWorkspace());
        for (URI storedQueryId : storedQueryIds) {
            StoredQuery sq = sqp.getStoredQuery(storedQueryId.toString());
            if (sq == null) {
                WFSException exception = new WFSException((RequestObject)req, "No such stored query: " + storedQueryId, "InvalidParameterValue");
                exception.setLocator("STOREDQUERY_ID");
                throw exception;
            }
            Wfs20Factory factory = (Wfs20Factory)req.getFactory();
            StoredQueryType storedQuery = factory.createStoredQueryType();
            storedQuery.setId(storedQueryId.toString());
            for (ParameterExpressionType p : sq.getQuery().getParameter()) {
                if (!kvp.containsKey(p.getName())) continue;
                ParameterType param = factory.createParameterType();
                param.setName(p.getName());
                param.setValue(kvp.get(p.getName()).toString());
                storedQuery.getParameter().add((Object)param);
            }
            req.getAdaptedQueries().add(storedQuery);
        }
    }
}

