/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.util.List;
import java.util.Spliterators;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import org.geoserver.wfs.json.ComplexGeoJsonWriterOptions;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;

public class DefaultComplexGeoJsonWriterOptions
implements ComplexGeoJsonWriterOptions {
    static final Logger LOGGER = Logging.getLogger(DefaultComplexGeoJsonWriterOptions.class);
    private static Class NON_FEATURE_TYPE_PROXY;

    @Override
    public boolean canHandle(List<FeatureCollection> features) {
        return true;
    }

    @Override
    public boolean encodeComplexAttributeType() {
        return true;
    }

    @Override
    public boolean encodeNestedFeatureAsProperty(ComplexType complexType) {
        return NON_FEATURE_TYPE_PROXY != null && NON_FEATURE_TYPE_PROXY.isInstance(complexType);
    }

    static {
        try {
            NON_FEATURE_TYPE_PROXY = Class.forName("org.geotools.data.complex.config.NonFeatureTypeProxy");
        }
        catch (ClassNotFoundException e) {
            if (StreamSupport.stream(Spliterators.spliteratorUnknownSize(DataStoreFinder.getAllDataStores(), 16), false).anyMatch(f -> f != null && f.getClass().getSimpleName().equals("AppSchemaDataAccessFactory"))) {
                LOGGER.log(Level.FINE, "Could not find NonFeatureTypeProxy yet App-schema is around, probably the class changed name, package or does not exist anymore", e);
            }
            NON_FEATURE_TYPE_PROXY = null;
        }
    }
}

