/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.net.URLDecoder;
import java.util.List;
import org.geoserver.wfs.kvp.Filter_2_0_0_KvpParser;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.PropertyName;
import org.junit.Assert;
import org.junit.Test;

public class Filter_2_0_0_KvpParserTest {
    private static void parsePropertyIsLike(String expectedLiteral, String encodedLiteral, Boolean matchCase) throws Exception {
        String encodedXml = "%3Cfes:Filter%20xmlns:fes=%22http://www.opengis.net/fes/2.0%22%3E%3Cfes:PropertyIsLike%20wildCard=%22*%22%20singleChar=%22%25%22%20escapeChar=%22!%22" + (String)(matchCase == null ? "" : "%20matchCase=%22" + matchCase + "%22") + "%3E%3Cfes:ValueReference%3Etopp:STATE_NAME%3C/fes:ValueReference%3E%3Cfes:Literal%3E" + encodedLiteral + "%3C/fes:Literal%3E%3C/fes:PropertyIsLike%3E%3C/fes:Filter%3E";
        String xml = URLDecoder.decode(encodedXml, "UTF-8");
        List filters = (List)new Filter_2_0_0_KvpParser(null).parse(xml);
        Assert.assertEquals((long)1L, (long)filters.size());
        PropertyIsLike propertyIsLike = (PropertyIsLike)filters.get(0);
        Assert.assertEquals((Object)"*", (Object)propertyIsLike.getWildCard());
        Assert.assertEquals((Object)"%", (Object)propertyIsLike.getSingleChar());
        Assert.assertEquals((Object)"!", (Object)propertyIsLike.getEscape());
        Assert.assertEquals((Object)(matchCase == null ? true : matchCase), (Object)propertyIsLike.isMatchingCase());
        Assert.assertEquals((Object)"topp:STATE_NAME", (Object)((PropertyName)propertyIsLike.getExpression()).getPropertyName());
        Assert.assertEquals((Object)expectedLiteral, (Object)propertyIsLike.getLiteral());
    }

    @Test
    public void testPropertyIsLikeAsciiLiteral() throws Exception {
        Filter_2_0_0_KvpParserTest.parsePropertyIsLike("Illino*", "Illino*", null);
    }

    @Test
    public void testPropertyIsLikeNonAsciiLiteral() throws Exception {
        Filter_2_0_0_KvpParserTest.parsePropertyIsLike("\u00fc*", "%C3%BC*", null);
    }

    @Test
    public void testPropertyIsLikeMatchCaseTrue() throws Exception {
        Filter_2_0_0_KvpParserTest.parsePropertyIsLike("Illino*", "Illino*", true);
    }

    @Test
    public void testPropertyIsLikeMatchCaseFalse() throws Exception {
        Filter_2_0_0_KvpParserTest.parsePropertyIsLike("Illino*", "Illino*", false);
    }
}

