/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.WFSCurvesTestSupport;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvedGeometries;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;
import org.w3c.dom.Document;

public abstract class AbstractTransactionCurveTest
extends WFSCurvesTestSupport {
    @Test
    public void testInsertArc() throws Exception {
        String xml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("insertArc.xml"), (Charset)StandardCharsets.UTF_8);
        Document dom = this.postAsDOM("wfs", xml);
        this.checkSuccesfulTransaction(dom, 1, 0, 0);
        SimpleFeature first = this.getSingleFeature(this.CURVELINES, "Arc far away");
        Geometry g = (Geometry)first.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof SingleCurvedGeometry));
        SingleCurvedGeometry curved = (SingleCurvedGeometry)g;
        double[] cp = curved.getControlPoints();
        Assert.assertArrayEquals((double[])new double[]{10.0, 15.0, 15.0, 20.0, 20.0, 15.0}, (double[])cp, (double)0.0);
    }

    @Test
    public void testUpdateCompoundCurve() throws Exception {
        String xml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("updateCompoundCurve.xml"), (Charset)StandardCharsets.UTF_8);
        Document dom = this.postAsDOM("wfs", xml);
        this.checkSuccesfulTransaction(dom, 0, 1, 0);
        SimpleFeature first = this.getSingleFeature(this.CURVELINES, "Compound");
        Geometry g = (Geometry)first.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof CompoundCurvedGeometry));
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)g;
        List components = compound.getComponents();
        Assert.assertEquals((long)3L, (long)components.size());
        LineString ls1 = (LineString)components.get(0);
        Assert.assertEquals((long)2L, (long)ls1.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(10.0, 45.0), (Object)ls1.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(20.0, 45.0), (Object)ls1.getCoordinateN(1));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{20.0, 45.0, 23.0, 48.0, 20.0, 51.0}, (double[])cs.getControlPoints(), (double)0.0);
        LineString ls2 = (LineString)components.get(2);
        Assert.assertEquals((long)2L, (long)ls2.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(20.0, 51.0), (Object)ls2.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(10.0, 51.0), (Object)ls2.getCoordinateN(1));
    }

    @Test
    public void testInsertCurvePolygon() throws Exception {
        String xml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("insertCurvePolygon.xml"), (Charset)StandardCharsets.UTF_8);
        Document dom = this.postAsDOM("wfs", xml);
        this.checkSuccesfulTransaction(dom, 1, 0, 0);
        SimpleFeature first = this.getSingleFeature(this.CURVEPOLYGONS, "Circle2");
        Geometry g = (Geometry)first.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof Polygon));
        Polygon p = (Polygon)g;
        Assert.assertEquals((long)0L, (long)p.getNumInteriorRing());
        Assert.assertTrue((boolean)(p.getExteriorRing() instanceof CircularRing));
        CircularRing shell = (CircularRing)p.getExteriorRing();
        Assert.assertTrue((boolean)CurvedGeometries.isCircle((Geometry)shell));
        CircularArc arc = shell.getArcN(0);
        Assert.assertEquals((double)5.0, (double)arc.getRadius(), (double)0.0);
        Assert.assertEquals((Object)new Coordinate(15.0, 50.0), (Object)arc.getCenter());
    }

    @Test
    public void testInsertMultiCurve() throws Exception {
        String xml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("insertMultiCurve.xml"), (Charset)StandardCharsets.UTF_8);
        Document dom = this.postAsDOM("wfs", xml);
        this.checkSuccesfulTransaction(dom, 1, 0, 0);
        SimpleFeature first = this.getSingleFeature(this.CURVEMULTILINES, "MNew");
        Geometry g = (Geometry)first.getDefaultGeometry();
        Assert.assertTrue((boolean)(g instanceof MultiLineString));
        MultiLineString mc = (MultiLineString)g;
        LineString ls = (LineString)mc.getGeometryN(0);
        Assert.assertEquals((long)2L, (long)ls.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)ls.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(5.0, 5.0), (Object)ls.getCoordinateN(1));
        CircularString cs = (CircularString)mc.getGeometryN(1);
        Assert.assertArrayEquals((double[])new double[]{4.0, 0.0, 4.0, 4.0, 8.0, 4.0}, (double[])cs.getControlPoints(), (double)0.0);
    }

    private SimpleFeature getSingleFeature(QName typeName, String featureName) throws IOException, CQLException {
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(this.getLayerId(typeName));
        SimpleFeatureSource fs = (SimpleFeatureSource)ft.getFeatureSource(null, null);
        SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)fs.getFeatures(ECQL.toFilter((String)("name = '" + featureName + "'"))));
        Assert.assertNotNull((Object)first);
        return first;
    }

    private String checkSuccesfulTransaction(Document dom, int inserted, int updated, int deleted) throws XpathException {
        Assert.assertEquals((Object)String.valueOf(inserted), (Object)this.xpath.evaluate("/wfs:TransactionResponse/wfs:TransactionSummary/wfs:totalInserted", dom));
        Assert.assertEquals((Object)String.valueOf(updated), (Object)this.xpath.evaluate("/wfs:TransactionResponse/wfs:TransactionSummary/wfs:totalUpdated", dom));
        Assert.assertEquals((Object)String.valueOf(deleted), (Object)this.xpath.evaluate("/wfs:TransactionResponse/wfs:TransactionSummary/wfs:totalDeleted", dom));
        return this.xpath.evaluate("//ogc:FeatureId/@fid", dom);
    }
}

