/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.referencing.CRS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class ScalingExtentionTest
extends WCSTestSupport {
    private GridCoverage2D sourceCoverage;

    @Before
    public void setup() throws Exception {
        this.sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        GeoServer gs = this.getGeoServer();
        GeoServerInfo gsInfo = gs.getGlobal();
        SettingsInfo settings = gsInfo.getSettings();
        settings.setVerboseExceptions(true);
        gs.save(gsInfo);
    }

    @After
    public void close() {
        try {
            if (this.sourceCoverage != null) {
                this.scheduleForCleaning((GridCoverage)this.sourceCoverage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testScaleAxesByFactorXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageScaleAxesByFactor.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        Assert.assertEquals((long)1260L, (long)reader.getOriginalGridRange().getSpan(0));
        Assert.assertEquals((long)1260L, (long)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        Assert.assertNotNull((Object)coverage);
        ScalingExtentionTest.assertEnvelopeEquals((Coverage)this.sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
    }

    @Test
    public void testScaleToSizeXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageScaleToSize.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        if ("application/xml".equals(response.getContentType())) {
            LOGGER.warning("Error message: " + response.getContentAsString());
            Runtime runtime = Runtime.getRuntime();
            LOGGER.warning("Max memory: " + runtime.maxMemory());
            LOGGER.warning("Free memory: " + runtime.freeMemory());
            LOGGER.warning("Total memory: " + runtime.totalMemory());
        }
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        Assert.assertEquals((long)1000L, (long)reader.getOriginalGridRange().getSpan(0));
        Assert.assertEquals((long)1000L, (long)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        Assert.assertNotNull((Object)coverage);
        ScalingExtentionTest.assertEnvelopeEquals((Coverage)this.sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
    }

    @Test
    public void testScaleToExtentXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageScaleToExtent.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        Assert.assertEquals((long)200L, (long)reader.getOriginalGridRange().getSpan(0));
        Assert.assertEquals((long)300L, (long)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        Assert.assertNotNull((Object)coverage);
        ScalingExtentionTest.assertEnvelopeEquals((Coverage)this.sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
    }

    @Test
    public void testScaleByFactorXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageScaleByFactor.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        Assert.assertEquals((long)900L, (long)reader.getOriginalGridRange().getSpan(0));
        Assert.assertEquals((long)900L, (long)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        Assert.assertNotNull((Object)coverage);
        ScalingExtentionTest.assertEnvelopeEquals((Coverage)this.sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
    }
}

