/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class RangeSubsetExtentionTest
extends WCSTestSupport {
    @Test
    public void testBasic() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsetting.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        Assert.assertEquals((long)360L, (long)reader.getOriginalGridRange().getSpan(0));
        Assert.assertEquals((long)360L, (long)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        Assert.assertEquals((long)1L, (long)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void mixed() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsettingInterval2.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        Assert.assertEquals((long)360L, (long)reader.getOriginalGridRange().getSpan(0));
        Assert.assertEquals((long)360L, (long)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        Assert.assertEquals((long)5L, (long)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void testWrong() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageWrongRangeSubsetting.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.NoSuchField.getExceptionCode(), "Band1");
    }

    @Test
    public void test9to3() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsetting9to3.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("gtiff", "gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:32611", (boolean)true)));
        Assert.assertEquals((long)68L, (long)reader.getOriginalGridRange().getSpan(0));
        Assert.assertEquals((long)56L, (long)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        Assert.assertEquals((long)3L, (long)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("multiband").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void test9to4() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsetting9to4.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("gtiff", "gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:32611", (boolean)true)));
        Assert.assertEquals((long)68L, (long)reader.getOriginalGridRange().getSpan(0));
        Assert.assertEquals((long)56L, (long)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        Assert.assertEquals((long)4L, (long)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("multiband").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void test9to7() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsetting9to7.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("gtiff", "gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:32611", (boolean)true)));
        Assert.assertEquals((long)68L, (long)reader.getOriginalGridRange().getSpan(0));
        Assert.assertEquals((long)56L, (long)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        Assert.assertEquals((long)7L, (long)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("multiband").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void testRange() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsettingInterval.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        Assert.assertEquals((long)360L, (long)reader.getOriginalGridRange().getSpan(0));
        Assert.assertEquals((long)360L, (long)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        Assert.assertEquals((long)3L, (long)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }
}

