/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import java.io.File;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;
import org.junit.Test;
import org.w3c.dom.Document;

public class GetCapabilitiesTest
extends WCSTestSupport {
    @Test
    public void testBasicPost() throws Exception {
        File xml = new File("./src/test/resources/getcapabilities/getCap.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        this.checkFullCapabilitiesDocument(dom);
    }

    @Test
    public void testCase() throws Exception {
        File xml = new File("./src/test/resources/getcapabilities/getCapWrongCase.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@exceptionCode='InvalidParameterValue'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@locator='WcS'])", (Document)dom);
    }

    @Test
    public void testInternationalContent() throws Exception {
        GeoServer gs = this.getGeoServer();
        Catalog catalog = this.getCatalog();
        CoverageInfo blueMarble = catalog.getCoverageByName("BlueMarble");
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for ci bluemarble");
        title.add(Locale.ITALIAN, "titolo italiano");
        GrowableInternationalString _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for ci bluemarble");
        _abstract.add(Locale.ITALIAN, "abstract italiano");
        blueMarble.setInternationalTitle((InternationalString)title);
        blueMarble.setInternationalAbstract((InternationalString)_abstract);
        Keyword keywordInfo = new Keyword("english keyword");
        keywordInfo.setLanguage(Locale.ENGLISH.getLanguage());
        Keyword keywordInfo2 = new Keyword("parola chiave");
        keywordInfo2.setLanguage(Locale.ITALIAN.getLanguage());
        blueMarble.getKeywords().add(keywordInfo);
        blueMarble.getKeywords().add(keywordInfo2);
        catalog.save((ResourceInfo)blueMarble);
        CoverageInfo dem = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        GrowableInternationalString demTitle = new GrowableInternationalString();
        demTitle.add(null, "the default dem title");
        demTitle.add(Locale.ENGLISH, "an english title");
        dem.setInternationalTitle((InternationalString)demTitle);
        catalog.save((ResourceInfo)dem);
        CoverageInfo cad = catalog.getCoverageByName(this.getLayerId(MockData.ROTATED_CAD));
        GrowableInternationalString cadTitle = new GrowableInternationalString();
        cadTitle.add(Locale.ENGLISH, "an english title");
        cad.setInternationalTitle((InternationalString)cadTitle);
        catalog.save((ResourceInfo)cad);
        WCSInfo wcs = (WCSInfo)gs.getService(WCSInfo.class);
        title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for WCS service");
        title.add(Locale.ITALIAN, "titolo italiano servizio WCS");
        _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for WCS service");
        _abstract.add(Locale.ITALIAN, "abstract italiano servizio WCS");
        wcs.setInternationalTitle((InternationalString)title);
        wcs.setInternationalAbstract((InternationalString)_abstract);
        gs.save((ServiceInfo)wcs);
        Document doc = this.getAsDOM("ows?service=WCS&request=getCapabilities&version=2.0.1&acceptLanguages=it");
        this.print(doc);
        String service = "//ows:ServiceIdentification";
        XMLAssert.assertXpathEvaluatesTo((String)"titolo italiano servizio WCS", (String)(service + "/ows:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"abstract italiano servizio WCS", (String)(service + "/ows:Abstract"), (Document)doc);
        String bmLayer = "/wcs:Capabilities/wcs:Contents/wcs:CoverageSummary[wcs:CoverageId = 'wcs__BlueMarble']";
        XMLAssert.assertXpathEvaluatesTo((String)"titolo italiano", (String)(bmLayer + "/ows:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"abstract italiano", (String)(bmLayer + "/ows:Abstract"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"parola chiave", (String)(bmLayer + "/ows:Keywords/ows:Keyword"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"the default dem title", (String)"/wcs:Capabilities/wcs:Contents/wcs:CoverageSummary[wcs:CoverageId = 'wcs__DEM']/ows:Title", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"DID NOT FIND i18n CONTENT FOR THIS ELEMENT", (String)"/wcs:Capabilities/wcs:Contents/wcs:CoverageSummary[wcs:CoverageId = 'wcs__World']/ows:Title", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"DID NOT FIND i18n CONTENT FOR THIS ELEMENT", (String)"/wcs:Capabilities/wcs:Contents/wcs:CoverageSummary[wcs:CoverageId = 'wcs__RotatedCad']/ows:Title", (Document)doc);
    }

    @Test
    public void testDefaultLocale() throws Exception {
        GeoServer gs = this.getGeoServer();
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName("BlueMarble");
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for ci bluemarble");
        title.add(Locale.ITALIAN, "titolo italiano");
        GrowableInternationalString _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for ci bluemarble");
        _abstract.add(Locale.ITALIAN, "abstract italiano");
        ci.setInternationalTitle((InternationalString)title);
        ci.setInternationalAbstract((InternationalString)_abstract);
        ci.setTitle(null);
        ci.setAbstract(null);
        catalog.save((ResourceInfo)ci);
        WCSInfo wcs = (WCSInfo)gs.getService(WCSInfo.class);
        title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for WCS service");
        title.add(Locale.ITALIAN, "titolo italiano servizio WCS");
        _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for WCS service");
        _abstract.add(Locale.ITALIAN, "abstract italiano servizio WCS");
        wcs.setInternationalTitle((InternationalString)title);
        wcs.setInternationalAbstract((InternationalString)_abstract);
        wcs.setTitle(null);
        wcs.setAbstract(null);
        wcs.setDefaultLocale(Locale.ENGLISH);
        gs.save((ServiceInfo)wcs);
        Document doc = this.getAsDOM("ows?service=WCS&request=getCapabilities&version=2.0.1");
        String service = "//ows:ServiceIdentification";
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n title for WCS service", (String)(service + "/ows:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n abstract for WCS service", (String)(service + "/ows:Abstract"), (Document)doc);
        String fifteenLayer = "/wcs:Capabilities/wcs:Contents/wcs:CoverageSummary[wcs:CoverageId = 'wcs__BlueMarble']";
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n title for ci bluemarble", (String)(fifteenLayer + "/ows:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n abstract for ci bluemarble", (String)(fifteenLayer + "/ows:Abstract"), (Document)doc);
    }

    @Test
    public void testWithoutDefaultLocale() throws Exception {
        GeoServer gs = this.getGeoServer();
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName("BlueMarble");
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.getDefault(), "a i18n title for ci bluemarble");
        GrowableInternationalString _abstract = new GrowableInternationalString();
        _abstract.add(Locale.getDefault(), "a i18n abstract for ci bluemarble");
        ci.setInternationalTitle((InternationalString)title);
        ci.setInternationalAbstract((InternationalString)_abstract);
        ci.setTitle(null);
        ci.setAbstract(null);
        catalog.save((ResourceInfo)ci);
        WCSInfo wcs = (WCSInfo)gs.getService(WCSInfo.class);
        title = new GrowableInternationalString();
        title.add(Locale.getDefault(), "a i18n title for WCS service");
        _abstract = new GrowableInternationalString();
        _abstract.add(Locale.getDefault(), "a i18n abstract for WCS service");
        wcs.setInternationalTitle((InternationalString)title);
        wcs.setInternationalAbstract((InternationalString)_abstract);
        wcs.setTitle(null);
        wcs.setAbstract(null);
        gs.save((ServiceInfo)wcs);
        Document doc = this.getAsDOM("ows?service=WCS&request=getCapabilities&version=2.0.1");
        String service = "//ows:ServiceIdentification";
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n title for WCS service", (String)(service + "/ows:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n abstract for WCS service", (String)(service + "/ows:Abstract"), (Document)doc);
        String fifteenLayer = "/wcs:Capabilities/wcs:Contents/wcs:CoverageSummary[wcs:CoverageId = 'wcs__BlueMarble']";
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n title for ci bluemarble", (String)(fifteenLayer + "/ows:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n abstract for ci bluemarble", (String)(fifteenLayer + "/ows:Abstract"), (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInternationalContentContact() throws Exception {
        ContactInfo old = this.getGeoServer().getSettings().getContact();
        try {
            GrowableInternationalString person = new GrowableInternationalString();
            person.add(Locale.ITALIAN, "I'm an italian person");
            person.add(Locale.ENGLISH, "I'm an english person");
            ContactInfoImpl contactInfo = new ContactInfoImpl();
            contactInfo.setInternationalContactPerson((InternationalString)person);
            GrowableInternationalString org = new GrowableInternationalString();
            org.add(Locale.ITALIAN, "I'm an italian organization");
            org.add(Locale.ENGLISH, "I'm an english organization");
            contactInfo.setInternationalContactOrganization((InternationalString)org);
            GrowableInternationalString email = new GrowableInternationalString();
            email.add(Locale.ITALIAN, "italian@person.it");
            email.add(Locale.ENGLISH, "english@person.com");
            contactInfo.setInternationalContactEmail((InternationalString)email);
            GrowableInternationalString position = new GrowableInternationalString();
            position.add(Locale.ITALIAN, "Cartografo");
            position.add(Locale.ENGLISH, "Cartographer");
            contactInfo.setInternationalContactPosition((InternationalString)position);
            GrowableInternationalString tel = new GrowableInternationalString();
            tel.add(Locale.ITALIAN, "0558077333");
            tel.add(Locale.ENGLISH, "02304566607");
            contactInfo.setInternationalContactVoice((InternationalString)tel);
            GrowableInternationalString fax = new GrowableInternationalString();
            fax.add(Locale.ITALIAN, "0557777333");
            fax.add(Locale.ENGLISH, "0023030948");
            contactInfo.setInternationalContactFacsimile((InternationalString)fax);
            GrowableInternationalString address = new GrowableInternationalString();
            address.add(Locale.ITALIAN, "indirizzo");
            address.add(Locale.ENGLISH, "address");
            contactInfo.setInternationalAddress((InternationalString)address);
            GrowableInternationalString addressType = new GrowableInternationalString();
            addressType.add(Locale.ITALIAN, "lavoro");
            addressType.add(Locale.ENGLISH, "work");
            contactInfo.setInternationalAddressType((InternationalString)addressType);
            GrowableInternationalString country = new GrowableInternationalString();
            country.add(Locale.ITALIAN, "Italia");
            country.add(Locale.ENGLISH, "England");
            contactInfo.setInternationalAddressCountry((InternationalString)country);
            GrowableInternationalString city = new GrowableInternationalString();
            city.add(Locale.ITALIAN, "Roma");
            city.add(Locale.ENGLISH, "London");
            contactInfo.setInternationalAddressCity((InternationalString)city);
            GrowableInternationalString postalCode = new GrowableInternationalString();
            postalCode.add(Locale.ITALIAN, "50021");
            postalCode.add(Locale.ENGLISH, "34234");
            contactInfo.setInternationalAddressPostalCode((InternationalString)postalCode);
            GeoServerInfo global = this.getGeoServer().getGlobal();
            global.getSettings().setContact((ContactInfo)contactInfo);
            this.getGeoServer().save(global);
            Document doc = this.getAsDOM("ows?service=WCS&request=getCapabilities&version=2.0.1&acceptLanguages=it");
            String service = "//ows:ServiceProvider";
            XMLAssert.assertXpathEvaluatesTo((String)"I'm an italian organization", (String)(service + "/ows:ProviderName"), (Document)doc);
            String contact = service + "/ows:ServiceContact";
            XMLAssert.assertXpathEvaluatesTo((String)"I'm an italian person", (String)(contact + "/ows:IndividualName"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"Cartografo", (String)(contact + "/ows:PositionName"), (Document)doc);
            String otherInfo = contact + "/ows:ContactInfo";
            XMLAssert.assertXpathEvaluatesTo((String)"0558077333", (String)(otherInfo + "/ows:Phone/ows:Voice"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"0557777333", (String)(otherInfo + "/ows:Phone/ows:Facsimile"), (Document)doc);
            String addressPath = otherInfo + "/ows:Address";
            XMLAssert.assertXpathEvaluatesTo((String)"indirizzo", (String)(addressPath + "/ows:DeliveryPoint"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"Roma", (String)(addressPath + "/ows:City"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"50021", (String)(addressPath + "/ows:PostalCode"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"Italia", (String)(addressPath + "/ows:Country"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"italian@person.it", (String)(addressPath + "/ows:ElectronicMailAddress"), (Document)doc);
        }
        finally {
            GeoServerInfo global = this.getGeoServer().getGlobal();
            global.getSettings().setContact(old);
            this.getGeoServer().save(global);
        }
    }
}

