/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.GeneralBounds;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class CRSExtentionTest
extends WCSTestSupport {
    @Test
    public void capabilties() throws Exception {
        File xml = new File("./src/test/resources/getcapabilities/getCap.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification[ows:Profile='http://www.opengis.net/spec/WCS_service-extension_crs/1.0/conf/crs'])", (Document)dom);
        dom = this.getAsDOM("wcs?request=Getcapabilities&service=wCS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@exceptionCode='InvalidParameterValue'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@locator='wCS'])", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reprojectTo3857XML() throws Exception {
        File xml = new File("./src/test/resources/crs/requestGetCoverageOutputCRS.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:3857", (boolean)true);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)targetCRS));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralBounds expectedEnvelope = new GeneralBounds(new double[]{1.6308305401213994E7, -5543147.203861462}, new double[]{1.6475284637403902E7, -5311971.846945147});
            expectedEnvelope.setCoordinateReferenceSystem(targetCRS);
            double scale = CRSExtentionTest.getScale((Coverage)targetCoverage);
            CRSExtentionTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralBounds)targetCoverage.getEnvelope(), scale);
            Assert.assertEquals((long)gridRange.getSpan(0), (long)360L);
            Assert.assertEquals((long)gridRange.getSpan(1), (long)360L);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCoverageSubsettingCRSFullXML() throws Exception {
        File xml = new File("./src/test/resources/crs/requestGetCoverageSubsettingCRS.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:3857", (boolean)true);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)targetCRS));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralBounds expectedEnvelope = new GeneralBounds(new double[]{1.6308305401213994E7, -5388389.272818998}, new double[]{1.636396514661063E7, -5311971.846945147});
            expectedEnvelope.setCoordinateReferenceSystem(targetCRS);
            double scale = CRSExtentionTest.getScale((Coverage)targetCoverage);
            CRSExtentionTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralBounds)targetCoverage.getEnvelope(), scale);
            Assert.assertEquals((long)gridRange.getSpan(0), (long)120L);
            Assert.assertEquals((long)gridRange.getSpan(1), (long)120L);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCoverageSubsettingTrimCRSXML() throws Exception {
        File xml = new File("./src/test/resources/crs/requestGetCoverageSubsettingTrimCRS.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:3857", (boolean)true);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)targetCRS));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralBounds expectedEnvelope = new GeneralBounds(new double[]{1.6308305401213994E7, -5543147.203861462}, new double[]{1.6475284637403902E7, -5311971.846945147});
            expectedEnvelope.setCoordinateReferenceSystem(targetCRS);
            double scale = CRSExtentionTest.getScale((Coverage)targetCoverage);
            CRSExtentionTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralBounds)targetCoverage.getEnvelope(), scale);
            Assert.assertEquals((long)gridRange.getSpan(0), (long)360L);
            Assert.assertEquals((long)gridRange.getSpan(1), (long)360L);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void subsettingNativeCRSReprojectTo3857() throws Exception {
        File xml = new File("./src/test/resources/crs/requestGetCoverageSubsettingTrimCRS2.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:3857", (boolean)true);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)targetCRS));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralBounds expectedEnvelope = new GeneralBounds(new double[]{1.6308305401213994E7, -5543147.203861462}, new double[]{1.6475284637403902E7, -5311971.846945147});
            expectedEnvelope.setCoordinateReferenceSystem(targetCRS);
            double scale = CRSExtentionTest.getScale((Coverage)targetCoverage);
            CRSExtentionTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralBounds)targetCoverage.getEnvelope(), scale);
            Assert.assertEquals((long)gridRange.getSpan(0), (long)360L);
            Assert.assertEquals((long)gridRange.getSpan(1), (long)360L);
        }
        finally {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
        }
    }
}

