/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.opengis.wcs20.ExtensionItemType;
import net.opengis.wcs20.GetCoverageType;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.kvp.GetCoverageRequestReader;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geoserver.wcs2_0.WebCoverageService20;
import org.geoserver.wcs2_0.kvp.WCS20GetCoverageRequestReader;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.referencing.CRS;
import org.geotools.wcs.v1_1.WCSConfiguration;
import org.junit.Before;

public abstract class WCSKVPTestSupport
extends WCSTestSupport {
    protected static CoordinateReferenceSystem EPSG_3857;
    protected static CoordinateReferenceSystem EPSG_4326;
    static final double EPS = 1.0E-5;
    WCSConfiguration configuration;
    GetCoverageRequestReader kvpreader;
    WebCoverageService20 service;

    protected GetCoverageType parse(String url) throws Exception {
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(KvpUtils.parseQueryString((String)url));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap(this.parseKvp((Map)rawKvp));
        WCS20GetCoverageRequestReader reader = new WCS20GetCoverageRequestReader();
        GetCoverageType gc = (GetCoverageType)reader.createRequest();
        return (GetCoverageType)reader.read((Object)gc, (Map)kvp, (Map)rawKvp);
    }

    protected Map<String, Object> getExtensionsMap(GetCoverageType gc) {
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        for (ExtensionItemType item : gc.getExtension().getContents()) {
            Object value = item.getSimpleContent() != null ? item.getSimpleContent() : item.getObjectContent();
            extensions.put(item.getNamespace() + ":" + item.getName(), value);
        }
        return extensions;
    }

    protected GridCoverage executeGetCoverage(String url) throws Exception {
        GridCoverage coverage = this.service.getCoverage(this.parse(url));
        super.scheduleForCleaning(coverage);
        return coverage;
    }

    @Override
    protected void setInputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxInputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    @Override
    protected void setOutputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxOutputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    @Before
    public void setup() {
        this.kvpreader = (GetCoverageRequestReader)applicationContext.getBean("wcs111GetCoverageRequestReader");
        this.service = (WebCoverageService20)applicationContext.getBean("wcs20ServiceTarget");
        this.configuration = new WCSConfiguration();
    }

    protected void clean(GeoTiffReader reader, GridCoverage2D ... coverages) {
        try {
            reader.dispose();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        for (GridCoverage2D coverage : coverages) {
            try {
                this.scheduleForCleaning((GridCoverage)coverage);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
    }

    static {
        try {
            EPSG_3857 = CRS.decode((String)"EPSG:3857", (boolean)true);
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to parse EPSG:3857 CRS", e);
        }
        try {
            EPSG_4326 = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to parse EPSG:4326 CRS", e);
        }
    }
}

