/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import net.opengis.wcs20.ScaleToExtentType;
import net.opengis.wcs20.TargetAxisExtentType;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.wcs2_0.kvp.ScaleExtentKvpParser;
import org.junit.Assert;
import org.junit.Test;

public class ScaleExtentKvpParserTest {
    ScaleExtentKvpParser parser = new ScaleExtentKvpParser();

    @Test
    public void testInvalidValues() throws Exception {
        try {
            this.parser.parse("axisName");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("axisName,(10,20)");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("axisName,(10,");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("axisName(10,20))");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("axisName((10,20)");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("axisName(10,20,30)");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("axisName(10,20),");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("axisName(10,20),,secondAxis(10,20)");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
    }

    @Test
    public void testSingleAxis() throws Exception {
        ScaleToExtentType se = (ScaleToExtentType)this.parser.parse("axis(10,20)");
        Assert.assertEquals((long)1L, (long)se.getTargetAxisExtent().size());
        TargetAxisExtentType tax = (TargetAxisExtentType)se.getTargetAxisExtent().get(0);
        Assert.assertEquals((Object)"axis", (Object)tax.getAxis());
        Assert.assertEquals((double)10.0, (double)tax.getLow(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)tax.getHigh(), (double)0.0);
    }

    @Test
    public void testSingleAxisSpaces() throws Exception {
        ScaleToExtentType se = (ScaleToExtentType)this.parser.parse(" axis ( 10 , 20 ) ");
        Assert.assertEquals((long)1L, (long)se.getTargetAxisExtent().size());
        TargetAxisExtentType tax = (TargetAxisExtentType)se.getTargetAxisExtent().get(0);
        Assert.assertEquals((Object)"axis", (Object)tax.getAxis());
        Assert.assertEquals((double)10.0, (double)tax.getLow(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)tax.getHigh(), (double)0.0);
    }

    @Test
    public void testMultiAxis() throws Exception {
        ScaleToExtentType se = (ScaleToExtentType)this.parser.parse("a1(10,20),a2(30,40)");
        Assert.assertEquals((long)2L, (long)se.getTargetAxisExtent().size());
        TargetAxisExtentType tax = (TargetAxisExtentType)se.getTargetAxisExtent().get(0);
        Assert.assertEquals((Object)"a1", (Object)tax.getAxis());
        Assert.assertEquals((double)10.0, (double)tax.getLow(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)tax.getHigh(), (double)0.0);
        tax = (TargetAxisExtentType)se.getTargetAxisExtent().get(1);
        Assert.assertEquals((Object)"a2", (Object)tax.getAxis());
        Assert.assertEquals((double)30.0, (double)tax.getLow(), (double)0.0);
        Assert.assertEquals((double)40.0, (double)tax.getHigh(), (double)0.0);
    }

    @Test
    public void testMultiAxisSpaces() throws Exception {
        ScaleToExtentType se = (ScaleToExtentType)this.parser.parse("a1( 10, 20)  , a2  ( 30 , 40  ) ");
        Assert.assertEquals((long)2L, (long)se.getTargetAxisExtent().size());
        TargetAxisExtentType tax = (TargetAxisExtentType)se.getTargetAxisExtent().get(0);
        Assert.assertEquals((Object)"a1", (Object)tax.getAxis());
        Assert.assertEquals((double)10.0, (double)tax.getLow(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)tax.getHigh(), (double)0.0);
        tax = (TargetAxisExtentType)se.getTargetAxisExtent().get(1);
        Assert.assertEquals((Object)"a2", (Object)tax.getAxis());
        Assert.assertEquals((double)30.0, (double)tax.getLow(), (double)0.0);
        Assert.assertEquals((double)40.0, (double)tax.getHigh(), (double)0.0);
    }

    private void checkInvalidSyntaxException(OWS20Exception e) {
        Assert.assertNotNull((Object)e.getHttpCode());
        Assert.assertEquals((long)400L, (long)e.getHttpCode().intValue());
        Assert.assertEquals((Object)"InvalidEncodingSyntax", (Object)e.getCode());
        Assert.assertEquals((Object)"scaleExtent", (Object)e.getLocator());
    }
}

