/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.util.Locale;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.vfny.geoserver.wcs.WcsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetCapabilitiesTest
extends WCSTestSupport {
    @Before
    public void cleanupLimitedSRS() {
        WCSInfo service = (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
        service.getSRS().clear();
        this.getGeoServer().save((ServiceInfo)service);
    }

    @Test
    public void testBasicKVP() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        this.checkFullCapabilitiesDocument(dom);
    }

    @Test
    public void testCase() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=wCS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@exceptionCode='InvalidParameterValue'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@locator='wCS'])", (Document)dom);
    }

    @Test
    public void testLimitedSRS() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        NodeList list = xpath.getMatchingNodes("//wcs:ServiceMetadata/wcs:Extension/crs:CrsMetadata/crs:crsSupported", dom);
        Assert.assertTrue((list.getLength() > 1000 ? 1 : 0) != 0);
        WCSInfo service = (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
        service.getSRS().add("4326");
        service.getSRS().add("32632");
        this.getGeoServer().save((ServiceInfo)service);
        dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        list = xpath.getMatchingNodes("//wcs:ServiceMetadata/wcs:Extension/crs:CrsMetadata/crs:crsSupported", dom);
        Assert.assertEquals((long)2L, (long)list.getLength());
    }

    @Test
    public void testSectionsBogus() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&sections=Bogus");
        Element root = dom.getDocumentElement();
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)root.getNodeName());
        Assert.assertEquals((Object)"2.0.0", (Object)root.getAttribute("version"));
        Assert.assertEquals((Object)"http://www.opengis.net/ows/2.0", (Object)root.getAttribute("xmlns:ows"));
        XMLAssert.assertXpathEvaluatesTo((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)"/ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    @Test
    public void testSectionsAll() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&sections=All");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceProvider)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:OperationsMetadata)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Contents)", (Document)dom);
    }

    @Test
    public void testAcceptVersions20() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&acceptversions=2.0.1");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:ExceptionReport//ows:Exception)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:ExceptionReport//ows:Exception[@exceptionCode='InvalidParameterValue'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:ExceptionReport//ows:Exception[@locator='wCS'])", (Document)dom);
    }

    @Test
    public void testAcceptVersions11() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCapabilities&service=WCS&acceptversions=1.1.0");
        Assert.assertEquals((Object)"text/xml", (Object)response.getContentType());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"<wcs:Capabilities"), CoreMatchers.containsString((String)"version=\"1.1.1\""), CoreMatchers.containsString((String)"xmlns:ows=\"http://www.opengis.net/ows/1.1\""), CoreMatchers.containsString((String)"<wcs:CoverageSummary")}));
    }

    @Test
    public void testAcceptVersions10() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCapabilities&service=WCS&acceptversions=1.0.0");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"<wcs:WCS_Capabilities"), CoreMatchers.containsString((String)"version=\"1.0.0\""), CoreMatchers.containsString((String)"xmlns:ows=\"http://www.opengis.net/ows/1.1\""), CoreMatchers.containsString((String)"<wcs:CoverageOfferingBrief")}));
    }

    @Test
    public void testMetadata() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        ci.setTitle("My Title");
        ci.setAbstract("My Abstract");
        ci.getKeywords().add(0, new Keyword("my_keyword"));
        MetadataLinkInfo mdl1 = catalog.getFactory().createMetadataLink();
        mdl1.setContent("http://www.geoserver.org/tasmania/dem.xml");
        mdl1.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(mdl1);
        MetadataLinkInfo mdl2 = catalog.getFactory().createMetadataLink();
        mdl2.setContent("/metadata?key=value");
        mdl2.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(mdl2);
        catalog.save((ResourceInfo)ci);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=GetCapabilities");
        this.checkValidationErrors(dom, GetCapabilitiesTest.getWcs20Schema());
        Object base = "//wcs:Capabilities/wcs:Contents/wcs:CoverageSummary[wcs:CoverageId = '";
        base = (String)base + this.getLayerId(MockData.TASMANIA_DEM).replace(":", "__") + "']/";
        XMLAssert.assertXpathEvaluatesTo((String)"My Title", (String)((String)base + "ows:Title"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"My Abstract", (String)((String)base + "ows:Abstract"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)("count(" + (String)base + "ows:Keywords/ows:Keyword)"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"my_keyword", (String)((String)base + "ows:Keywords/ows:Keyword[1]"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)("count(" + (String)base + "ows:Metadata)"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)((String)base + "ows:Metadata[1]/@about"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)((String)base + "ows:Metadata[1]/@xlink:type"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org/tasmania/dem.xml", (String)((String)base + "ows:Metadata[1]/@xlink:href"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)((String)base + "ows:Metadata[2]/@about"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)((String)base + "ows:Metadata[2]/@xlink:type"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"src/test/resources/geoserver/metadata?key=value", (String)((String)base + "ows:Metadata[2]/@xlink:href"), (Document)dom);
    }

    @Test
    public void testAcceptLanguagesParameter() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for fti fifteen");
        title.add(Locale.ITALIAN, "titolo italiano");
        ci.setInternationalTitle((InternationalString)title);
        GrowableInternationalString abstractInfo = new GrowableInternationalString();
        abstractInfo.add(Locale.ENGLISH, "abstract");
        abstractInfo.add(Locale.ITALIAN, "italiano abstract");
        ci.setInternationalAbstract((InternationalString)abstractInfo);
        catalog.save((ResourceInfo)ci);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=GetCapabilities&AcceptLanguages=it");
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/wcs?Language=it&", (String)"//ows:DCP/ows:HTTP/ows:Get/@xlink:href", (Document)dom);
    }

    @Test
    public void testNullLocale() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for fti fifteen");
        title.add(null, "null locale");
        ci.setInternationalTitle((InternationalString)title);
        catalog.save((ResourceInfo)ci);
        Document dom = this.getAsDOM("wcs?service=WCS&version=2.0.1&request=GetCapabilities");
        XMLAssert.assertXpathEvaluatesTo((String)"src/test/resources/geoserver/wcs?", (String)"//ows:DCP/ows:HTTP/ows:Get/@xlink:href", (Document)dom);
    }
}

