/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wcs2_0.kvp.WCSKVPTestSupport;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.GeneralBounds;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class CRSExtentionKVPTest
extends WCSKVPTestSupport {
    private static final GeneralBounds EXPECTED_ENVELOPE = new GeneralBounds(new double[]{1.6308305401213994E7, -5543147.203861462}, new double[]{1.6475284637403902E7, -5311971.846945147});

    @Test
    public void capabilties() throws Exception {
        Document dom = this.getAsDOM("wcs?reQueSt=GetCapabilities&seErvIce=WCS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification[ows:Profile='http://www.opengis.net/spec/WCS_service-extension_crs/1.0/conf/crs'])", (Document)dom);
        dom = this.getAsDOM("wcs?request=Getcapabilities&service=wCS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@exceptionCode='InvalidParameterValue'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@locator='wCS'])", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reprojectTo3857() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&OUTPUTCRS=http://www.opengis.net/def/crs/EPSG/0/3857");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)EPSG_3857));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            double scale = CRSExtentionKVPTest.getScale((Coverage)targetCoverage);
            CRSExtentionKVPTest.assertEnvelopeEquals(EXPECTED_ENVELOPE, scale, (GeneralBounds)targetCoverage.getEnvelope(), scale);
            Assert.assertEquals((long)gridRange.getSpan(0), (long)360L);
            Assert.assertEquals((long)gridRange.getSpan(1), (long)360L);
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reprojectTo3857AndScaleToFactor() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&OUTPUTCRS=http://www.opengis.net/def/crs/EPSG/0/3857&SCALEFACTOR=0.5");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)EPSG_3857));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            double scale = CRSExtentionKVPTest.getScale((Coverage)targetCoverage);
            CRSExtentionKVPTest.assertEnvelopeEquals(EXPECTED_ENVELOPE, scale, (GeneralBounds)targetCoverage.getEnvelope(), scale);
            Assert.assertEquals((long)gridRange.getSpan(0), (long)180L);
            Assert.assertEquals((long)gridRange.getSpan(1), (long)180L);
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reprojectTo3857AndScaleToSize() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&OUTPUTCRS=http://www.opengis.net/def/crs/EPSG/0/3857&SCALESIZE=http://www.opengis.net/def/axis/OGC/1/i(360),http://www.opengis.net/def/axis/OGC/1/j(180)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)EPSG_3857));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            double scale = CRSExtentionKVPTest.getScale((Coverage)targetCoverage);
            CRSExtentionKVPTest.assertEnvelopeEquals(EXPECTED_ENVELOPE, scale, (GeneralBounds)targetCoverage.getEnvelope(), scale);
            Assert.assertEquals((long)gridRange.getSpan(0), (long)360L);
            Assert.assertEquals((long)gridRange.getSpan(1), (long)180L);
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void subsettingNativeCRSReprojectTo3857() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&OUTPUTCRS=http://www.opengis.net/def/crs/EPSG/0/3857&SUBSETTINGCRS=http://www.opengis.net/def/crs/EPSG/0/4326&subset=http://www.opengis.net/def/axis/OGC/0/Long(146.5,147.0)&subset=http://www.opengis.net/def/axis/OGC/0/Lat(-43.5,-43.0)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)EPSG_3857));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            GeneralBounds expectedEnvelope = new GeneralBounds(new double[]{1.6308305401213994E7, -5388389.272818998}, new double[]{1.636396514661063E7, -5311971.846945147});
            expectedEnvelope.setCoordinateReferenceSystem(EPSG_3857);
            double scale = CRSExtentionKVPTest.getScale((Coverage)targetCoverage);
            CRSExtentionKVPTest.assertEnvelopeEquals(expectedEnvelope, scale, (GeneralBounds)targetCoverage.getEnvelope(), scale);
            Assert.assertEquals((long)gridRange.getSpan(0), (long)120L);
            Assert.assertEquals((long)gridRange.getSpan(1), (long)120L);
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRequests() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 4);
        try {
            ArrayList<Future> futures = new ArrayList<Future>();
            for (int i = 0; i < 100; ++i) {
                Future future = executor.submit(() -> {
                    this.subsettingNativeCRSReprojectTo3857();
                    return null;
                });
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void implicitReprojectionTo3857() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SUBSETTINGCRS=http://www.opengis.net/def/crs/EPSG/0/3857&subset=http://www.opengis.net/def/axis/OGC/0/X(1.6308305401213994E7,1.6475284637403902E7)&subset=http://www.opengis.net/def/axis/OGC/0/Y(-5543147.203861462,-5311971.846945147)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)EPSG_3857));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            double scale = CRSExtentionKVPTest.getScale((Coverage)targetCoverage);
            CRSExtentionKVPTest.assertEnvelopeEquals(EXPECTED_ENVELOPE, scale, (GeneralBounds)targetCoverage.getEnvelope(), scale);
            Assert.assertEquals((long)gridRange.getSpan(0), (long)360L);
            Assert.assertEquals((long)gridRange.getSpan(1), (long)360L);
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCoverageSubsettingTrimCRS() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&OUTPUTCRS=http://www.opengis.net/def/crs/EPSG/0/3857&SUBSETTINGCRS=http://www.opengis.net/def/crs/EPSG/0/3857&subset=http://www.opengis.net/def/axis/OGC/0/X(1.6308305401213994E7,1.6475284637403902E7)&subset=http://www.opengis.net/def/axis/OGC/0/Y(-5543147.203861462,-5311971.846945147)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)targetCoverage.getCoordinateReferenceSystem(), (Object)EPSG_3857));
            GridEnvelope gridRange = targetCoverage.getGridGeometry().getGridRange();
            double scale = CRSExtentionKVPTest.getScale((Coverage)targetCoverage);
            CRSExtentionKVPTest.assertEnvelopeEquals(EXPECTED_ENVELOPE, scale, (GeneralBounds)targetCoverage.getEnvelope(), scale);
            Assert.assertEquals((long)gridRange.getSpan(0), (long)360L);
            Assert.assertEquals((long)gridRange.getSpan(1), (long)360L);
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage);
    }

    static {
        EXPECTED_ENVELOPE.setCoordinateReferenceSystem(EPSG_3857);
    }
}

