/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.metadata.IIOMetadataNode;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wcs.WCSInfo;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.wcs.v2_0.WCSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.After;
import org.junit.Assert;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXY;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXParseException;

public abstract class WCSTestSupport
extends GeoServerSystemTestSupport {
    protected static XpathEngine xpath;
    protected static final boolean IS_WINDOWS;
    private static Schema WCS20_SCHEMA;
    List<GridCoverage> coverages = new ArrayList<GridCoverage>();
    protected static final String VERSION = "2.0.1";
    protected static final QName UTM11;
    protected static final QName NO_NATIVE_SRS;
    protected static final QName DATELINE_CROSS;
    static final float EPS = 1.0E-5f;

    protected static Schema getWcs20Schema() {
        if (WCS20_SCHEMA == null) {
            final Map namespaceMap = Map.ofEntries(Map.entry("http://www.opengis.net/wcs/2.0", "/schemas/wcs/2.0/"), Map.entry("http://www.opengis.net/gmlcov/1.0", "/schemas/gmlcov/1.0/"), Map.entry("http://www.opengis.net/gml/3.2", "/schemas/gml/3.2.1/"), Map.entry("http://www.w3.org/1999/xlink", "/schemas/xlink/"), Map.entry("http://www.w3.org/XML/1998/namespace", "/schemas/xml/"), Map.entry("http://www.isotc211.org/2005/gmd", "/schemas/iso/19139/20070417/gmd/"), Map.entry("http://www.isotc211.org/2005/gco", "/schemas/iso/19139/20070417/gco/"), Map.entry("http://www.isotc211.org/2005/gss", "/schemas/iso/19139/20070417/gss/"), Map.entry("http://www.isotc211.org/2005/gts", "/schemas/iso/19139/20070417/gts/"), Map.entry("http://www.isotc211.org/2005/gsr", "/schemas/iso/19139/20070417/gsr/"), Map.entry("http://www.opengis.net/swe/2.0", "/schemas/sweCommon/2.0/"), Map.entry("http://www.opengis.net/ows/2.0", "/schemas/ows/2.0/"), Map.entry("http://www.geoserver.org/wcsgs/2.0", "/schemas/wcs/2.0/"));
            try {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                factory.setResourceResolver(new LSResourceResolver(){
                    DOMImplementationLS dom;
                    {
                        try {
                            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                            builderFactory.setNamespaceAware(true);
                            DocumentBuilder builder = builderFactory.newDocumentBuilder();
                            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><empty></empty>";
                            this.dom = (DOMImplementationLS)((Object)builder.parse(new ByteArrayInputStream(xml.getBytes())).getImplementation());
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                        String localPosition = (String)namespaceMap.get(namespaceURI);
                        if (localPosition != null) {
                            try {
                                URL resource;
                                if (systemId.contains("/")) {
                                    systemId = systemId.substring(systemId.lastIndexOf("/") + 1);
                                }
                                if ((resource = WCSTestSupport.class.getResource(localPosition + "/" + systemId)) != null) {
                                    systemId = resource.toURI().toASCIIString();
                                    LSInput input = this.dom.createLSInput();
                                    input.setPublicId(publicId);
                                    input.setSystemId(systemId);
                                    return input;
                                }
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        return null;
                    }
                });
                WCS20_SCHEMA = factory.newSchema(new Source[]{new StreamSource(WCSTestSupport.class.getResource("/schemas/wcs/2.0/wcsAll.xsd").toExternalForm()), new StreamSource(WCSTestSupport.class.getResource("/schemas/wcs/2.0/wcsgs.xsd").toExternalForm())});
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse the WCS 2.0 schemas", e);
            }
        }
        return WCS20_SCHEMA;
    }

    protected WCSInfo getWCS() {
        return (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
        testData.setUpWcs10RasterLayers();
        testData.setUpWcs11RasterLayers();
        testData.setUpRasterLayer(UTM11, "/utm11-2.tiff", null, null, WCSTestSupport.class);
        testData.setUpRasterLayer(DATELINE_CROSS, "/datelinecross.tif", null, null, WCSTestSupport.class);
        testData.setupIAULayers(true, false);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        CoverageInfo usa;
        CoverageInfo dateline;
        CoverageInfo cad;
        super.onSetUp(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wcs", "http://www.opengis.net/wcs/2.0");
        namespaces.put("crs", "http://www.opengis.net/wcs/crs/1.0");
        namespaces.put("ows", "http://www.opengis.net/ows/2.0");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("int", "https://www.opengis.net/wcs/interpolation/1.0");
        namespaces.put("gmlcov", "http://www.opengis.net/gmlcov/1.0");
        namespaces.put("swe", "http://www.opengis.net/swe/2.0");
        namespaces.put("gml", "http://www.opengis.net/gml/3.2");
        namespaces.put("wcsgs", "http://www.geoserver.org/wcsgs/2.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        xpath = XMLUnit.newXpathEngine();
        CoverageInfo utm11 = this.getCatalog().getCoverageByName(this.getLayerId(UTM11));
        if (utm11 != null) {
            utm11.setNativeBoundingBox(new ReferencedEnvelope(440600.0, 471700.0, 3720700.0, 3751000.0, utm11.getNativeCRS()));
            this.getCatalog().save((ResourceInfo)utm11);
        }
        if ((cad = this.getCatalog().getCoverageByName(this.getLayerId(MockData.ROTATED_CAD))) != null) {
            cad.setNativeBoundingBox(new ReferencedEnvelope(1402800.0, 1402900.0, 5000000.0, 5000100.0, cad.getNativeCRS()));
            this.getCatalog().save((ResourceInfo)cad);
        }
        if ((dateline = this.getCatalog().getCoverageByName(this.getLayerId(DATELINE_CROSS))) != null) {
            dateline.setNativeBoundingBox(new ReferencedEnvelope(179.5, 180.0, -84.272, -82.217, dateline.getNativeCRS()));
            this.getCatalog().save((ResourceInfo)dateline);
        }
        if ((usa = this.getCatalog().getCoverageByName(this.getLayerId(MockData.USA_WORLDIMG))) != null) {
            usa.setSRS("EPSG:3857");
            usa.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
            this.getCatalog().save((ResourceInfo)usa);
        }
    }

    protected boolean isMemoryCleanRequired() {
        return IS_WINDOWS;
    }

    protected void checkValidationErrors(Document dom) throws Exception {
        Parser p = new Parser((Configuration)new WCSConfiguration());
        p.setValidating(true);
        p.parse((Source)new DOMSource(dom));
        if (!p.getValidationErrors().isEmpty()) {
            for (Exception exception : p.getValidationErrors()) {
                SAXParseException ex = (SAXParseException)exception;
                LOGGER.warning(ex.getLineNumber() + "," + ex.getColumnNumber() + " -" + ex.toString());
            }
            Assert.fail((String)"Document did not validate.");
        }
    }

    protected void scheduleForCleaning(GridCoverage coverage) {
        if (coverage != null) {
            this.coverages.add(coverage);
        }
    }

    @After
    public void cleanCoverages() {
        for (GridCoverage coverage : this.coverages) {
            if (coverage == null) continue;
            CoverageCleanerCallback.disposeCoverage((GridCoverage)coverage);
        }
    }

    protected void checkFullCapabilitiesDocument(Document dom) throws Exception {
        this.checkValidationErrors(dom, WCSTestSupport.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification[ows:Profile='http://www.opengis.net/spec/WCS_service-extension_crs/1.0/conf/crs'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:ServiceMetadata/wcs:Extension/crs:CrsMetadata[crs:crsSupported = 'http://www.opengis.net/def/crs/EPSG/0/4326'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification[ows:Profile='http://www.opengis.net/spec/WCS_service-extension_interpolation/1.0/conf/interpolation'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:ServiceMetadata/wcs:Extension/int:InterpolationMetadata[int:InterpolationSupported='http://www.opengis.net/def/interpolation/OGC/1/nearest-neighbor'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:ServiceMetadata/wcs:Extension/int:InterpolationMetadata[int:InterpolationSupported='http://www.opengis.net/def/interpolation/OGC/1/linear'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:ServiceMetadata/wcs:Extension/int:InterpolationMetadata[int:InterpolationSupported='http://www.opengis.net/def/interpolation/OGC/1/cubic'])", (Document)dom);
        String utm11Bbox = "//wcs:Contents/wcs:CoverageSummary[wcs:CoverageId='wcs__utm11']/ows:BoundingBox";
        WCSTestSupport.assertXpathCoordinate((Coordinate)new CoordinateXY(440562.0, 3720758.0), (String)(utm11Bbox + "/ows:LowerCorner"), (Document)dom);
        WCSTestSupport.assertXpathCoordinate((Coordinate)new CoordinateXY(471794.0, 3750966.0), (String)(utm11Bbox + "/ows:UpperCorner"), (Document)dom);
        String cadPath = "//wcs:Contents/wcs:CoverageSummary[wcs:CoverageId='wcs__RotatedCad']/ows:BoundingBox";
        WCSTestSupport.assertXpathCoordinate((Coordinate)new CoordinateXY(1402800.0, 5000000.0), (String)(cadPath + "/ows:LowerCorner"), (Document)dom);
        WCSTestSupport.assertXpathCoordinate((Coordinate)new CoordinateXY(1402900.0, 5000100.0), (String)(cadPath + "/ows:UpperCorner"), (Document)dom);
        String usaPath = "//wcs:Contents/wcs:CoverageSummary[wcs:CoverageId='cdf__usa']/ows:BoundingBox";
        WCSTestSupport.assertXpathCoordinate((Coordinate)new CoordinateXY(-1.457024062347863E7, 6199732.713729635), (String)(usaPath + "/ows:LowerCorner"), (Document)dom);
        WCSTestSupport.assertXpathCoordinate((Coordinate)new CoordinateXY(-1.3790593336628266E7, 7197101.83024677), (String)(usaPath + "/ows:UpperCorner"), (Document)dom);
        WCSTestSupport.assertCRSReference(dom, "EPSG", "4326");
        WCSTestSupport.assertCRSReference(dom, "EPSG", "32632");
        WCSTestSupport.assertCRSReference(dom, "EPSG", "900913");
        WCSTestSupport.assertCRSReference(dom, "EPSG", "404000");
        WCSTestSupport.assertCRSReference(dom, "IAU", "1000");
        Set<String> supportedCodes = WCSTestSupport.getCodes("EPSG");
        supportedCodes.addAll(WCSTestSupport.getCodes("IAU"));
        NodeList allCrsCodes = xpath.getMatchingNodes("//crs:crsSupported", dom);
        Assert.assertEquals((long)supportedCodes.size(), (long)allCrsCodes.getLength());
        String vikingPath = "//wcs:Contents/wcs:CoverageSummary[wcs:CoverageId='iau__Viking']";
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.opengis.net/def/crs/IAU/0/49900", (String)(vikingPath + "/ows:BoundingBox/@crs"), (Document)dom);
    }

    private static Set<String> getCodes(String authority) {
        return CRS.getSupportedCodes((String)authority).stream().filter(c -> !"WGS84(DD)".equals(c)).map(c -> "http://www.opengis.net/def/crs/" + authority + "/0/" + c).collect(Collectors.toSet());
    }

    private static void assertCRSReference(Document dom, String authority, String code) throws XpathException {
        XMLAssert.assertXpathExists((String)("//crs:crsSupported[text()='http://www.opengis.net/def/crs/" + authority + "/0/" + code + "']"), (Document)dom);
    }

    protected IIOMetadataNode getTiffField(Node rootNode, int tag) {
        Node node = rootNode.getFirstChild();
        if (node != null) {
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                Node number = node.getAttributes().getNamedItem("number");
                if (number == null || tag != Integer.parseInt(number.getNodeValue())) continue;
                return (IIOMetadataNode)node;
            }
        }
        return null;
    }

    protected void setInputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxInputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    protected void setOutputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxOutputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    protected static void assertEnvelopeEquals(Coverage expected, Coverage actual) {
        double scaleA = WCSTestSupport.getScale(expected);
        double scaleB = WCSTestSupport.getScale(actual);
        WCSTestSupport.assertEnvelopeEquals((GeneralBounds)expected.getEnvelope(), scaleA, (GeneralBounds)actual.getEnvelope(), scaleB);
    }

    protected static void assertEnvelopeEquals(GeneralBounds expected, double scaleExpected, GeneralBounds actual, double scaleActual) {
        double tolerance = scaleExpected <= scaleActual ? scaleExpected * 0.1 : (!Double.isNaN(scaleActual) ? scaleActual * 0.1 : (double)1.0E-5f);
        Assert.assertTrue((String)("The 2 envelopes aren't equal, expected " + expected + " but got " + actual), (boolean)expected.equals((Bounds)actual, tolerance, false));
    }

    protected static AffineTransform getAffineTransform(Coverage coverage) {
        MathTransform gridToCRS;
        GridGeometry geometry;
        if (coverage instanceof GridCoverage && (geometry = ((GridCoverage)coverage).getGridGeometry()) != null && (gridToCRS = geometry instanceof GridGeometry2D ? geometry.getGridToCRS() : geometry.getGridToCRS()) instanceof AffineTransform) {
            return (AffineTransform)gridToCRS;
        }
        return null;
    }

    protected static double getScale(Coverage coverage) {
        AffineTransform gridToCRS = WCSTestSupport.getAffineTransform(coverage);
        return gridToCRS != null ? XAffineTransform.getScale((AffineTransform)gridToCRS) : Double.NaN;
    }

    protected Multipart getMultipart(MockHttpServletResponse response) throws MessagingException, IOException {
        MimeMessage body = new MimeMessage(null, (InputStream)this.getBinaryInputStream(response));
        Multipart multipart = (Multipart)body.getContent();
        return multipart;
    }

    protected void setupRasterDimension(String coverageName, String metadataKey, DimensionPresentation presentation, Double resolution) {
        CoverageInfo info = this.getCatalog().getCoverageByName(coverageName);
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(presentation);
        if (resolution != null) {
            di.setResolution(BigDecimal.valueOf(resolution));
        }
        info.getMetadata().put(metadataKey, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void setupRasterDimension(String coverageName, String metadataKey, DimensionPresentation presentation, Double resolution, String unitSymbol) {
        CoverageInfo info = this.getCatalog().getCoverageByName(coverageName);
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(presentation);
        if (resolution != null) {
            di.setResolution(BigDecimal.valueOf(resolution));
        }
        if (unitSymbol != null) {
            di.setUnitSymbol(unitSymbol);
        }
        info.getMetadata().put(metadataKey, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void clearDimensions(String coverageName) {
        CoverageInfo info = this.getCatalog().getCoverageByName(coverageName);
        info.getMetadata().remove((Object)"time");
        info.getMetadata().remove((Object)"elevation");
        this.getCatalog().save((ResourceInfo)info);
    }

    static {
        UTM11 = new QName(MockData.WCS_URI, "utm11", MockData.WCS_PREFIX);
        NO_NATIVE_SRS = new QName(MockData.WCS_URI, "no_native_srs", MockData.WCS_PREFIX);
        DATELINE_CROSS = new QName(MockData.WCS_URI, "dateline_cross", MockData.WCS_PREFIX);
        boolean windows = false;
        try {
            windows = System.getProperty("os.name").matches(".*Windows.*");
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_WINDOWS = windows;
    }
}

