/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import org.geoserver.wcs2_0.WCSEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.GeneralBounds;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;

public class WCSEnvelopeTest {
    @Test
    public void testDatelineCrossing() {
        WCSEnvelope env = new WCSEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        env.setRange(0, 150.0, 210.0);
        env.setRange(1, -10.0, 10.0);
        GeneralBounds[] envelopes = env.getNormalizedEnvelopes();
        Assert.assertEquals((long)2L, (long)envelopes.length);
        Assert.assertEquals((Object)WCSEnvelopeTest.newGeneralEnvelope(150, -10, 180, 10), (Object)envelopes[0]);
        Assert.assertEquals((Object)WCSEnvelopeTest.newGeneralEnvelope(-180, -10, -150, 10), (Object)envelopes[1]);
        env.intersect(WCSEnvelopeTest.newGeneralEnvelope(160, -20, 180, 20));
        Assert.assertEquals((Object)WCSEnvelopeTest.newGeneralEnvelope(160, -10, 180, 10), (Object)new GeneralBounds((Bounds)env));
    }

    @Test
    public void testMoreThanWorldWest() {
        WCSEnvelope env = new WCSEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        env.setRange(0, -200.0, 165.0);
        env.setRange(1, -10.0, 10.0);
        GeneralBounds[] envelopes = env.getNormalizedEnvelopes();
        Assert.assertEquals((long)1L, (long)envelopes.length);
        Assert.assertEquals((Object)WCSEnvelopeTest.newGeneralEnvelope(-180, -10, 180, 10), (Object)envelopes[0]);
        env.intersect(WCSEnvelopeTest.newGeneralEnvelope(160, -20, 180, 20));
        Assert.assertEquals((Object)WCSEnvelopeTest.newGeneralEnvelope(160, -10, 180, 10), (Object)new GeneralBounds((Bounds)env));
    }

    @Test
    public void testMoreThanWorldEast() {
        WCSEnvelope env = new WCSEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        env.setRange(0, -160.0, 240.0);
        env.setRange(1, -10.0, 10.0);
        GeneralBounds[] envelopes = env.getNormalizedEnvelopes();
        Assert.assertEquals((long)1L, (long)envelopes.length);
        Assert.assertEquals((Object)WCSEnvelopeTest.newGeneralEnvelope(-180, -10, 180, 10), (Object)envelopes[0]);
        env.intersect(WCSEnvelopeTest.newGeneralEnvelope(160, -20, 180, 20));
        Assert.assertEquals((Object)WCSEnvelopeTest.newGeneralEnvelope(160, -10, 180, 10), (Object)new GeneralBounds((Bounds)env));
    }

    private static GeneralBounds newGeneralEnvelope(int minLon, int minLat, int maxLon, int maxLat) {
        GeneralBounds expected = new GeneralBounds(new double[]{minLon, minLat}, new double[]{maxLon, maxLat});
        expected.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        return expected;
    }
}

