/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wcs20.GetCoverageType;
import net.opengis.wcs20.ScalingType;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.responses.GeoTIFFCoverageResponseDelegate;
import org.geoserver.wcs2_0.GetCoverage;
import org.geoserver.wcs2_0.GridCoverageRequest;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.kvp.WCS20GetCoverageRequestReader;
import org.geoserver.wcs2_0.response.MIMETypeMapper;
import org.geoserver.wcs2_0.util.EnvelopeAxesLabelsMapper;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetCoverageTest
extends WCSTestSupport {
    private static final QName RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);
    private static final QName TIMESERIES = new QName(MockData.SF_URI, "timeseries", MockData.SF_PREFIX);
    public static QName NO_ENVELOPE_SRS = new QName(MockData.WCS_URI, "NoEnvelopeSRS", MockData.WCS_PREFIX);
    private GridCoverage2DReader coverageReader;
    private AffineTransform2D originalMathTransform;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        testData.addRasterLayer(RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addRasterLayer(TIMESERIES, "timeseries.zip", null, this.getCatalog());
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
        testData.addRasterLayer(NO_ENVELOPE_SRS, "/world.tiff", null, null, GetCoverageTest.class, this.getCatalog());
        CoverageInfo noEnvelopeSRS = this.getCatalog().getCoverageByName(this.getLayerId(NO_ENVELOPE_SRS));
        ReferencedEnvelope bbox = noEnvelopeSRS.getNativeBoundingBox();
        noEnvelopeSRS.setNativeBoundingBox(ReferencedEnvelope.create((Bounds)bbox, null));
        noEnvelopeSRS.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        this.getCatalog().save((ResourceInfo)noEnvelopeSRS);
    }

    @Before
    public void getRainReader() throws IOException {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(RAIN));
        this.coverageReader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        this.originalMathTransform = (AffineTransform2D)this.coverageReader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
    }

    @Test
    public void testAllowSubsamplingOnScaleFactor() throws Exception {
        Map<String, Object> raw = this.setupGetCoverageRain();
        raw.put("scalefactor", "0.5");
        this.assertScalingByHalf(raw);
    }

    @Test
    public void testAllowSubsamplingOnScaleExtent() throws Exception {
        GridEnvelope range = this.coverageReader.getOriginalGridRange();
        int width = range.getSpan(0);
        int height = range.getSpan(1);
        Map<String, Object> raw = this.setupGetCoverageRain();
        raw.put("scaleextent", "i(0," + width / 2 + "),j(0," + height / 2 + ")");
        this.assertScalingByHalf(raw);
    }

    @Test
    public void getNearestTime() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(TIMESERIES));
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=timeseries&subset=time(\"2019-01-03T00:00:00Z\")");
        this.coverageReader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        WCSInfo service = (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
        EnvelopeAxesLabelsMapper axesMapper = (EnvelopeAxesLabelsMapper)GeoServerExtensions.bean(EnvelopeAxesLabelsMapper.class);
        MIMETypeMapper mimeMapper = (MIMETypeMapper)GeoServerExtensions.bean(MIMETypeMapper.class);
        GetCoverage getCoverage = new GetCoverage(service, this.getCatalog(), axesMapper, mimeMapper);
        boolean hasCoverage = true;
        GridCoverage gridCoverage = null;
        try {
            gridCoverage = getCoverage.run(gc);
        }
        catch (WCS20Exception e) {
            hasCoverage = false;
            Assert.assertTrue((boolean)e.getMessage().contains("Requested time subset does not intersect"));
            Assert.assertEquals((long)404L, (long)e.getHttpCode().intValue());
        }
        Assert.assertFalse((boolean)hasCoverage);
        this.setupNearestMatch(TIMESERIES, "time", true, "P5D", true);
        getCoverage = new GetCoverage(service, this.getCatalog(), axesMapper, mimeMapper);
        try {
            gridCoverage = getCoverage.run(gc);
            hasCoverage = true;
        }
        catch (WCS20Exception e) {
            hasCoverage = false;
        }
        Assert.assertNotNull((Object)gridCoverage);
        Assert.assertTrue((boolean)hasCoverage);
        this.scheduleForCleaning(gridCoverage);
    }

    @Test
    public void testDeflateCompressionLevel() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(TIMESERIES));
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=timeseries&subset=time(\"2018-01-01T00:00:00Z\")&format=image/tiff&geotiff:compression=DEFLATE");
        this.coverageReader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        GeoServer geoserver = this.getGeoServer();
        WCSInfo service = (WCSInfo)geoserver.getService(WCSInfo.class);
        service.setDefaultDeflateCompressionLevel(9);
        geoserver.save((ServiceInfo)service);
        EnvelopeAxesLabelsMapper axesMapper = (EnvelopeAxesLabelsMapper)GeoServerExtensions.bean(EnvelopeAxesLabelsMapper.class);
        MIMETypeMapper mimeMapper = (MIMETypeMapper)GeoServerExtensions.bean(MIMETypeMapper.class);
        GetCoverage getCoverage = new GetCoverage(service, this.getCatalog(), axesMapper, mimeMapper);
        GridCoverage gridCoverage = getCoverage.run(gc);
        GeoTIFFCoverageResponseDelegate delegate = new GeoTIFFCoverageResponseDelegate(this.getGeoServer());
        long small = this.getEncodingLength(delegate, gridCoverage);
        service = (WCSInfo)geoserver.getService(WCSInfo.class);
        service.setDefaultDeflateCompressionLevel(1);
        geoserver.save((ServiceInfo)service);
        long big = this.getEncodingLength(delegate, gridCoverage);
        Assert.assertTrue((big > small ? 1 : 0) != 0);
        this.scheduleForCleaning(gridCoverage);
    }

    private long getEncodingLength(GeoTIFFCoverageResponseDelegate delegate, GridCoverage gridCoverage) throws IOException {
        File file = File.createTempFile("wcs", "deflate.tif");
        file.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(file);){
            delegate.encode((GridCoverage2D)gridCoverage, "image/tiff", Collections.singletonMap("compression", "DEFLATE"), (OutputStream)fos);
            long l = file.length();
            return l;
        }
    }

    protected GetCoverageType parse(String url) throws Exception {
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(KvpUtils.parseQueryString((String)url));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap(this.parseKvp((Map)rawKvp));
        WCS20GetCoverageRequestReader reader = new WCS20GetCoverageRequestReader();
        GetCoverageType gc = (GetCoverageType)reader.createRequest();
        return (GetCoverageType)reader.read((Object)gc, (Map)kvp, (Map)rawKvp);
    }

    private void assertScalingByHalf(Map<String, Object> raw) throws Exception {
        Map kvp = this.parseKvp(raw);
        WCS20GetCoverageRequestReader reader = new WCS20GetCoverageRequestReader();
        GetCoverageType getCoverageRequest = (GetCoverageType)reader.read(reader.createRequest(), kvp, raw);
        WCSInfo service = (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
        EnvelopeAxesLabelsMapper axesMapper = (EnvelopeAxesLabelsMapper)GeoServerExtensions.bean(EnvelopeAxesLabelsMapper.class);
        MIMETypeMapper mimeMapper = (MIMETypeMapper)GeoServerExtensions.bean(MIMETypeMapper.class);
        GetCoverage getCoverage = new GetCoverage(service, this.getCatalog(), axesMapper, mimeMapper){

            MathTransform getMathTransform(CoverageInfo ci, GridCoverage2DReader reader, Bounds subset, GridCoverageRequest request, PixelInCell pixelInCell, ScalingType scaling) throws IOException {
                MathTransform mt = super.getMathTransform(ci, reader, subset, request, pixelInCell, scaling);
                AffineTransform2D actual = (AffineTransform2D)mt;
                Assert.assertEquals((double)0.5, (double)(GetCoverageTest.this.originalMathTransform.getScaleX() / actual.getScaleX()), (double)1.0E-6);
                Assert.assertEquals((double)0.5, (double)(GetCoverageTest.this.originalMathTransform.getScaleY() / actual.getScaleY()), (double)1.0E-6);
                return mt;
            }
        };
        GridCoverage result = getCoverage.run(getCoverageRequest);
        this.scheduleForCleaning(result);
    }

    private Map<String, Object> setupGetCoverageRain() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("service", "WCS");
        raw.put("request", "GetCoverage");
        raw.put("version", "2.0.1");
        raw.put("coverageId", "sf__rain");
        raw.put("format", "image/tiff");
        return raw;
    }

    @Test
    public void testInvalidTimeSpecification() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=timeseries&subset=time(\"2018-01-1T00:00:00Z\")");
        String error = this.checkOws20Exception(response, 400, "InvalidEncodingSyntax", "subset");
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.containsString((String)"Invalid time subset"));
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.containsString((String)"2018-01-1T00:00:00Z"));
    }

    @Test
    public void testInvalidLongSpecification() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=timeseries&subset=Long(abc)");
        String error = this.checkOws20Exception(response, 400, "InvalidEncodingSyntax", "subset");
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.containsString((String)"Invalid point value"));
        MatcherAssert.assertThat((Object)error, (Matcher)CoreMatchers.containsString((String)"abc"));
    }

    @Test
    public void testNoEnvelopeSRS() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(NO_ENVELOPE_SRS));
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=NoEnvelopeSRS&format=image/tiff");
        this.coverageReader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        WCSInfo service = (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
        EnvelopeAxesLabelsMapper axesMapper = (EnvelopeAxesLabelsMapper)GeoServerExtensions.bean(EnvelopeAxesLabelsMapper.class);
        MIMETypeMapper mimeMapper = (MIMETypeMapper)GeoServerExtensions.bean(MIMETypeMapper.class);
        GetCoverage getCoverage = new GetCoverage(service, this.getCatalog(), axesMapper, mimeMapper);
        boolean hasCoverage = true;
        GridCoverage gridCoverage = null;
        try {
            gridCoverage = getCoverage.run(gc);
        }
        catch (WCS20Exception e) {
            hasCoverage = false;
            Assert.assertEquals((long)404L, (long)e.getHttpCode().intValue());
        }
        Assert.assertNotNull((Object)gridCoverage);
        Assert.assertTrue((boolean)hasCoverage);
        this.scheduleForCleaning(gridCoverage);
    }
}

