/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import java.io.File;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class DescribeCoverageTest
extends WCSTestSupport {
    public static QName WORLD = new QName(MockData.CITE_URI, "world", MockData.CITE_PREFIX);

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        HashMap<SystemTestData.LayerProperty, ReferencedEnvelope> props = new HashMap<SystemTestData.LayerProperty, ReferencedEnvelope>();
        props.put(SystemTestData.LayerProperty.ENVELOPE, new ReferencedEnvelope(180.0, -180.0, 90.0, -90.0, null));
        testData.setUpRasterLayer(WORLD, "/world.tiff", null, null, WCSTestSupport.class);
    }

    @Test
    public void testNativeBoundsMissingSRS() throws Exception {
        File xml = new File("./src/test/resources/testDescribeCoverageNativeBoundsMissingSRS.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"cite__world", (String)"//wcs:CoverageDescription//wcs:CoverageId", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"//wcs:CoverageDescription//gml:boundedBy//gml:Envelope/@srsDimension", (Document)dom);
    }

    @Test
    public void testEntityExpansion() throws Exception {
        File xml = new File("./src/test/resources/testDescribeCoverageEntityExpansion.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        Assert.assertNotNull((Object)dom);
        String text = xpath.evaluate("//ows:ExceptionText", dom);
        Assert.assertTrue((boolean)text.contains("Entity resolution disallowed for "));
    }

    @Test
    public void testDescribeCoverageSimple() throws Exception {
        File xml = new File("./src/test/resources/testDescribeCoverage.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"wcs__BlueMarble", (String)"//wcs:CoverageDescription//wcs:CoverageId", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wcs:CoverageDescription//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-43.0020833333312 146.5020833333281", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//gml:domainSet//gml:RectifiedGrid//gml:origin//gml:Point//gml:pos", (Document)dom);
    }

    @Test
    public void testDescribeCoverageMultiband() throws Exception {
        File xml = new File("./src/test/resources/testDescribeCoverageMultiBand.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"wcs__multiband", (String)"//wcs:CoverageDescription//wcs:CoverageId", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"9", (String)"count(//wcs:CoverageDescription//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }
}

