/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geotools.util.MapEntry;
import org.geotools.util.logging.Logging;

public class NCNameResourceCodec {
    protected static Logger LOGGER = Logging.getLogger(NCNameResourceCodec.class);
    private static final String DELIMITER = "__";

    public static String encode(ResourceInfo resource) {
        return NCNameResourceCodec.encode(resource.getNamespace().getPrefix(), resource.getName());
    }

    public static String encode(String workspaceName, String resourceName) {
        return workspaceName + DELIMITER + resourceName;
    }

    public static LayerInfo getCoverage(Catalog catalog, String encodedCoverageId) throws WCS20Exception {
        List<LayerInfo> layers = NCNameResourceCodec.getLayers(catalog, encodedCoverageId);
        if (layers == null) {
            return null;
        }
        LayerInfo ret = null;
        for (LayerInfo layer : layers) {
            if (layer == null || layer.getType() != PublishedType.RASTER) continue;
            if (ret == null) {
                ret = layer;
                continue;
            }
            LOGGER.warning("Multiple coverages found for NSName '" + encodedCoverageId + "': " + ret.prefixedName() + " is selected, " + layer.prefixedName() + " will be ignored");
        }
        return ret;
    }

    public static List<LayerInfo> getLayers(Catalog catalog, String encodedResourceId) {
        List<MapEntry<String, String>> decodedList = NCNameResourceCodec.decode(encodedResourceId);
        if (decodedList.isEmpty()) {
            LOGGER.info("Could not decode id '" + encodedResourceId + "'");
            return null;
        }
        ArrayList<LayerInfo> ret = new ArrayList<LayerInfo>();
        LOGGER.info(" Examining encoded name " + encodedResourceId);
        for (MapEntry<String, String> mapEntry : decodedList) {
            String namespace = (String)mapEntry.getKey();
            String covName = (String)mapEntry.getValue();
            if (namespace == null || namespace.isEmpty()) {
                LOGGER.info(" Checking coverage name " + covName);
                LayerInfo layer = catalog.getLayerByName(covName);
                if (layer != null) {
                    LOGGER.info(" - Collecting layer " + layer.prefixedName());
                    ret.add(layer);
                    continue;
                }
                LOGGER.info(" - Ignoring layer " + covName);
                continue;
            }
            LOGGER.info(" Checking pair " + namespace + " : " + covName);
            String fullName = namespace + ":" + covName;
            NamespaceInfo nsInfo = catalog.getNamespaceByPrefix(namespace);
            if (nsInfo != null) {
                LOGGER.info(" - Namespace found " + namespace);
                LayerInfo layer = catalog.getLayerByName(fullName);
                if (layer != null) {
                    LOGGER.info(" - Collecting layer " + layer.prefixedName());
                    ret.add(layer);
                    continue;
                }
                LOGGER.info(" - Ignoring layer " + fullName);
                continue;
            }
            LOGGER.info(" - Namespace not found " + namespace);
        }
        return ret;
    }

    public static List<MapEntry<String, String>> decode(String qualifiedName) {
        int lastPos = qualifiedName.lastIndexOf(DELIMITER);
        ArrayList<MapEntry<String, String>> ret = new ArrayList<MapEntry<String, String>>();
        if (lastPos == -1) {
            ret.add((MapEntry<String, String>)new MapEntry(null, (Object)qualifiedName));
            return ret;
        }
        while (lastPos > -1) {
            String ws = qualifiedName.substring(0, lastPos);
            String name = qualifiedName.substring(lastPos + DELIMITER.length());
            ret.add((MapEntry<String, String>)new MapEntry((Object)ws, (Object)name));
            lastPos = qualifiedName.lastIndexOf(DELIMITER, lastPos - 1);
        }
        return ret;
    }
}

