/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import net.opengis.wcs20.DimensionSliceType;
import net.opengis.wcs20.DimensionSubsetType;
import net.opengis.wcs20.DimensionTrimType;
import net.opengis.wcs20.Wcs20Factory;
import org.geoserver.ows.KvpParser;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.wcs2_0.exception.WCS20Exception;

public class SubsetKvpParser
extends KvpParser {
    private final String intervalSeparator;

    public SubsetKvpParser() {
        this(",");
    }

    public SubsetKvpParser(String intervalSeparator) {
        super("subset", DimensionSubsetType.class);
        this.intervalSeparator = intervalSeparator;
    }

    public DimensionSubsetType parse(String value) {
        value = value.trim();
        int openIdx = value.indexOf("(");
        int closeIdx = value.indexOf(")");
        if (openIdx == -1 || closeIdx == -1 || closeIdx < value.length() - 1) {
            throw new OWS20Exception("Invalid syntax, dimension [ , crs ] ( intervalOrPoint ) is expected", (OWS20Exception.OWSExceptionCode)WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "subset");
        }
        String dimension = null;
        String crs = null;
        String dimensionCrs = value.substring(0, openIdx);
        String[] dcElements = dimensionCrs.split("\\s*,\\s*");
        if (dcElements.length == 1) {
            dimension = dcElements[0];
            crs = null;
        } else if (dcElements.length == 2) {
            dimension = dcElements[0];
            crs = dcElements[1];
        } else {
            throw new OWS20Exception("Invalid syntax, dimension [ , crs ] ( intervalOrPoint ) is expected", (OWS20Exception.OWSExceptionCode)WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "subset");
        }
        String valuePoint = value.substring(openIdx + 1, closeIdx);
        String[] vpElements = valuePoint.split(this.intervalSeparator + "\\s*(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
        if (vpElements.length == 1) {
            String point = this.parsePoint(vpElements[0], false);
            DimensionSliceType slice = Wcs20Factory.eINSTANCE.createDimensionSliceType();
            slice.setDimension(dimension);
            slice.setCRS(crs);
            slice.setSlicePoint(point);
            return slice;
        }
        if (vpElements.length == 2) {
            String low = this.parsePoint(vpElements[0], true);
            String high = this.parsePoint(vpElements[1], true);
            DimensionTrimType trim = Wcs20Factory.eINSTANCE.createDimensionTrimType();
            trim.setDimension(dimension);
            trim.setCRS(crs);
            trim.setTrimLow(low);
            trim.setTrimHigh(high);
            return trim;
        }
        throw new OWS20Exception("Invalid syntax, dimension [ , crs ] ( intervalOrPoint ) where interval or point has either 1 or two elements", (OWS20Exception.OWSExceptionCode)WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "subset");
    }

    private String parsePoint(String point, boolean allowStar) {
        if ("*".equals(point = point.trim())) {
            if (allowStar) {
                return null;
            }
            throw new OWS20Exception("Invalid usage of *, it can be used only when specifying an interval", (OWS20Exception.OWSExceptionCode)WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "subset");
        }
        if (point.startsWith("\"") && point.endsWith("\"")) {
            point = point.substring(1, point.length() - 1);
        } else {
            try {
                Double.parseDouble(point);
            }
            catch (NumberFormatException e) {
                throw new OWS20Exception("Invalid point value " + point + ", it is not a number and it's not between double quotes", (OWS20Exception.OWSExceptionCode)WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "subset");
            }
        }
        return point;
    }
}

