/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.util.List;
import org.geoserver.wcs.WCSCoverageClipCallback;
import org.geoserver.wcs2_0.response.GranuleStack;
import org.geoserver.wcs2_0.response.GranuleStackImpl;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.locationtech.jts.geom.Geometry;
import org.vfny.geoserver.util.WCSUtils;

public class GranuleStackClipCallback
extends WCSCoverageClipCallback {
    protected boolean acceptResult(Object result) {
        return result instanceof GranuleStack;
    }

    protected GridCoverage performClip(GridCoverage coverage, Geometry clip) {
        GranuleStackImpl stack = (GranuleStackImpl)coverage;
        GranuleStackImpl croppedStack = new GranuleStackImpl((CharSequence)stack.getName(), stack.getCoordinateReferenceSystem(), stack.getDimensions());
        List<GridCoverage2D> granules = stack.getGranules();
        for (GridCoverage2D granule : granules) {
            GridCoverage2D cropped = WCSUtils.crop((GridCoverage2D)granule, (Geometry)clip);
            if (cropped == null) continue;
            croppedStack.addCoverage(cropped);
        }
        return croppedStack;
    }
}

