/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.kvp.WCSKVPTestSupport;
import org.geotools.api.coverage.Coverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

@RunWith(value=Parameterized.class)
public class ScaleKvpTest
extends WCSKVPTestSupport {
    private String axisPrefix;
    private String subsetPrefix;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"", ""}, {"http://www.opengis.net/def/axis/OGC/1/", "http://www.opengis.net/def/axis/OGC/0/"});
    }

    public ScaleKvpTest(String axisPrefix, String subsetPrefix) {
        this.axisPrefix = axisPrefix;
        this.subsetPrefix = subsetPrefix;
    }

    @Test
    public void capabilities() throws Exception {
        File xml = new File("./src/test/resources/getcapabilities/getCap.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification[ows:Profile='http://www.opengis.net/spec/WCS_service-extension_range-subsetting/1.0/conf/record-subsetting'])", (Document)dom);
        dom = this.getAsDOM("wcs?request=Getcapabilities&service=wCS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@exceptionCode='InvalidParameterValue'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@locator='wCS'])", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scaleFactor() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEFACTOR=0.5");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            Assert.assertEquals((long)(sourceCoverage.getGridGeometry().getGridRange().getSpan(0) / 2), (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)(sourceCoverage.getGridGeometry().getGridRange().getSpan(1) / 2), (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEFACTOR=2");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        tiffContents = this.getBinary(response);
        file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        readerTarget = new GeoTiffReader((Object)file);
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            Assert.assertEquals((long)(sourceCoverage.getGridGeometry().getGridRange().getSpan(0) * 2), (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)(sourceCoverage.getGridGeometry().getGridRange().getSpan(1) * 2), (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEFACTOR=0");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor.getExceptionCode(), "0.0");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEFACTOR=-12");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor.getExceptionCode(), "-12.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scaleAxesByFactor() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEAXES=" + this.axisPrefix + "i(0.5)," + this.axisPrefix + "j(0.5)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            Assert.assertEquals((long)(sourceCoverage.getGridGeometry().getGridRange().getSpan(0) / 2), (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)(sourceCoverage.getGridGeometry().getGridRange().getSpan(1) / 2), (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEAXES=" + this.axisPrefix + "i(2)," + this.axisPrefix + "j(2)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        tiffContents = this.getBinary(response);
        file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        readerTarget = new GeoTiffReader((Object)file);
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            Assert.assertEquals((long)(sourceCoverage.getGridGeometry().getGridRange().getSpan(0) * 2), (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)(sourceCoverage.getGridGeometry().getGridRange().getSpan(1) * 2), (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEAXES=" + this.axisPrefix + "i(0)," + this.axisPrefix + "j(0.5)");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor.getExceptionCode(), "0.0");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEAXES=" + this.axisPrefix + "i(-1)," + this.axisPrefix + "j(0.5)");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor.getExceptionCode(), "-1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scaleToSize() throws Exception {
        GeneralBounds finalEnvelope;
        File file;
        byte[] tiffContents;
        MockHttpServletResponse response;
        ReferencedEnvelope sourceEnvelope;
        GeoTiffReader readerTarget = null;
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            sourceEnvelope = sourceCoverage.getEnvelope2D();
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&subset=" + this.subsetPrefix + "Long(" + sourceEnvelope.getMinX() + "," + (sourceEnvelope.getMinX() + sourceEnvelope.getWidth() / 2.0) + ")&subset=" + this.subsetPrefix + "Lat(" + sourceEnvelope.getMinY() + "," + (sourceEnvelope.getMinY() + sourceEnvelope.getHeight() / 2.0) + ")&SCALESIZE=" + this.axisPrefix + "i(50)," + this.axisPrefix + "j(50)");
            Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
            tiffContents = this.getBinary(response);
            file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
            FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
            readerTarget = new GeoTiffReader((Object)file);
            targetCoverage = readerTarget.read(null);
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            finalEnvelope = new GeneralBounds(new double[]{sourceEnvelope.getMinX(), sourceEnvelope.getMinY()}, new double[]{sourceEnvelope.getMinX() + sourceEnvelope.getWidth() / 2.0, sourceEnvelope.getMinY() + sourceEnvelope.getHeight() / 2.0});
            finalEnvelope.setCoordinateReferenceSystem(sourceCoverage.getCoordinateReferenceSystem());
            Assert.assertEquals((long)50L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)50L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            Assert.assertEquals((double)29.0, (double)new ImageWorker(targetCoverage.getRenderedImage()).getMaximums()[0], (double)1.0);
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            sourceEnvelope = sourceCoverage.getEnvelope2D();
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALESIZE=" + this.axisPrefix + "i(1000)," + this.axisPrefix + "j(1000)&&subset=" + this.subsetPrefix + "Long(" + sourceEnvelope.getMinX() + "," + (sourceEnvelope.getMinX() + sourceEnvelope.getWidth() / 2.0) + ")&subset=" + this.subsetPrefix + "Lat(" + sourceEnvelope.getMinY() + "," + (sourceEnvelope.getMinY() + sourceEnvelope.getHeight() / 2.0) + ")");
            Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
            tiffContents = this.getBinary(response);
            file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
            FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
            readerTarget = new GeoTiffReader((Object)file);
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            Assert.assertEquals((long)1000L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)1000L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            finalEnvelope = new GeneralBounds(new double[]{sourceEnvelope.getMinX(), sourceEnvelope.getMinY()}, new double[]{sourceEnvelope.getMinX() + sourceEnvelope.getWidth() * 2.0, sourceEnvelope.getMinY() + sourceEnvelope.getHeight() * 2.0});
            finalEnvelope.setCoordinateReferenceSystem(sourceCoverage.getCoordinateReferenceSystem());
            Assert.assertEquals((double)29.0, (double)new ImageWorker(targetCoverage.getRenderedImage()).getMaximums()[0], (double)0.0);
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        MockHttpServletResponse response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALESIZE=" + this.axisPrefix + "i(100)," + this.axisPrefix + "j(0)");
        Assert.assertEquals((Object)"application/xml", (Object)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "0");
        response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALESIZE=" + this.axisPrefix + "i(-2)," + this.axisPrefix + "j(100)");
        Assert.assertEquals((Object)"application/xml", (Object)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "-2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scaleToExtent() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(0,99)," + this.axisPrefix + "j(0,99)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            Assert.assertEquals((long)100L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)100L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(100,1099)," + this.axisPrefix + "j(100,1099)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        tiffContents = this.getBinary(response);
        file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        readerTarget = new GeoTiffReader((Object)file);
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            ScaleKvpTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)targetCoverage);
            Assert.assertEquals((long)1000L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)1000L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            Assert.assertEquals((long)0L, (long)targetCoverage.getGridGeometry().getGridRange().getLow(0));
            Assert.assertEquals((long)0L, (long)targetCoverage.getGridGeometry().getGridRange().getLow(1));
            Assert.assertEquals((long)999L, (long)targetCoverage.getGridGeometry().getGridRange().getHigh(0));
            Assert.assertEquals((long)999L, (long)targetCoverage.getGridGeometry().getGridRange().getHigh(1));
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        try {
            targetCoverage = (GridCoverage2D)this.executeGetCoverage("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(100,1099)," + this.axisPrefix + "j(100,1099)");
            Assert.assertNotNull((Object)targetCoverage);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((long)1000L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)1000L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            Assert.assertEquals((long)100L, (long)targetCoverage.getGridGeometry().getGridRange().getLow(0));
            Assert.assertEquals((long)100L, (long)targetCoverage.getGridGeometry().getGridRange().getLow(1));
            Assert.assertEquals((long)1099L, (long)targetCoverage.getGridGeometry().getGridRange().getHigh(0));
            Assert.assertEquals((long)1099L, (long)targetCoverage.getGridGeometry().getGridRange().getHigh(1));
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(1000,0)," + this.axisPrefix + "j(0,1000)");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "0");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(1000,1000)," + this.axisPrefix + "j(0,1000)");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "1000");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "j(1000,0)," + this.axisPrefix + "i(0,1000)");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "0");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "j(1000,1000)," + this.axisPrefix + "i(0,1000)");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scaleToExtentWithTrim() throws Exception {
        GeneralBounds finalEnvelope;
        File file;
        byte[] tiffContents;
        MockHttpServletResponse response;
        ReferencedEnvelope sourceEnvelope;
        GeoTiffReader readerTarget = null;
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            sourceEnvelope = sourceCoverage.getEnvelope2D();
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(50,149)," + this.axisPrefix + "j(50,149)&subset=" + this.subsetPrefix + "Long(" + sourceEnvelope.getMinX() + "," + (sourceEnvelope.getMinX() + sourceEnvelope.getWidth() / 2.0) + ")&subset=" + this.subsetPrefix + "Lat(" + sourceEnvelope.getMinY() + "," + (sourceEnvelope.getMinY() + sourceEnvelope.getHeight() / 2.0) + ")");
            Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
            tiffContents = this.getBinary(response);
            file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
            FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
            readerTarget = new GeoTiffReader((Object)file);
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            finalEnvelope = new GeneralBounds(new double[]{sourceEnvelope.getMinX(), sourceEnvelope.getMinY()}, new double[]{sourceEnvelope.getMinX() + sourceEnvelope.getWidth() / 2.0, sourceEnvelope.getMinY() + sourceEnvelope.getHeight() / 2.0});
            finalEnvelope.setCoordinateReferenceSystem(sourceCoverage.getCoordinateReferenceSystem());
            Assert.assertEquals((long)100L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)100L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            Assert.assertEquals((double)29.0, (double)new ImageWorker(targetCoverage.getRenderedImage()).getMaximums()[0], (double)0.0);
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            sourceEnvelope = sourceCoverage.getEnvelope2D();
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(100,1099)," + this.axisPrefix + "j(100,1099)&subset=" + this.subsetPrefix + "Long(" + sourceEnvelope.getMinX() + "," + (sourceEnvelope.getMinX() + sourceEnvelope.getWidth() / 2.0) + ")&subset=" + this.subsetPrefix + "Lat(" + sourceEnvelope.getMinY() + "," + (sourceEnvelope.getMinY() + sourceEnvelope.getHeight() / 2.0) + ")");
            Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
            tiffContents = this.getBinary(response);
            file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
            FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
            readerTarget = new GeoTiffReader((Object)file);
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            finalEnvelope = new GeneralBounds(new double[]{sourceEnvelope.getMinX(), sourceEnvelope.getMinY()}, new double[]{sourceEnvelope.getMinX() + sourceEnvelope.getWidth() / 2.0, sourceEnvelope.getMinY() + sourceEnvelope.getHeight() / 2.0});
            finalEnvelope.setCoordinateReferenceSystem(sourceCoverage.getCoordinateReferenceSystem());
            Assert.assertEquals((long)1000L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)1000L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            Assert.assertEquals((long)0L, (long)targetCoverage.getGridGeometry().getGridRange().getLow(0));
            Assert.assertEquals((long)0L, (long)targetCoverage.getGridGeometry().getGridRange().getLow(1));
            Assert.assertEquals((long)999L, (long)targetCoverage.getGridGeometry().getGridRange().getHigh(0));
            Assert.assertEquals((long)999L, (long)targetCoverage.getGridGeometry().getGridRange().getHigh(1));
            Assert.assertEquals((double)29.0, (double)new ImageWorker(targetCoverage.getRenderedImage()).getMaximums()[0], (double)0.0);
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        try {
            targetCoverage = (GridCoverage2D)this.executeGetCoverage("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(100,1099)," + this.axisPrefix + "j(100,1099)");
            Assert.assertNotNull((Object)targetCoverage);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((long)1000L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            Assert.assertEquals((long)1000L, (long)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            Assert.assertEquals((long)100L, (long)targetCoverage.getGridGeometry().getGridRange().getLow(0));
            Assert.assertEquals((long)100L, (long)targetCoverage.getGridGeometry().getGridRange().getLow(1));
            Assert.assertEquals((long)1099L, (long)targetCoverage.getGridGeometry().getGridRange().getHigh(0));
            Assert.assertEquals((long)1099L, (long)targetCoverage.getGridGeometry().getGridRange().getHigh(1));
        }
        catch (Throwable throwable) {
            this.clean(readerTarget, targetCoverage, sourceCoverage);
            throw throwable;
        }
        this.clean(readerTarget, targetCoverage, sourceCoverage);
        MockHttpServletResponse response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(1000,0)," + this.axisPrefix + "j(0,1000)");
        Assert.assertEquals((Object)"application/xml", (Object)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "0");
        response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "i(1000,1000)," + this.axisPrefix + "j(0,1000)");
        Assert.assertEquals((Object)"application/xml", (Object)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "1000");
        response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "j(1000,0)," + this.axisPrefix + "i(0,1000)");
        Assert.assertEquals((Object)"application/xml", (Object)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "0");
        response2 = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEEXTENT=" + this.axisPrefix + "j(1000,1000)," + this.axisPrefix + "i(0,1000)");
        Assert.assertEquals((Object)"application/xml", (Object)response2.getContentType());
        this.checkOws20Exception(response2, 404, WCS20Exception.WCS20ExceptionCode.InvalidExtent.getExceptionCode(), "1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRequests() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 8);
        try {
            ArrayList<Future> futures = new ArrayList<Future>();
            for (int i = 0; i < 100; ++i) {
                Future future = executor.submit(() -> {
                    MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&SCALEFACTOR=0.5");
                    Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
                    return null;
                });
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }
}

