/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class EnvelopeAxesLabelsMapper {
    public List<String> getAxesNames(Envelope envelope, boolean swapAxes) {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        boolean axesSwitch = crs instanceof GeographicCRS && swapAxes;
        CoordinateSystem cs = crs.getCoordinateSystem();
        int dimension = cs.getDimension();
        ArrayList<String> retValue = new ArrayList<String>();
        if (!axesSwitch) {
            for (int i = 0; i < dimension; ++i) {
                CoordinateSystemAxis axis = cs.getAxis(i);
                retValue.add(this.getAxisLabel(axis));
            }
        } else {
            int northing = -1;
            int easting = -1;
            for (int i = 0; i < dimension; ++i) {
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (Math.abs(DefaultCoordinateSystemAxis.getAngle((AxisDirection)axis.getDirection(), (AxisDirection)DefaultCoordinateSystemAxis.LONGITUDE.getDirection())) < 1.0E-6) {
                    easting = i;
                } else if (Math.abs(DefaultCoordinateSystemAxis.getAngle((AxisDirection)axis.getDirection(), (AxisDirection)DefaultCoordinateSystemAxis.LATITUDE.getDirection())) < 1.0E-6) {
                    northing = i;
                }
                retValue.add(this.getAxisLabel(axis));
            }
            retValue.add(northing, retValue.remove(easting));
        }
        return retValue;
    }

    private String getAxisLabel(CoordinateSystemAxis axis) {
        String label = axis.getAbbreviation();
        if (label.equals(DefaultCoordinateSystemAxis.LONGITUDE.getAbbreviation()) || label.equals("Lon") || label.equals("Long")) {
            return "Long";
        }
        if (label.equals(DefaultCoordinateSystemAxis.LATITUDE.getAbbreviation()) || label.equals("Lat")) {
            return "Lat";
        }
        return label;
    }

    public int getAxisIndex(Envelope envelope, String axisAbbreviation) {
        int[] val = this.getAxesIndexes(envelope, Arrays.asList(axisAbbreviation));
        return val == null ? -1 : val[0];
    }

    public int[] getAxesIndexes(Envelope envelope, List<String> axesAbbreviations) {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Utilities.ensureNonNull((String)"dimensionNames", axesAbbreviations);
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        CoordinateSystem cs = crs.getCoordinateSystem();
        int crsDimension = cs.getDimension();
        int dimension = axesAbbreviations.size();
        int[] retValue = new int[dimension];
        for (int i = 0; i < dimension; ++i) {
            String axisAbbreviation = axesAbbreviations.get(i);
            int pos = -1;
            for (int j = 0; j < crsDimension; ++j) {
                CoordinateSystemAxis axis = cs.getAxis(j);
                if (!this.getAxisLabel(axis).equals(axisAbbreviation)) continue;
                pos = j;
                break;
            }
            if (pos < 0) {
                return null;
            }
            retValue[i] = pos;
        }
        return retValue;
    }
}

