/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;
import org.geoserver.wcs2_0.response.DimensionBean;
import org.geoserver.wcs2_0.response.GranuleStack;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class GranuleStackImpl
extends GridCoverage2D
implements GranuleStack {
    private List<DimensionBean> dimensions;
    private List<GridCoverage2D> coverages;
    private static final long serialVersionUID = 1L;

    public String toString() {
        return "GranuleStackImpl [dimensions=" + this.dimensions + ", coverages=" + this.coverages + "]";
    }

    public GranuleStackImpl(CharSequence name, CoordinateReferenceSystem crs, List<DimensionBean> dimensions) {
        super(name, (GridCoverage2D)new DummyGridCoverage2D(name, crs));
        this.dimensions = dimensions;
        this.coverages = new ArrayList<GridCoverage2D>();
    }

    public RenderedImage getRenderedImage() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unable to return a RenderedImage for a GranuleStack which is made of different coverages: returning null");
        }
        return null;
    }

    public Object evaluate(DirectPosition point) throws PointOutsideCoverageException, CannotEvaluateException {
        throw new UnsupportedOperationException("This is a multidimensional coverage, you should access its contents calling getGranules");
    }

    public int getNumSampleDimensions() {
        throw new UnsupportedOperationException("This is a multidimensional coverage, you should access its contents calling getGranules");
    }

    @Override
    public List<DimensionBean> getDimensions() {
        return this.dimensions;
    }

    @Override
    public List<GridCoverage2D> getGranules() {
        return this.coverages;
    }

    public void addCoverage(GridCoverage2D coverage) {
        this.coverages.add(coverage);
    }

    public boolean dispose(boolean force) {
        boolean disposed = true;
        for (GridCoverage2D coverage : this.coverages) {
            RenderedImage ri = coverage.getRenderedImage();
            disposed &= coverage.dispose(force);
            if (!(ri instanceof PlanarImage)) continue;
            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
        }
        return disposed;
    }

    static class DummyGridCoverage2D
    extends GridCoverage2D {
        static GridEnvelope SAMPLE_GRID_ENVELOPE = new GridEnvelope2D(new Rectangle(0, 0, 1, 1));
        static MathTransform SAMPLE_TRANSFORM = ProjectiveTransform.create((AffineTransform)AffineTransform.getScaleInstance(1.0, 1.0));
        static PlanarImage SAMPLE_IMAGE = new TiledImage((RenderedImage)new BufferedImage(1, 1, 10), false);

        protected DummyGridCoverage2D(CharSequence name, CoordinateReferenceSystem crs) throws IllegalArgumentException {
            super(name, SAMPLE_IMAGE, new GridGeometry2D(SAMPLE_GRID_ENVELOPE, (Envelope)new GeneralEnvelope(SAMPLE_GRID_ENVELOPE, PixelInCell.CELL_CENTER, SAMPLE_TRANSFORM, crs)), null, null, null, null);
        }
    }
}

