/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import net.opengis.wcs20.InterpolationAxesType;
import net.opengis.wcs20.InterpolationAxisType;
import net.opengis.wcs20.InterpolationMethodType;
import net.opengis.wcs20.InterpolationType;
import net.opengis.wcs20.Wcs20Factory;
import org.geoserver.ows.KvpParser;
import org.geoserver.wcs2_0.exception.WCS20Exception;

public class InterpolationKvpParser
extends KvpParser {
    public InterpolationKvpParser() {
        super("interpolation", InterpolationType.class);
    }

    public Object parse(String value) throws Exception {
        String[] components;
        InterpolationType result = Wcs20Factory.eINSTANCE.createInterpolationType();
        if ((value = value.trim()).matches("http://www.opengis.net/def/interpolation/OGC/1/[^,:]*")) {
            InterpolationMethodType method = Wcs20Factory.eINSTANCE.createInterpolationMethodType();
            method.setInterpolationMethod(value);
            result.setInterpolationMethod(method);
            return result;
        }
        if (value.matches(".*,\\s*,.*")) {
            this.throwInvalidSyntaxException();
        } else if (value.startsWith(",") || value.endsWith(",")) {
            this.throwInvalidSyntaxException();
        }
        InterpolationAxesType axes = Wcs20Factory.eINSTANCE.createInterpolationAxesType();
        result.setInterpolationAxes(axes);
        for (String component : components = value.split("\\s*,\\s*")) {
            if (!component.matches(".*:http://www.opengis.net/def/interpolation/OGC/1/.*")) {
                this.throwInvalidSyntaxException();
            } else if (component.matches(".*:\\s*:.*")) {
                this.throwInvalidSyntaxException();
            }
            int idx = component.lastIndexOf(":", component.lastIndexOf(":") - 1);
            InterpolationAxisType ia = Wcs20Factory.eINSTANCE.createInterpolationAxisType();
            ia.setAxis(component.substring(0, idx));
            ia.setInterpolationMethod(component.substring(idx + 1));
            axes.getInterpolationAxis().add((Object)ia);
        }
        return result;
    }

    protected void throwInvalidSyntaxException() {
        throw new WCS20Exception("Invalid Interpolation syntax, expecting either a single interpolation value, or a comma separated list of axis:interpolation specs", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "interpolation");
    }
}

