/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import org.geotools.geometry.AbstractEnvelope;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class WCSEnvelope
extends AbstractEnvelope {
    private static final int LONGIDUTE_NOT_FOUND = -1;
    CoordinateReferenceSystem crs;
    double[] ordinates;
    int dimensions;
    int longitudeDimension = -1;

    public WCSEnvelope(CoordinateReferenceSystem crs) {
        if (crs == null) {
            throw new IllegalArgumentException("WCSEnvelope coordinate reference system cannot be null");
        }
        this.crs = crs;
        CoordinateSystem cs = crs.getCoordinateSystem();
        this.dimensions = cs.getDimension();
        this.ordinates = new double[this.dimensions * 2];
        for (int i = 0; i < this.dimensions; ++i) {
            CoordinateSystemAxis axis = cs.getAxis(i);
            if (!CRS.equalsIgnoreMetadata((Object)axis, (Object)DefaultCoordinateSystemAxis.LONGITUDE)) continue;
            this.longitudeDimension = i;
            break;
        }
    }

    public WCSEnvelope(Envelope other) {
        this(other.getCoordinateReferenceSystem());
        for (int d = 0; d < this.dimensions; ++d) {
            this.setRange(d, other.getMinimum(d), other.getMaximum(d));
        }
    }

    public void setRange(int dimension, double minimum, double maximum) throws IndexOutOfBoundsException {
        if (minimum > maximum && this.longitudeDimension != -1 && dimension != this.longitudeDimension) {
            minimum = maximum = 0.5 * (minimum + maximum);
            this.ordinates[dimension + this.ordinates.length / 2] = maximum;
            this.ordinates[dimension] = minimum;
        } else if (dimension >= 0 && dimension < this.ordinates.length / 2) {
            this.ordinates[dimension + this.ordinates.length / 2] = maximum;
            this.ordinates[dimension] = minimum;
        } else {
            throw this.indexOutOfBounds(dimension);
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.dimensions; ++i) {
            double span = this.getSpan(i);
            if (span == 0.0) {
                return true;
            }
            if (!(span < 0.0) || i == this.longitudeDimension) continue;
            return true;
        }
        return false;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public int getDimension() {
        return this.dimensions;
    }

    public double getMinimum(int dimension) throws IndexOutOfBoundsException {
        if (dimension < this.dimensions) {
            return this.ordinates[dimension];
        }
        throw this.indexOutOfBounds(dimension);
    }

    private IndexOutOfBoundsException indexOutOfBounds(int dimension) {
        return new IndexOutOfBoundsException("Invalid dimension " + dimension);
    }

    public double getMaximum(int dimension) throws IndexOutOfBoundsException {
        if (dimension < this.dimensions) {
            return this.ordinates[dimension + this.ordinates.length / 2];
        }
        throw this.indexOutOfBounds(dimension);
    }

    public double getMedian(int dimension) throws IndexOutOfBoundsException {
        if (dimension < this.ordinates.length / 2) {
            return 0.5 * (this.ordinates[dimension] + this.ordinates[dimension + this.ordinates.length / 2]);
        }
        throw this.indexOutOfBounds(dimension);
    }

    public double getSpan(int dimension) throws IndexOutOfBoundsException {
        if (dimension < this.ordinates.length / 2) {
            return this.ordinates[dimension + this.ordinates.length / 2] - this.ordinates[dimension];
        }
        throw this.indexOutOfBounds(dimension);
    }

    public GeneralEnvelope[] getNormalizedEnvelopes() {
        if (!this.isCrossingDateline()) {
            return new GeneralEnvelope[]{new GeneralEnvelope((Envelope)this)};
        }
        GeneralEnvelope e1 = new GeneralEnvelope(this.crs);
        GeneralEnvelope e2 = new GeneralEnvelope(this.crs);
        for (int i = 0; i < this.dimensions; ++i) {
            if (i == this.longitudeDimension) {
                e1.setRange(i, this.getMinimum(i), 180.0);
                if (this.getSpan(this.longitudeDimension) < 0.0) {
                    e2.setRange(i, -180.0, this.getMaximum(i));
                    continue;
                }
                e2.setRange(i, -180.0, this.getMaximum(i) - 360.0);
                continue;
            }
            e1.setRange(i, this.getMinimum(i), this.getMaximum(i));
            e2.setRange(i, this.getMinimum(i), this.getMaximum(i));
        }
        return new GeneralEnvelope[]{e1, e2};
    }

    public void intersect(GeneralEnvelope other) {
        assert (other.getDimension() == this.dimensions) : other;
        assert (CRS.equalsIgnoreMetadata((Object)this.crs, (Object)other.getCoordinateReferenceSystem())) : other;
        if (this.isCrossingDateline()) {
            GeneralEnvelope[] normalizedEnvelopes;
            for (GeneralEnvelope ge : normalizedEnvelopes = this.getNormalizedEnvelopes()) {
                ge.intersect((Envelope)other);
            }
            for (int i = 0; i < this.dimensions; ++i) {
                if (i == this.longitudeDimension) {
                    if (normalizedEnvelopes[0].getSpan(i) == 0.0) {
                        this.ordinates[i] = normalizedEnvelopes[1].getMinimum(i);
                        this.ordinates[i + this.dimensions] = normalizedEnvelopes[1].getMaximum(i);
                        continue;
                    }
                    if (normalizedEnvelopes[1].getSpan(i) == 0.0) {
                        this.ordinates[i] = normalizedEnvelopes[0].getMinimum(i);
                        this.ordinates[i + this.dimensions] = normalizedEnvelopes[0].getMaximum(i);
                        continue;
                    }
                    this.ordinates[i] = normalizedEnvelopes[0].getMinimum(i);
                    this.ordinates[i + this.dimensions] = normalizedEnvelopes[1].getMaximum(i);
                    continue;
                }
                this.ordinates[i] = normalizedEnvelopes[0].getMinimum(i);
                this.ordinates[i + this.dimensions] = normalizedEnvelopes[0].getMaximum(i);
            }
        } else {
            for (int i = 0; i < this.dimensions; ++i) {
                double max;
                double min = Math.max(this.ordinates[i], other.getMinimum(i));
                if (min > (max = Math.min(this.ordinates[i + this.dimensions], other.getMaximum(i)))) {
                    min = max = 0.5 * (min + max);
                }
                this.ordinates[i] = min;
                this.ordinates[i + this.dimensions] = max;
            }
        }
    }

    public boolean isCrossingDateline() {
        return this.longitudeDimension != -1 && (this.getSpan(this.longitudeDimension) < 0.0 || this.getMinimum(this.longitudeDimension) < 180.0 && this.getMaximum(this.longitudeDimension) > 180.0);
    }

    public boolean isLongitude(int dimension) {
        return this.longitudeDimension == dimension;
    }
}

