/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class DescribeCoverageTest
extends WCSTestSupport {
    @Test
    public void testEntityExpansion() throws Exception {
        File xml = new File("./src/test/resources/testDescribeCoverageEntityExpansion.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        Assert.assertNotNull((Object)dom);
        String text = xpath.evaluate("//ows:ExceptionText", dom);
        Assert.assertTrue((boolean)text.contains("Entity resolution disallowed for "));
    }

    @Test
    public void testDescribeCoverageSimple() throws Exception {
        File xml = new File("./src/test/resources/testDescribeCoverage.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"wcs__BlueMarble", (String)"//wcs:CoverageDescription//wcs:CoverageId", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wcs:CoverageDescription//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-43.0020833333312 146.5020833333281", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//gml:domainSet//gml:RectifiedGrid//gml:origin//gml:Point//gml:pos", (Document)dom);
    }

    @Test
    public void testDescribeCoverageMultiband() throws Exception {
        File xml = new File("./src/test/resources/testDescribeCoverageMultiBand.xml");
        String request = FileUtils.readFileToString((File)xml, (String)"UTF-8");
        Document dom = this.postAsDOM("wcs", request);
        Assert.assertNotNull((Object)dom);
        this.checkValidationErrors(dom, DescribeCoverageTest.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"wcs__multiband", (String)"//wcs:CoverageDescription//wcs:CoverageId", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"9", (String)"count(//wcs:CoverageDescription//gmlcov:rangeType//swe:DataRecord//swe:field)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//wcs:CoverageDescriptions//wcs:CoverageDescription[1]//wcs:ServiceParameters//wcs:nativeFormat", (Document)dom);
    }
}

