/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.kvp.WCSKVPTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.Envelope2D;
import org.geotools.util.logging.Logging;
import org.junit.Test;
import org.opengis.coverage.grid.GridCoverage;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class SubsetKvpTest
extends WCSKVPTestSupport {
    private Logger LOGGER = Logging.getLogger(SubsetKvpTest.class);

    @Test
    public void capabilties() throws Exception {
        Document dom = this.getAsDOM("wcs?reQueSt=GetCapabilities&seErvIce=WCS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification[ows:Profile='http://www.opengis.net/spec/WCS_protocol-binding_get-kvp/1.0.1'])", (Document)dom);
        dom = this.getAsDOM("wcs?request=Getcapabilities&service=wCS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@exceptionCode='InvalidParameterValue'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport//ows:Exception[@locator='wCS'])", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void trim() throws Exception {
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        GeoTiffReader readerTarget = null;
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Envelope2D sourceEnvelope = sourceCoverage.getEnvelope2D();
            MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&subset=http://www.opengis.net/def/axis/OGC/0/Long(" + sourceEnvelope.x + "," + (sourceEnvelope.x + sourceEnvelope.width / 2.0) + ")&subset=http://www.opengis.net/def/axis/OGC/0/Lat(" + sourceEnvelope.y + "," + (sourceEnvelope.y + sourceEnvelope.height / 2.0) + ")");
            TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
            byte[] tiffContents = this.getBinary(response);
            File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
            FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
            readerTarget = new GeoTiffReader((Object)file);
            targetCoverage = readerTarget.read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            TestCase.assertEquals((int)180, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)180, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            TestCase.assertEquals((int)0, (int)targetCoverage.getGridGeometry().getGridRange().getLow(0));
            TestCase.assertEquals((int)0, (int)targetCoverage.getGridGeometry().getGridRange().getLow(1));
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&subset=http://www.opengis.net/def/axis/OGC/0/Long(" + (sourceEnvelope.x + 1.1 * sourceEnvelope.width) + "," + (sourceEnvelope.x + 1.2 * sourceEnvelope.width) + ")&subset=http://www.opengis.net/def/axis/OGC/0/Lat(" + (sourceEnvelope.y + 1.1 * sourceEnvelope.height) + "," + (sourceEnvelope.y + 1.2 * sourceEnvelope.height) + ")");
            TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
            this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting.getExceptionCode(), "");
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&subset=http://www.opengis.net/def/axis/OGC/0/Long(" + sourceEnvelope.x + "," + (sourceEnvelope.x + sourceEnvelope.width) + ")&subset=http://www.opengis.net/def/axis/OGC/0/Lat(" + (sourceEnvelope.y + sourceEnvelope.height) + "," + sourceEnvelope.y + ")");
            TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
            this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting.getExceptionCode(), Double.toString(sourceEnvelope.y + sourceEnvelope.height));
        }
        catch (Throwable throwable) {
            try {
                if (readerTarget != null) {
                    readerTarget.dispose();
                }
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            throw throwable;
        }
        try {
            if (readerTarget != null) {
                readerTarget.dispose();
            }
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        try {
            this.scheduleForCleaning((GridCoverage)targetCoverage);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        try {
            this.scheduleForCleaning((GridCoverage)sourceCoverage);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sliceError() throws Exception {
        GridCoverage targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        Object readerTarget = null;
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Envelope2D sourceEnvelope = sourceCoverage.getEnvelope2D();
            MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&subset=http://www.opengis.net/def/axis/OGC/0/Long(" + sourceEnvelope.x + "," + (sourceEnvelope.x + sourceEnvelope.width) + ")&subset=http://www.opengis.net/def/axis/OGC/0/Lat(" + sourceEnvelope.y * 0.9 + ")");
            TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
            this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting.getExceptionCode(), Double.toString(sourceEnvelope.y * 0.9));
            response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&subset=http://www.opengis.net/def/axis/OGC/0/Long(" + sourceEnvelope.x * 0.9 + ")&subset=http://www.opengis.net/def/axis/OGC/0/Lat(" + sourceEnvelope.y + "," + (sourceEnvelope.y + sourceEnvelope.height / 2.0) + ")");
            TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
            this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.InvalidSubsetting.getExceptionCode(), Double.toString(sourceEnvelope.x * 0.9));
        }
        finally {
            try {
                if (readerTarget != null) {
                    readerTarget.dispose();
                }
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning(targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void slice() throws Exception {
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        GeoTiffReader readerTarget = null;
        try {
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Envelope2D sourceEnvelope = sourceCoverage.getEnvelope2D();
            MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&&Format=image/tiff&subset=http://www.opengis.net/def/axis/OGC/0/Long(" + sourceEnvelope.x + ")&subset=http://www.opengis.net/def/axis/OGC/0/Lat(" + sourceEnvelope.y + "," + (sourceEnvelope.y + sourceEnvelope.height / 2.0) + ")");
            TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
            byte[] tiffContents = this.getBinary(response);
            File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
            FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
            readerTarget = new GeoTiffReader((Object)file);
            targetCoverage = readerTarget.read(null);
            TestCase.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            TestCase.assertEquals((int)1, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(0));
            TestCase.assertEquals((int)180, (int)targetCoverage.getGridGeometry().getGridRange().getSpan(1));
            TestCase.assertEquals((int)0, (int)targetCoverage.getGridGeometry().getGridRange().getLow(0));
            TestCase.assertEquals((int)0, (int)targetCoverage.getGridGeometry().getGridRange().getLow(1));
        }
        catch (Throwable throwable) {
            try {
                if (readerTarget != null) {
                    readerTarget.dispose();
                }
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            throw throwable;
        }
        try {
            if (readerTarget != null) {
                readerTarget.dispose();
            }
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        try {
            this.scheduleForCleaning((GridCoverage)targetCoverage);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        try {
            this.scheduleForCleaning((GridCoverage)sourceCoverage);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }
}

