/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wcs.WCSInfo;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.wcs.v2_0.WCSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.After;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXParseException;

public abstract class WCSTestSupport
extends GeoServerSystemTestSupport {
    protected static XpathEngine xpath;
    protected static final boolean IS_WINDOWS;
    private static Schema WCS20_SCHEMA;
    List<GridCoverage> coverages = new ArrayList<GridCoverage>();
    protected static final String VERSION = "2.0.1";
    protected static final QName UTM11;
    static final float EPS = 1.0E-5f;

    protected static Schema getWcs20Schema() {
        if (WCS20_SCHEMA == null) {
            final HashMap<String, String> namespaceMap = new HashMap<String, String>(){
                {
                    this.put("http://www.opengis.net/wcs/2.0", "/schemas/wcs/2.0/");
                    this.put("http://www.opengis.net/gmlcov/1.0", "/schemas/gmlcov/1.0/");
                    this.put("http://www.opengis.net/gml/3.2", "/schemas/gml/3.2.1/");
                    this.put("http://www.w3.org/1999/xlink", "/schemas/xlink/");
                    this.put("http://www.w3.org/XML/1998/namespace", "/schemas/xml/");
                    this.put("http://www.isotc211.org/2005/gmd", "/schemas/iso/19139/20070417/gmd/");
                    this.put("http://www.isotc211.org/2005/gco", "/schemas/iso/19139/20070417/gco/");
                    this.put("http://www.isotc211.org/2005/gss", "/schemas/iso/19139/20070417/gss/");
                    this.put("http://www.isotc211.org/2005/gts", "/schemas/iso/19139/20070417/gts/");
                    this.put("http://www.isotc211.org/2005/gsr", "/schemas/iso/19139/20070417/gsr/");
                    this.put("http://www.opengis.net/swe/2.0", "/schemas/sweCommon/2.0/");
                    this.put("http://www.opengis.net/ows/2.0", "/schemas/ows/2.0/");
                    this.put("http://www.geoserver.org/wcsgs/2.0", "/schemas/wcs/2.0/");
                }
            };
            try {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                factory.setResourceResolver(new LSResourceResolver(){
                    DOMImplementationLS dom;
                    {
                        try {
                            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                            builderFactory.setNamespaceAware(true);
                            DocumentBuilder builder = builderFactory.newDocumentBuilder();
                            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><empty></empty>";
                            this.dom = (DOMImplementationLS)((Object)builder.parse(new ByteArrayInputStream(xml.getBytes())).getImplementation());
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                        String localPosition = (String)namespaceMap.get(namespaceURI);
                        if (localPosition != null) {
                            try {
                                URL resource;
                                if (systemId.contains("/")) {
                                    systemId = systemId.substring(systemId.lastIndexOf("/") + 1);
                                }
                                if ((resource = WCSTestSupport.class.getResource(localPosition + "/" + systemId)) != null) {
                                    systemId = resource.toURI().toASCIIString();
                                    LSInput input = this.dom.createLSInput();
                                    input.setPublicId(publicId);
                                    input.setSystemId(systemId);
                                    return input;
                                }
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        return null;
                    }
                });
                WCS20_SCHEMA = factory.newSchema(new Source[]{new StreamSource(WCSTestSupport.class.getResource("/schemas/wcs/2.0/wcsAll.xsd").toExternalForm()), new StreamSource(WCSTestSupport.class.getResource("/schemas/wcs/2.0/wcsgs.xsd").toExternalForm())});
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse the WCS 2.0 schemas", e);
            }
        }
        return WCS20_SCHEMA;
    }

    protected WCSInfo getWCS() {
        return (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
        testData.setUpWcs10RasterLayers();
        testData.setUpWcs11RasterLayers();
        testData.setUpRasterLayer(UTM11, "/utm11-2.tiff", null, null, WCSTestSupport.class);
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wcs", "http://www.opengis.net/wcs/2.0");
        namespaces.put("crs", "http://www.opengis.net/wcs/crs/1.0");
        namespaces.put("ows", "http://www.opengis.net/ows/2.0");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("int", "http://www.opengis.net/WCS_service-extension_interpolation/1.0");
        namespaces.put("gmlcov", "http://www.opengis.net/gmlcov/1.0");
        namespaces.put("swe", "http://www.opengis.net/swe/2.0");
        namespaces.put("gml", "http://www.opengis.net/gml/3.2");
        namespaces.put("wcsgs", "http://www.geoserver.org/wcsgs/2.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        xpath = XMLUnit.newXpathEngine();
    }

    protected boolean isMemoryCleanRequired() {
        return IS_WINDOWS;
    }

    protected void checkValidationErrors(Document dom) throws Exception {
        Parser p = new Parser((Configuration)new WCSConfiguration());
        p.setValidating(true);
        p.parse((Source)new DOMSource(dom));
        if (!p.getValidationErrors().isEmpty()) {
            for (SAXParseException ex : p.getValidationErrors()) {
                System.out.println(ex.getLineNumber() + "," + ex.getColumnNumber() + " -" + ex.toString());
            }
            TestCase.fail((String)"Document did not validate.");
        }
    }

    protected void scheduleForCleaning(GridCoverage coverage) {
        if (coverage != null) {
            this.coverages.add(coverage);
        }
    }

    @After
    public void cleanCoverages() {
        for (GridCoverage coverage : this.coverages) {
            if (coverage == null) continue;
            CoverageCleanerCallback.disposeCoverage((GridCoverage)coverage);
        }
    }

    protected void checkFullCapabilitiesDocument(Document dom) throws Exception {
        this.checkValidationErrors(dom, WCSTestSupport.getWcs20Schema());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification[ows:Profile='http://www.opengis.net/spec/WCS_service-extension_crs/1.0/conf/crs'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:ServiceMetadata/wcs:Extension/crs:CrsMetadata[crs:crsSupported = 'http://www.opengis.net/def/crs/EPSG/0/4326'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification[ows:Profile='http://www.opengis.net/spec/WCS_service-extension_interpolation/1.0/conf/interpolation'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:ServiceMetadata/wcs:Extension[int:interpolationSupported='http://www.opengis.net/def/interpolation/OGC/1/nearest-neighbor'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:ServiceMetadata/wcs:Extension[int:interpolationSupported='http://www.opengis.net/def/interpolation/OGC/1/linear'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:ServiceMetadata/wcs:Extension[int:interpolationSupported='http://www.opengis.net/def/interpolation/OGC/1/cubic'])", (Document)dom);
    }

    protected IIOMetadataNode getTiffField(Node rootNode, int tag) {
        Node node = rootNode.getFirstChild();
        if (node != null) {
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                Node number = node.getAttributes().getNamedItem("number");
                if (number == null || tag != Integer.parseInt(number.getNodeValue())) continue;
                return (IIOMetadataNode)node;
            }
        }
        return null;
    }

    protected void setInputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxInputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    protected void setOutputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxOutputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    protected static void assertEnvelopeEquals(Coverage expected, Coverage actual) {
        double scaleA = WCSTestSupport.getScale(expected);
        double scaleB = WCSTestSupport.getScale(actual);
        WCSTestSupport.assertEnvelopeEquals((GeneralEnvelope)expected.getEnvelope(), scaleA, (GeneralEnvelope)actual.getEnvelope(), scaleB);
    }

    protected static void assertEnvelopeEquals(GeneralEnvelope expected, double scaleExpected, GeneralEnvelope actual, double scaleActual) {
        double tolerance = scaleExpected <= scaleActual ? scaleExpected * 0.1 : (!Double.isNaN(scaleActual) ? scaleActual * 0.1 : (double)1.0E-5f);
        TestCase.assertTrue((boolean)expected.equals((Envelope)actual, tolerance, false));
    }

    protected static AffineTransform getAffineTransform(Coverage coverage) {
        MathTransform gridToCRS;
        GridGeometry geometry;
        if (coverage instanceof GridCoverage && (geometry = ((GridCoverage)coverage).getGridGeometry()) != null && (gridToCRS = geometry instanceof GridGeometry2D ? ((GridGeometry2D)geometry).getGridToCRS() : geometry.getGridToCRS()) instanceof AffineTransform) {
            return (AffineTransform)gridToCRS;
        }
        return null;
    }

    protected static double getScale(Coverage coverage) {
        AffineTransform gridToCRS = WCSTestSupport.getAffineTransform(coverage);
        return gridToCRS != null ? XAffineTransform.getScale((AffineTransform)gridToCRS) : Double.NaN;
    }

    protected Multipart getMultipart(MockHttpServletResponse response) throws MessagingException, IOException {
        MimeMessage body = new MimeMessage((Session)null, (InputStream)this.getBinaryInputStream(response));
        Multipart multipart = (Multipart)body.getContent();
        return multipart;
    }

    protected void setupRasterDimension(String coverageName, String metadataKey, DimensionPresentation presentation, Double resolution) {
        CoverageInfo info = this.getCatalog().getCoverageByName(coverageName);
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(presentation);
        if (resolution != null) {
            di.setResolution(new BigDecimal(resolution));
        }
        info.getMetadata().put(metadataKey, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void setupRasterDimension(String coverageName, String metadataKey, DimensionPresentation presentation, Double resolution, String unitSymbol) {
        CoverageInfo info = this.getCatalog().getCoverageByName(coverageName);
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(presentation);
        if (resolution != null) {
            di.setResolution(new BigDecimal(resolution));
        }
        if (unitSymbol != null) {
            di.setUnitSymbol(unitSymbol);
        }
        info.getMetadata().put(metadataKey, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void clearDimensions(String coverageName) {
        CoverageInfo info = this.getCatalog().getCoverageByName(coverageName);
        info.getMetadata().remove((Object)"time");
        info.getMetadata().remove((Object)"elevation");
        this.getCatalog().save((ResourceInfo)info);
    }

    static {
        UTM11 = new QName(MockData.WCS_URI, "utm11", MockData.WCS_PREFIX);
        boolean windows = false;
        try {
            windows = System.getProperty("os.name").matches(".*Windows.*");
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_WINDOWS = windows;
    }
}

